/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action;

import org.elasticsearch.action.admin.indices.analyze.AnalyzeRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.transport.TransportRequest;

public class SecurityActionMapper {
    static final String CLUSTER_PERMISSION_SCROLL_CLEAR_ALL_NAME = "cluster:admin/indices/scroll/clear_all";
    static final String CLUSTER_PERMISSION_ANALYZE = "cluster:admin/analyze";

    public String action(String action, TransportRequest request) {
        switch (action) {
            case "indices:data/read/scroll/clear": {
                assert (request instanceof ClearScrollRequest);
                boolean isClearAllScrollRequest = ((ClearScrollRequest)request).scrollIds().contains("_all");
                if (!isClearAllScrollRequest) break;
                return CLUSTER_PERMISSION_SCROLL_CLEAR_ALL_NAME;
            }
            case "indices:admin/analyze": 
            case "indices:admin/analyze[s]": {
                assert (request instanceof AnalyzeRequest);
                String[] indices = ((AnalyzeRequest)request).indices();
                if (indices != null && (indices.length != 1 || indices[0] != null)) break;
                return CLUSTER_PERMISSION_ANALYZE;
            }
        }
        return action;
    }
}

