/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.StrictErrorHandler;
import io.mola.galimatias.URL;
import io.mola.galimatias.URLParsingSettings;
import junit.framework.TestCase;

public final class URL2Test
extends TestCase {
    public void testOmittedHost() throws Exception {
        URL url = URL.parse("http:///path");
        URL2Test.assertEquals((String)"path", (String)url.host().toString());
        URL2Test.assertEquals((String)"/", (String)url.file());
        URL2Test.assertEquals((String)"/", (String)url.path());
    }

    public void testNoHost() throws Exception {
        URL url = URL.parse("http:/path");
        URL2Test.assertEquals((String)"http", (String)url.scheme());
        URL2Test.assertEquals((String)"path", (String)url.authority());
        URL2Test.assertEquals((String)"", (String)url.userInfo());
        URL2Test.assertEquals((String)"path", (String)url.host().toString());
        URL2Test.assertEquals((int)80, (int)url.port());
        URL2Test.assertEquals((int)80, (int)url.defaultPort());
        URL2Test.assertEquals((String)"/", (String)url.file());
        URL2Test.assertEquals((String)"/", (String)url.path());
        URL2Test.assertEquals(null, (String)url.query());
        URL2Test.assertEquals(null, (String)url.fragment());
    }

    public void testNoPath() throws Exception {
        URL url = URL.parse("http://host");
        URL2Test.assertEquals((String)"host", (String)url.host().toString());
        URL2Test.assertEquals((String)"/", (String)url.file());
        URL2Test.assertEquals((String)"/", (String)url.path());
    }

    public void testEmptyHostAndNoPath() throws Exception {
        try {
            URL.parse("http://");
            URL2Test.fail();
        }
        catch (GalimatiasParseException galimatiasParseException) {
            // empty catch block
        }
    }

    public void testNoHostAndNoPath() throws Exception {
        try {
            URL.parse("http:");
            URL2Test.fail();
        }
        catch (GalimatiasParseException galimatiasParseException) {
            // empty catch block
        }
    }

    public void testAtSignInUserInfo() throws Exception {
        URL url = URL.parse("http://user@userhost.com:password@host");
        URL2Test.assertEquals((String)"host", (String)url.host().toString());
        URL2Test.assertEquals((String)"user%40userhost.com:password", (String)url.userInfo());
        URLParsingSettings settings = URLParsingSettings.create().withErrorHandler(StrictErrorHandler.getInstance());
        try {
            URL.parse(settings, "http://user@userhost.com:password@host");
            URL2Test.fail();
        }
        catch (GalimatiasParseException galimatiasParseException) {
            // empty catch block
        }
    }

    public void testUserNoPassword() throws Exception {
        URL url = URL.parse("http://user@host");
        URL2Test.assertEquals((String)"user@host", (String)url.authority());
        URL2Test.assertEquals((String)"user", (String)url.userInfo());
        URL2Test.assertEquals((String)"host", (String)url.host().toString());
    }

    public void testUserNoPasswordExplicitPort() throws Exception {
        URL url = URL.parse("http://user@host:8080");
        URL2Test.assertEquals((String)"user@host:8080", (String)url.authority());
        URL2Test.assertEquals((String)"user", (String)url.userInfo());
        URL2Test.assertEquals((String)"host", (String)url.host().toString());
        URL2Test.assertEquals((int)8080, (int)url.port());
    }

    public void testUserPasswordHostPort() throws Exception {
        URL url = URL.parse("http://user:password@host:8080");
        URL2Test.assertEquals((String)"user:password@host:8080", (String)url.authority());
        URL2Test.assertEquals((String)"user:password", (String)url.userInfo());
        URL2Test.assertEquals((String)"host", (String)url.host().toString());
        URL2Test.assertEquals((int)8080, (int)url.port());
    }

    public void testUserPasswordEmptyHostPort() throws Exception {
        try {
            URL.parse("http://user:password@:8080");
        }
        catch (GalimatiasParseException galimatiasParseException) {
            // empty catch block
        }
    }

    public void testUserPasswordEmptyHostEmptyPort() throws Exception {
        try {
            URL.parse("http://user:password@");
            URL2Test.fail();
        }
        catch (GalimatiasParseException galimatiasParseException) {
            // empty catch block
        }
    }

    public void testPathOnly() throws Exception {
        URL url = URL.parse("http://host/path");
        URL2Test.assertEquals((String)"/path", (String)url.file());
        URL2Test.assertEquals((String)"/path", (String)url.path());
    }

    public void testQueryOnly() throws Exception {
        URL url = URL.parse("http://host?query");
        URL2Test.assertEquals((String)"/?query", (String)url.file());
        URL2Test.assertEquals((String)"/", (String)url.path());
        URL2Test.assertEquals((String)"query", (String)url.query());
    }

    public void testFragmentOnly() throws Exception {
        URL url = URL.parse("http://host#fragment");
        URL2Test.assertEquals((String)"/", (String)url.file());
        URL2Test.assertEquals((String)"/", (String)url.path());
        URL2Test.assertEquals((String)"fragment", (String)url.fragment());
    }

    public void testAtSignInPath() throws Exception {
        URL url = URL.parse("http://host/file@foo");
        URL2Test.assertEquals((String)"/file@foo", (String)url.file());
        URL2Test.assertEquals((String)"/file@foo", (String)url.path());
        URL2Test.assertEquals((String)"", (String)url.userInfo());
    }

    public void testColonInPath() throws Exception {
        URL url = URL.parse("http://host/file:colon");
        URL2Test.assertEquals((String)"/file:colon", (String)url.file());
        URL2Test.assertEquals((String)"/file:colon", (String)url.path());
    }

    public void testSlashInQuery() throws Exception {
        URL url = URL.parse("http://host/file?query/path");
        URL2Test.assertEquals((String)"/file?query/path", (String)url.file());
        URL2Test.assertEquals((String)"/file", (String)url.path());
        URL2Test.assertEquals((String)"query/path", (String)url.query());
    }

    public void testQuestionMarkInQuery() throws Exception {
        URL url = URL.parse("http://host/file?query?another");
        URL2Test.assertEquals((String)"/file?query?another", (String)url.file());
        URL2Test.assertEquals((String)"/file", (String)url.path());
        URL2Test.assertEquals((String)"query?another", (String)url.query());
    }

    public void testAtSignInQuery() throws Exception {
        URL url = URL.parse("http://host/file?query@at");
        URL2Test.assertEquals((String)"/file?query@at", (String)url.file());
        URL2Test.assertEquals((String)"/file", (String)url.path());
        URL2Test.assertEquals((String)"query@at", (String)url.query());
    }

    public void testColonInQuery() throws Exception {
        URL url = URL.parse("http://host/file?query:colon");
        URL2Test.assertEquals((String)"/file?query:colon", (String)url.file());
        URL2Test.assertEquals((String)"/file", (String)url.path());
        URL2Test.assertEquals((String)"query:colon", (String)url.query());
    }

    public void testQuestionMarkInFragment() throws Exception {
        URL url = URL.parse("http://host/file#fragment?query");
        URL2Test.assertEquals((String)"/file", (String)url.file());
        URL2Test.assertEquals((String)"/file", (String)url.path());
        URL2Test.assertEquals(null, (String)url.query());
        URL2Test.assertEquals((String)"fragment?query", (String)url.fragment());
    }

    public void testColonInFragment() throws Exception {
        URL url = URL.parse("http://host/file#fragment:80");
        URL2Test.assertEquals((String)"/file", (String)url.file());
        URL2Test.assertEquals((String)"/file", (String)url.path());
        URL2Test.assertEquals((int)80, (int)url.port());
        URL2Test.assertEquals((String)"fragment:80", (String)url.fragment());
    }

    public void testSlashInFragment() throws Exception {
        URL url = URL.parse("http://host/file#fragment/path");
        URL2Test.assertEquals((String)"/file", (String)url.file());
        URL2Test.assertEquals((String)"/file", (String)url.path());
        URL2Test.assertEquals((String)"fragment/path", (String)url.fragment());
    }

    public void testHashInFragment() throws Exception {
        URL url = URL.parse("http://host/file#fragment#another");
        URL2Test.assertEquals((String)"/file", (String)url.file());
        URL2Test.assertEquals((String)"/file", (String)url.path());
        URL2Test.assertEquals((String)"fragment#another", (String)url.fragment());
    }

    public void testEmptyPort() throws Exception {
        URL url = URL.parse("http://host:/");
        URL2Test.assertEquals((int)80, (int)url.port());
    }

    public void testNonNumericPort() throws Exception {
        try {
            URL.parse("http://host:x/");
            URL2Test.fail();
        }
        catch (GalimatiasParseException galimatiasParseException) {
            // empty catch block
        }
    }

    public void testNegativePort() throws Exception {
        try {
            URL.parse("http://host:-2/");
            URL2Test.fail();
        }
        catch (GalimatiasParseException galimatiasParseException) {
            // empty catch block
        }
    }

    public void testNegativePortEqualsPlaceholder() throws Exception {
        try {
            URL.parse("http://host:-1/");
            URL2Test.fail();
        }
        catch (GalimatiasParseException galimatiasParseException) {
            // empty catch block
        }
    }

    public void testRelativePathOnQuery() throws Exception {
        URL base = URL.parse("http://host/file?query/x");
        URL url = URL.parse(base, "another");
        URL2Test.assertEquals((String)"http://host/another", (String)url.toString());
        URL2Test.assertEquals((String)"/another", (String)url.file());
        URL2Test.assertEquals((String)"/another", (String)url.path());
        URL2Test.assertEquals(null, (String)url.query());
        URL2Test.assertEquals(null, (String)url.fragment());
    }

    public void testRelativeFragmentOnQuery() throws Exception {
        URL base = URL.parse("http://host/file?query/x#fragment");
        URL url = URL.parse(base, "#another");
        URL2Test.assertEquals((String)"http://host/file?query/x#another", (String)url.toString());
        URL2Test.assertEquals((String)"/file?query/x", (String)url.file());
        URL2Test.assertEquals((String)"/file", (String)url.path());
        URL2Test.assertEquals((String)"query/x", (String)url.query());
        URL2Test.assertEquals((String)"another", (String)url.fragment());
    }

    public void testPathContainsRelativeParts() throws Exception {
        URL url = URL.parse("http://host/a/b/../c");
        URL2Test.assertEquals((String)"http://host/a/c", (String)url.toString());
    }

    public void testRelativePathAndFragment() throws Exception {
        URL base = URL.parse("http://host/file");
        URL2Test.assertEquals((String)"http://host/another#fragment", (String)URL.parse(base, "another#fragment").toString());
    }

    public void testRelativeParentDirectory() throws Exception {
        URL base = URL.parse("http://host/a/b/c");
        URL2Test.assertEquals((String)"http://host/a/d", (String)URL.parse(base, "../d").toString());
    }

    public void testRelativeChildDirectory() throws Exception {
        URL base = URL.parse("http://host/a/b/c");
        URL2Test.assertEquals((String)"http://host/a/b/d/e", (String)URL.parse(base, "d/e").toString());
    }

    public void testRelativeRootDirectory() throws Exception {
        URL base = URL.parse("http://host/a/b/c");
        URL2Test.assertEquals((String)"http://host/d", (String)URL.parse(base, "/d").toString());
    }

    public void testRelativeFullUrl() throws Exception {
        URL base = URL.parse("http://host/a/b/c");
        URL2Test.assertEquals((String)"http://host2/d/e", (String)URL.parse(base, "http://host2/d/e").toString());
        URL2Test.assertEquals((String)"https://host2/d/e", (String)URL.parse(base, "https://host2/d/e").toString());
    }

    public void testRelativeDifferentScheme() throws Exception {
        URL base = URL.parse("http://host/a/b/c");
        URL2Test.assertEquals((String)"https://host2/d/e", (String)URL.parse(base, "https://host2/d/e").toString());
    }

    public void testRelativeDifferentAuthority() throws Exception {
        URL base = URL.parse("http://host/a/b/c");
        URL2Test.assertEquals((String)"http://another/d/e", (String)URL.parse(base, "//another/d/e").toString());
    }

    public void testRelativeWithScheme() throws Exception {
        URL base = URL.parse("http://host/a/b/c");
        URL2Test.assertEquals((String)"http://host/a/b/c", (String)URL.parse(base, "http:").toString());
        URL2Test.assertEquals((String)"http://host/", (String)URL.parse(base, "http:/").toString());
    }

    public void testRelativeFragmentOnly() throws Exception {
        URL base = URL.parse("http://host/a/b/c");
        URL2Test.assertEquals((String)"http://host/a/b/c#", (String)URL.parse(base, "#").toString());
    }

    public void testMalformedUrlsRefusedByFirefoxAndChrome() throws Exception {
        URL base = URL.parse("http://host/a/b/c");
        try {
            URL.parse(base, "http://");
            URL2Test.fail();
        }
        catch (GalimatiasParseException galimatiasParseException) {
            // empty catch block
        }
        try {
            URL.parse(base, "//");
            URL2Test.fail();
        }
        catch (GalimatiasParseException galimatiasParseException) {
            // empty catch block
        }
        try {
            URL.parse(base, "https:");
            URL2Test.fail();
        }
        catch (GalimatiasParseException galimatiasParseException) {
            // empty catch block
        }
        try {
            URL.parse("https:/");
            URL2Test.fail();
        }
        catch (GalimatiasParseException galimatiasParseException) {
            // empty catch block
        }
        try {
            URL.parse("https:/");
            URL2Test.fail();
        }
        catch (GalimatiasParseException galimatiasParseException) {
            // empty catch block
        }
        try {
            URL.parse("https://");
            URL2Test.fail();
        }
        catch (GalimatiasParseException galimatiasParseException) {
            // empty catch block
        }
    }

    public void testRfc1808NormalExamples() throws Exception {
        URL base = URL.parse("http://a/b/c/d;p?q");
        URL2Test.assertEquals((String)"https://h/", (String)URL.parse(base, "https:h").toString());
        URL2Test.assertEquals((String)"http://a/b/c/g", (String)URL.parse(base, "g").toString());
        URL2Test.assertEquals((String)"http://a/b/c/g", (String)URL.parse(base, "./g").toString());
        URL2Test.assertEquals((String)"http://a/b/c/g/", (String)URL.parse(base, "g/").toString());
        URL2Test.assertEquals((String)"http://a/g", (String)URL.parse(base, "/g").toString());
        URL2Test.assertEquals((String)"http://g/", (String)URL.parse(base, "//g").toString());
        URL2Test.assertEquals((String)"http://a/b/c/d;p?y", (String)URL.parse(base, "?y").toString());
        URL2Test.assertEquals((String)"http://a/b/c/g?y", (String)URL.parse(base, "g?y").toString());
        URL2Test.assertEquals((String)"http://a/b/c/d;p?q#s", (String)URL.parse(base, "#s").toString());
        URL2Test.assertEquals((String)"http://a/b/c/g#s", (String)URL.parse(base, "g#s").toString());
        URL2Test.assertEquals((String)"http://a/b/c/g?y#s", (String)URL.parse(base, "g?y#s").toString());
        URL2Test.assertEquals((String)"http://a/b/c/;x", (String)URL.parse(base, ";x").toString());
        URL2Test.assertEquals((String)"http://a/b/c/g;x", (String)URL.parse(base, "g;x").toString());
        URL2Test.assertEquals((String)"http://a/b/c/g;x?y#s", (String)URL.parse(base, "g;x?y#s").toString());
        URL2Test.assertEquals((String)"http://a/b/c/d;p?q", (String)URL.parse(base, "").toString());
        URL2Test.assertEquals((String)"http://a/b/c/", (String)URL.parse(base, ".").toString());
        URL2Test.assertEquals((String)"http://a/b/c/", (String)URL.parse(base, "./").toString());
        URL2Test.assertEquals((String)"http://a/b/", (String)URL.parse(base, "..").toString());
        URL2Test.assertEquals((String)"http://a/b/", (String)URL.parse(base, "../").toString());
        URL2Test.assertEquals((String)"http://a/b/g", (String)URL.parse(base, "../g").toString());
        URL2Test.assertEquals((String)"http://a/", (String)URL.parse(base, "../..").toString());
        URL2Test.assertEquals((String)"http://a/", (String)URL.parse(base, "../../").toString());
        URL2Test.assertEquals((String)"http://a/g", (String)URL.parse(base, "../../g").toString());
    }

    public void testRfc1808AbnormalExampleTooManyDotDotSequences() throws Exception {
        URL base = URL.parse("http://a/b/c/d;p?q");
        URL2Test.assertEquals((String)"http://a/g", (String)URL.parse(base, "../../../g").toString());
        URL2Test.assertEquals((String)"http://a/g", (String)URL.parse(base, "../../../../g").toString());
    }

    public void testRfc1808AbnormalExampleRemoveDotSegments() throws Exception {
        URL base = URL.parse("http://a/b/c/d;p?q");
        URL2Test.assertEquals((String)"http://a/g", (String)URL.parse(base, "/./g").toString());
        URL2Test.assertEquals((String)"http://a/g", (String)URL.parse(base, "/../g").toString());
        URL2Test.assertEquals((String)"http://a/b/c/g.", (String)URL.parse(base, "g.").toString());
        URL2Test.assertEquals((String)"http://a/b/c/.g", (String)URL.parse(base, ".g").toString());
        URL2Test.assertEquals((String)"http://a/b/c/g..", (String)URL.parse(base, "g..").toString());
        URL2Test.assertEquals((String)"http://a/b/c/..g", (String)URL.parse(base, "..g").toString());
    }

    public void testRfc1808AbnormalExampleNonsensicalDots() throws Exception {
        URL base = URL.parse("http://a/b/c/d;p?q");
        URL2Test.assertEquals((String)"http://a/b/g", (String)URL.parse(base, "./../g").toString());
        URL2Test.assertEquals((String)"http://a/b/c/g/", (String)URL.parse(base, "./g/.").toString());
        URL2Test.assertEquals((String)"http://a/b/c/g/h", (String)URL.parse(base, "g/./h").toString());
        URL2Test.assertEquals((String)"http://a/b/c/h", (String)URL.parse(base, "g/../h").toString());
        URL2Test.assertEquals((String)"http://a/b/c/g;x=1/y", (String)URL.parse(base, "g;x=1/./y").toString());
        URL2Test.assertEquals((String)"http://a/b/c/y", (String)URL.parse(base, "g;x=1/../y").toString());
    }

    public void testRfc1808AbnormalExampleRelativeScheme() throws Exception {
        URL base = URL.parse("http://a/b/c/d;p?q");
        URL2Test.assertEquals((String)"http://a/b/c/g", (String)URL.parse(base, "http:g").toString());
    }

    public void testRfc1808AbnormalExampleQueryOrFragmentDots() throws Exception {
        URL base = URL.parse("http://a/b/c/d;p?q");
        URL2Test.assertEquals((String)"http://a/b/c/g?y/./x", (String)URL.parse(base, "g?y/./x").toString());
        URL2Test.assertEquals((String)"http://a/b/c/g?y/../x", (String)URL.parse(base, "g?y/../x").toString());
        URL2Test.assertEquals((String)"http://a/b/c/g#s/./x", (String)URL.parse(base, "g#s/./x").toString());
        URL2Test.assertEquals((String)"http://a/b/c/g#s/../x", (String)URL.parse(base, "g#s/../x").toString());
    }

    public void testSquareBracketsInUserInfo() throws Exception {
        URL url = URL.parse("http://user:[::1]@host");
        URL2Test.assertEquals((String)"user:[::1]", (String)url.userInfo());
        URL2Test.assertEquals((String)"host", (String)url.host().toString());
    }

    public void testFileUrlExtraLeadingSlashes() throws Exception {
        URL url = URL.parse("file:////foo");
        URL2Test.assertEquals(null, (String)url.authority());
        URL2Test.assertEquals((String)"//foo", (String)url.path());
        URL2Test.assertEquals((String)"file:////foo", (String)url.toString());
    }

    public void testFileUrlWithAuthority() throws Exception {
        URL url = URL.parse("file://x/foo");
        URL2Test.assertEquals((String)"x", (String)url.authority());
        URL2Test.assertEquals((String)"/foo", (String)url.path());
        URL2Test.assertEquals((String)"file://x/foo", (String)url.toString());
    }

    public void testEmptyAuthority() throws Exception {
        URL url = URL.parse("http:///foo");
        URL2Test.assertEquals((String)"foo", (String)url.authority());
        URL2Test.assertEquals((String)"/", (String)url.path());
        URL2Test.assertEquals((String)"http://foo/", (String)url.toString());
    }

    public void testHttpUrlExtraLeadingSlashes() throws Exception {
        URL url = URL.parse("http:////foo");
        URL2Test.assertEquals((String)"foo", (String)url.authority());
        URL2Test.assertEquals((String)"/", (String)url.path());
        URL2Test.assertEquals((String)"http://foo/", (String)url.toString());
    }

    public void testFileUrlRelativePath() throws Exception {
        URL base = URL.parse("file:a/b/c");
        URL2Test.assertEquals((String)"file:///a/b/d", (String)URL.parse(base, "d").toString());
    }

    public void testFileUrlDottedPath() throws Exception {
        URL url = URL.parse("file:../a/b");
        URL2Test.assertEquals((String)"/a/b", (String)url.path());
        URL2Test.assertEquals((String)"file:///a/b", (String)url.toString());
    }

    public void testParsingDotAsHostname() throws Exception {
        try {
            URL url = URL.parse("http://./");
            URL2Test.fail();
        }
        catch (GalimatiasParseException galimatiasParseException) {
            // empty catch block
        }
    }

    public void testSquareBracketsWithIPv4() throws Exception {
        try {
            URL.parse("http://[192.168.0.1]/");
            URL2Test.fail();
        }
        catch (GalimatiasParseException galimatiasParseException) {
            // empty catch block
        }
    }

    public void testSquareBracketsWithHostname() throws Exception {
        try {
            URL.parse("http://[www.android.com]/");
            URL2Test.fail();
        }
        catch (GalimatiasParseException galimatiasParseException) {
            // empty catch block
        }
    }

    public void testIPv6WithoutSquareBrackets() throws Exception {
        try {
            URL.parse("http://fe80::1234/");
            URL2Test.fail();
        }
        catch (GalimatiasParseException galimatiasParseException) {
            // empty catch block
        }
    }

    public void testIpv6WithSquareBrackets() throws Exception {
        URL url = URL.parse("http://[::1]:2/");
        URL2Test.assertEquals((String)"::1", (String)url.host().toString());
        URL2Test.assertEquals((int)2, (int)url.port());
    }

    public void testEqualityWithNoPath() throws Exception {
        URL2Test.assertTrue((boolean)URL.parse("http://android.com").equals(URL.parse("http://android.com/")));
    }

    public void testSchemeCaseIsCanonicalized() throws Exception {
        URL url = URL.parse("HTTP://host/path");
        URL2Test.assertEquals((String)"http", (String)url.scheme());
    }

    public void testEmptyAuthorityWithPath() throws Exception {
        URL url = URL.parse("http:///path");
        URL2Test.assertEquals((String)"path", (String)url.authority());
        URL2Test.assertEquals((String)"/", (String)url.path());
    }

    public void testEmptyAuthorityWithQuery() throws Exception {
        try {
            URL.parse("http://?query");
            URL2Test.fail();
        }
        catch (GalimatiasParseException galimatiasParseException) {
            // empty catch block
        }
    }

    public void testEmptyAuthorityWithFragment() throws Exception {
        try {
            URL.parse("http://#fragment");
            URL2Test.fail();
        }
        catch (GalimatiasParseException galimatiasParseException) {
            // empty catch block
        }
    }

    public void testPartContainsSpace() throws Exception {
        try {
            URL.parse("ht tp://host/");
            URL2Test.fail();
        }
        catch (GalimatiasParseException galimatiasParseException) {
            // empty catch block
        }
        URL2Test.assertEquals((String)"user%20name", (String)URL.parse("http://user name@host/").username());
        try {
            URL.parse("http://ho st/");
            URL2Test.fail();
        }
        catch (GalimatiasParseException galimatiasParseException) {
            // empty catch block
        }
        try {
            URL.parse("http://host:80 80/");
            URL2Test.fail();
        }
        catch (GalimatiasParseException galimatiasParseException) {
            // empty catch block
        }
        URL2Test.assertEquals((String)"/fi%20le", (String)URL.parse("http://host/fi le").file());
        URL2Test.assertEquals((String)"que%20ry", (String)URL.parse("http://host/file?que ry").query());
        URL2Test.assertEquals((String)"re f", (String)URL.parse("http://host/file?query#re f").fragment());
    }

    public void testUnderscore() throws Exception {
        URL url = URL.parse("http://a_b.c.d.net/");
        URL2Test.assertEquals((String)"a_b.c.d.net", (String)url.authority());
        URL2Test.assertEquals((String)"a_b.c.d.net", (String)url.host().toString());
    }
}

