/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLParser;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class OPFHandler
implements XMLHandler {
    XMLParser parser;
    Hashtable itemMapById = new Hashtable();
    Hashtable itemMapByPath = new Hashtable();
    HashSet encryptedItemsSet;
    Vector spine = new Vector();
    Vector items = new Vector();
    String path;
    String uniqueIdent;
    boolean uniqueIdentExists = false;
    OPFItem toc;
    boolean opf12PackageFile = false;

    OPFHandler(XMLParser parser, String path) {
        this.parser = parser;
        this.path = path;
    }

    public boolean getOpf12PackageFile() {
        return this.opf12PackageFile;
    }

    public boolean getOpf20PackageFile() {
        return !this.opf12PackageFile;
    }

    public OPFItem getTOC() {
        return this.toc;
    }

    public OPFItem getItemById(String id) {
        return (OPFItem)this.itemMapById.get(id);
    }

    public OPFItem getItemByPath(String path) {
        return (OPFItem)this.itemMapByPath.get(path);
    }

    public int getSpineItemCount() {
        return this.spine.size();
    }

    public OPFItem getSpineItem(int index) {
        return (OPFItem)this.spine.elementAt(index);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public OPFItem getItem(int index) {
        return (OPFItem)this.items.elementAt(index);
    }

    public boolean checkUniqueIdentExists() {
        return this.uniqueIdentExists;
    }

    public void setEncryptedItemsSet(HashSet encryptedItemsSet) {
        this.encryptedItemsSet = encryptedItemsSet;
    }

    public void startElement() {
        String idAttr;
        String name;
        boolean registerEntry = true;
        XMLElement e = this.parser.getCurrentElement();
        String ns = e.getNamespace();
        if (ns == null || ns.equals("") || ns.equals("http://openebook.org/namespaces/oeb-package/1.0/") || ns.equals("http://www.idpf.org/2007/opf")) {
            String name2 = e.getName();
            if (name2.equals("package")) {
                String uniqueIdentAttr;
                if (!ns.equals("http://www.idpf.org/2007/opf")) {
                    this.parser.getReport().warning(this.path, this.parser.getLineNumber(), "OPF file is using OEBPS 1.2 syntax allowing backwards compatibility");
                    this.opf12PackageFile = true;
                }
                if ((uniqueIdentAttr = e.getAttribute("unique-identifier")) != null && !uniqueIdentAttr.equals("")) {
                    this.uniqueIdent = uniqueIdentAttr;
                } else {
                    this.parser.getReport().error(this.path, this.parser.getLineNumber(), "unique-identifier attribute in package element must be present and have a value");
                }
            } else if (name2.equals("item")) {
                String id = e.getAttribute("id");
                String href = e.getAttribute("href");
                if (href != null) {
                    try {
                        if (this.encryptedItemsSet != null && this.encryptedItemsSet.contains(URLDecoder.decode(href, "UTF-8"))) {
                            registerEntry = false;
                            if (this.isNotRequiredContent(href)) {
                                this.parser.getReport().warning(this.path, this.parser.getLineNumber(), href + " is an encrypted non-required entry! Epubcheck will not validate " + href);
                            } else {
                                this.parser.getReport().error(this.path, this.parser.getLineNumber(), href + " is an encrypted required entry! \nEpubcheck will not validate ePubs with encrypted required content files! Tool will EXIT");
                                System.exit(1);
                            }
                        }
                    }
                    catch (Exception ex) {
                        System.err.println("Error decoding entry: " + name2);
                        ex.printStackTrace();
                        this.parser.getReport().error(this.path, this.parser.getLineNumber(), ex.getMessage());
                    }
                    try {
                        href = PathUtil.resolveRelativeReference(this.path, href);
                    }
                    catch (IllegalArgumentException ex) {
                        this.parser.getReport().error(this.path, this.parser.getLineNumber(), ex.getMessage());
                        href = null;
                    }
                }
                String mimeType = e.getAttribute("media-type");
                String fallback = e.getAttribute("fallback");
                String fallbackStyle = e.getAttribute("fallback-style");
                String namespace = e.getAttribute("island-type");
                OPFItem item = new OPFItem(id, href, mimeType, fallback, fallbackStyle, namespace, this.parser.getLineNumber());
                if (id != null) {
                    this.itemMapById.put(id, item);
                }
                if (href != null && registerEntry) {
                    this.itemMapByPath.put(href, item);
                    this.items.add(item);
                }
            } else if (name2.equals("spine")) {
                String idref = e.getAttribute("toc");
                if (idref != null) {
                    this.toc = (OPFItem)this.itemMapById.get(idref);
                    if (this.toc == null) {
                        this.parser.getReport().error(this.path, this.parser.getLineNumber(), "item with id '" + idref + "' not found");
                    } else {
                        this.toc.setNcx(true);
                    }
                }
            } else if (name2.equals("itemref")) {
                String idref = e.getAttribute("idref");
                if (idref != null) {
                    OPFItem item = this.getItemById(idref);
                    if (item != null) {
                        this.spine.add(item);
                    } else {
                        this.parser.getReport().error(this.path, this.parser.getLineNumber(), "item with id '" + idref + "' not found");
                    }
                }
            } else if ((name2.equals("dc-metadata") || name2.equals("x-metadata")) && !this.opf12PackageFile) {
                this.parser.getReport().error(this.path, this.parser.getLineNumber(), "use of deprecated element '" + name2 + "'");
            }
        } else if (ns.equals("http://purl.org/dc/elements/1.1/") && (name = e.getName()).equals("identifier") && (idAttr = e.getAttribute("id")) != null && !idAttr.equals("") && idAttr.equals(this.uniqueIdent)) {
            this.uniqueIdentExists = true;
        }
    }

    public boolean isNotRequiredContent(String href) {
        if (href.endsWith(".opf")) {
            return false;
        }
        if (href.endsWith(".html")) {
            return false;
        }
        if (href.endsWith(".ncx")) {
            return false;
        }
        if (href.endsWith(".xpgt")) {
            return false;
        }
        return !href.endsWith(".xhtml");
    }

    public void endElement() {
    }

    public void ignorableWhitespace(char[] chars, int arg1, int arg2) {
    }

    public void characters(char[] chars, int arg1, int arg2) {
    }

    public void processingInstruction(String arg0, String arg1) {
    }
}

