#!/usr/pkg/bin/ruby32
# $Id: scrape-MDAPI-1-tiderefs.rb 7384 2020-12-23 19:24:26Z flaterco $
# 2017-12-17 15:55
# Given harcon.json from scrape-MDAPI-0-stationlists.sh, get the harmonic
# constants and datums for all tide reference stations.
# API documented at: https://api.tidesandcurrents.noaa.gov/mdapi/prod/
# If it should go away, there is another one at https://opendap.co-ops.nos.noaa.gov/ioos-dif-sos/

require 'json'

subdir = "tiderefs"
Dir.mkdir(subdir) unless File.exist?(subdir)

Dir.chdir(subdir) do
  unless File.exist?("urls.txt")
    harcon = JSON.parse(File.read("../harcon.json"))
    File.open("urls.txt", "w") do |outf|
      harcon["stations"].each {|x|
	outf.puts x["datums"]["self"]
	outf.puts x["harmonicConstituents"]["self"]
      }
    end
  end

  system "wget --force-directories --no-host-directories --cut-dirs=4 --wait=10 --random-wait --no-clobber --input-file=urls.txt --append-output=scrape_log.txt"
end
