/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.predictions;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.campagnelab.goby.util.Variant;

public class MergeIndelFrom {
    Set<String> tos = new ObjectArraySet();
    String from;
    private Object2ObjectMap<String, String> mapBeforeAfter = new Object2ObjectArrayMap();

    public Set<String> getTos() {
        return this.tos;
    }

    public String getFrom() {
        return this.from;
    }

    public String mapped(String originalAllele) {
        return (String)this.mapBeforeAfter.get((Object)originalAllele);
    }

    public MergeIndelFrom(Set<Variant.FromTo> fromTos) {
        if (fromTos.size() == 0) {
            this.from = ".";
            this.tos.add(".");
            return;
        }
        assert (fromTos.size() > 0) : "a non-empty set is expected.";
        String longestFrom = fromTos.parallelStream().reduce(fromTos.iterator().next(), (s, fromTo) -> {
            s = fromTo.getFrom().length() < s.getFrom().length() ? s : fromTo;
            return s;
        }).getFrom();
        ObjectArraySet splits = new ObjectArraySet(fromTos.size());
        for (Variant.FromTo fromTo2 : fromTos) {
            if (!fromTo2.getFrom().equals(longestFrom)) {
                fromTo2.append(longestFrom.substring(fromTo2.getFrom().length(), longestFrom.length()));
            }
            splits.add(new SplitIndel(fromTo2));
        }
        String longestDfAndTail = "";
        int maxLen = 0;
        for (Object split : splits) {
            if (((SplitIndel)split).lenDelFromAndTail <= maxLen) continue;
            maxLen = ((SplitIndel)split).lenDelFromAndTail;
            longestDfAndTail = ((SplitIndel)split).delFrom + ((SplitIndel)split).tail;
        }
        for (Object split : splits) {
            if (((SplitIndel)split).lenDelFromAndTail >= maxLen) continue;
            ((SplitIndel)split).tail = longestDfAndTail.substring(((SplitIndel)split).delFrom.length());
        }
        int maxDashLen = 0;
        for (SplitIndel split : splits) {
            maxDashLen = Math.max(maxDashLen, split.insLen);
        }
        String maxDashToAppend = new String(new char[maxDashLen]).replace("\u0000", "-");
        for (SplitIndel split : splits) {
            int numDashToAdd = maxDashLen - split.insLen;
            split.insFrom = maxDashToAppend.substring(0, numDashToAdd) + split.insFrom;
            split.insTo = maxDashToAppend.substring(0, numDashToAdd) + split.insTo;
        }
        for (SplitIndel split : splits) {
            String to = split.getTo();
            this.tos.add(to);
            this.mapBeforeAfter.put((Object)split.originalTo, (Object)to);
            if (this.from != null) continue;
            this.from = split.fromTo.getFrom();
            this.mapBeforeAfter.put((Object)split.originalFrom, (Object)this.from);
        }
    }

    public static class SplitIndel {
        final Variant.FromTo fromTo;
        final String originalFrom;
        final String originalTo;
        char baseFrom;
        char baseTo;
        String insFrom;
        String delFrom;
        String insTo;
        String delTo;
        String tail;
        int lenDelFromAndTail = 0;
        int delLen = 0;
        int insLen = 0;

        public SplitIndel(Variant.FromTo fromTo) {
            String from = fromTo.getFrom();
            String to = fromTo.getTo();
            this.originalFrom = fromTo.getOriginalFrom();
            this.originalTo = fromTo.getOriginalTo();
            this.insFrom = "";
            this.delFrom = "";
            this.insTo = "";
            this.delTo = "";
            this.baseFrom = from.charAt(0);
            this.baseTo = to.charAt(0);
            this.delLen = StringUtils.countMatches((String)to, (String)"-");
            this.insLen = StringUtils.countMatches((String)from, (String)"-");
            this.tail = "";
            this.fromTo = fromTo;
            if (to.length() > 1) {
                this.tail = to.substring(1);
            }
            if (this.delLen == 0 && this.insLen == 0) {
                return;
            }
            if (from.length() > this.insLen + 1 && from.length() > 1) {
                this.insFrom = from.substring(1, this.insLen + 1);
            }
            if (to.length() > this.insLen + 1 && from.length() > 1) {
                this.insTo = to.substring(1, this.insLen + 1);
            }
            if (from.length() > 1 + this.insLen && from.length() > 1 + this.insLen + this.delLen) {
                this.delFrom = from.substring(1 + this.insLen, 1 + this.insLen + this.delLen);
            }
            if (to.length() > this.insLen + 1 && from.length() > this.insLen + this.delLen) {
                this.delTo = to.substring(1 + this.insLen, 1 + this.insLen + this.delLen);
            }
            if (to.length() > 1 + this.insLen + this.delLen) {
                this.tail = to.substring(1 + this.insLen + this.delLen, to.length());
            }
            this.lenDelFromAndTail = this.delFrom.length() + this.tail.length();
        }

        String getFrom() {
            return this.baseFrom + this.insFrom + this.delFrom + this.tail;
        }

        String getTo() {
            return this.baseTo + this.insTo + this.delTo + this.tail;
        }

        public String toString() {
            return this.getFrom() + "/" + this.getTo();
        }
    }
}

