/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.CommandLineTokenizer;
import com.martiansoftware.jsap.DefaultSource;
import com.martiansoftware.jsap.Defaults;
import com.martiansoftware.jsap.ExceptionMap;
import com.martiansoftware.jsap.Flagged;
import com.martiansoftware.jsap.IDMap;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Option;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.Parser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.BigDecimalStringParser;
import com.martiansoftware.jsap.stringparsers.BigIntegerStringParser;
import com.martiansoftware.jsap.stringparsers.BooleanStringParser;
import com.martiansoftware.jsap.stringparsers.ByteStringParser;
import com.martiansoftware.jsap.stringparsers.CharacterStringParser;
import com.martiansoftware.jsap.stringparsers.ClassStringParser;
import com.martiansoftware.jsap.stringparsers.ColorStringParser;
import com.martiansoftware.jsap.stringparsers.DoubleStringParser;
import com.martiansoftware.jsap.stringparsers.FloatStringParser;
import com.martiansoftware.jsap.stringparsers.InetAddressStringParser;
import com.martiansoftware.jsap.stringparsers.IntSizeStringParser;
import com.martiansoftware.jsap.stringparsers.IntegerStringParser;
import com.martiansoftware.jsap.stringparsers.LongSizeStringParser;
import com.martiansoftware.jsap.stringparsers.LongStringParser;
import com.martiansoftware.jsap.stringparsers.PackageStringParser;
import com.martiansoftware.jsap.stringparsers.ShortStringParser;
import com.martiansoftware.jsap.stringparsers.StringStringParser;
import com.martiansoftware.jsap.stringparsers.URLStringParser;
import com.martiansoftware.jsap.xml.JSAPConfig;
import com.martiansoftware.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JSAP {
    private Map paramsByID = null;
    private Map paramsByShortFlag = null;
    private Map paramsByLongFlag = null;
    private List unflaggedOptions = null;
    private List paramsByDeclarationOrder = null;
    private List defaultSources = null;
    private String usage = null;
    private String help = null;
    public static final char NO_SHORTFLAG = '\u0000';
    public static final String NO_LONGFLAG = null;
    public static final char DEFAULT_LISTSEPARATOR = File.pathSeparatorChar;
    public static final String DEFAULT_PARAM_HELP_SEPARATOR = "\n";
    public static final boolean REQUIRED = true;
    public static final boolean NOT_REQUIRED = false;
    public static final boolean LIST = true;
    public static final boolean NOT_LIST = false;
    public static final boolean MULTIPLEDECLARATIONS = true;
    public static final boolean NO_MULTIPLEDECLARATIONS = false;
    public static final boolean GREEDY = true;
    public static final boolean NOT_GREEDY = false;
    public static final String NO_DEFAULT = null;
    public static final String NO_HELP = null;
    public static final BigDecimalStringParser BIGDECIMAL_PARSER = BigDecimalStringParser.getParser();
    public static final BigIntegerStringParser BIGINTEGER_PARSER = BigIntegerStringParser.getParser();
    public static final BooleanStringParser BOOLEAN_PARSER = BooleanStringParser.getParser();
    public static final ByteStringParser BYTE_PARSER = ByteStringParser.getParser();
    public static final CharacterStringParser CHARACTER_PARSER = CharacterStringParser.getParser();
    public static final ClassStringParser CLASS_PARSER = ClassStringParser.getParser();
    public static final ColorStringParser COLOR_PARSER = ColorStringParser.getParser();
    public static final DoubleStringParser DOUBLE_PARSER = DoubleStringParser.getParser();
    public static final FloatStringParser FLOAT_PARSER = FloatStringParser.getParser();
    public static final InetAddressStringParser INETADDRESS_PARSER = InetAddressStringParser.getParser();
    public static final IntegerStringParser INTEGER_PARSER = IntegerStringParser.getParser();
    public static final IntSizeStringParser INTSIZE_PARSER = IntSizeStringParser.getParser();
    public static final LongSizeStringParser LONGSIZE_PARSER = LongSizeStringParser.getParser();
    public static final LongStringParser LONG_PARSER = LongStringParser.getParser();
    public static final PackageStringParser PACKAGE_PARSER = PackageStringParser.getParser();
    public static final ShortStringParser SHORT_PARSER = ShortStringParser.getParser();
    public static final StringStringParser STRING_PARSER = StringStringParser.getParser();
    public static final URLStringParser URL_PARSER = URLStringParser.getParser();
    public static final int DEFAULT_SCREENWIDTH = 80;
    static char SYNTAX_SPACECHAR = (char)32;

    public JSAP() {
        this.init();
    }

    public JSAP(URL jsapXML) throws IOException, JSAPException {
        this.init();
        JSAPConfig.configure(this, jsapXML);
    }

    public JSAP(String resourceName) throws IOException, JSAPException {
        this(JSAP.class.getClassLoader().getResource(resourceName));
    }

    private void init() {
        this.paramsByID = new HashMap();
        this.paramsByShortFlag = new HashMap();
        this.paramsByLongFlag = new HashMap();
        this.unflaggedOptions = new ArrayList();
        this.paramsByDeclarationOrder = new ArrayList();
        this.defaultSources = new ArrayList();
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public String getHelp() {
        return this.getHelp(80, DEFAULT_PARAM_HELP_SEPARATOR);
    }

    public String getHelp(int screenWidth) {
        return this.getHelp(screenWidth, DEFAULT_PARAM_HELP_SEPARATOR);
    }

    public String getHelp(int screenWidth, String paramSeparator) {
        String result = this.help;
        if (result == null) {
            StringBuffer buf = new StringBuffer();
            int wrapWidth = screenWidth - 8;
            Iterator i = this.paramsByDeclarationOrder.iterator();
            while (i.hasNext()) {
                Parameter param = (Parameter)i.next();
                StringBuffer defaultText = new StringBuffer();
                String[] defaultValue = param.getDefault();
                if (!(param instanceof Switch) && defaultValue != null) {
                    defaultText.append(" (default: ");
                    for (int j = 0; j < defaultValue.length; ++j) {
                        if (j > 0) {
                            defaultText.append(", ");
                        }
                        defaultText.append(defaultValue[j]);
                    }
                    defaultText.append(")");
                }
                Iterator helpInfo = StringUtils.wrapToList(param.getHelp() + defaultText, wrapWidth).iterator();
                buf.append("  ");
                buf.append(param.getSyntax());
                buf.append(DEFAULT_PARAM_HELP_SEPARATOR);
                while (helpInfo.hasNext()) {
                    buf.append("        ");
                    buf.append(helpInfo.next());
                    buf.append(DEFAULT_PARAM_HELP_SEPARATOR);
                }
                if (!i.hasNext()) continue;
                buf.append(paramSeparator);
            }
            result = buf.toString();
        }
        return result;
    }

    public String getUsage() {
        String result = this.usage;
        if (result == null) {
            StringBuffer buf = new StringBuffer();
            for (Parameter param : this.paramsByDeclarationOrder) {
                if (buf.length() > 0) {
                    buf.append(" ");
                }
                buf.append(param.getSyntax());
            }
            result = buf.toString();
        }
        return result;
    }

    public String toString() {
        return this.getUsage();
    }

    public IDMap getIDMap() {
        ArrayList<String> ids = new ArrayList<String>(this.paramsByDeclarationOrder.size());
        for (Parameter param : this.paramsByDeclarationOrder) {
            ids.add(param.getID());
        }
        HashMap<Character, String> byShortFlag = new HashMap<Character, String>();
        for (Character c : this.paramsByShortFlag.keySet()) {
            byShortFlag.put(c, ((Parameter)this.paramsByShortFlag.get(c)).getID());
        }
        HashMap<String, String> byLongFlag = new HashMap<String, String>();
        for (String s : this.paramsByLongFlag.keySet()) {
            byLongFlag.put(s, ((Parameter)this.paramsByLongFlag.get(s)).getID());
        }
        return new IDMap(ids, byShortFlag, byLongFlag);
    }

    public Parameter getByID(String id) {
        return (Parameter)this.paramsByID.get(id);
    }

    public Flagged getByLongFlag(String longFlag) {
        return (Flagged)this.paramsByLongFlag.get(longFlag);
    }

    public Flagged getByShortFlag(Character shortFlag) {
        return (Flagged)this.paramsByShortFlag.get(shortFlag);
    }

    public Flagged getByShortFlag(char shortFlag) {
        return this.getByShortFlag(new Character(shortFlag));
    }

    public Iterator getUnflaggedOptionsIterator() {
        return this.unflaggedOptions.iterator();
    }

    public void registerDefaultSource(DefaultSource ds) {
        this.defaultSources.add(ds);
    }

    public void unregisterDefaultSource(DefaultSource ds) {
        this.defaultSources.remove(ds);
    }

    private Defaults getSystemDefaults() {
        Defaults defaults = new Defaults();
        for (Parameter param : this.paramsByDeclarationOrder) {
            defaults.setDefault(param.getID(), param.getDefault());
        }
        return defaults;
    }

    private void combineDefaults(Defaults dest, Defaults src) {
        if (src != null) {
            Iterator i = src.idIterator();
            while (i.hasNext()) {
                String paramID = (String)i.next();
                dest.setDefaultIfNeeded(paramID, src.getDefault(paramID));
            }
        }
    }

    protected Defaults getDefaults(ExceptionMap exceptionMap) {
        Defaults defaults = new Defaults();
        IDMap idMap = this.getIDMap();
        for (DefaultSource ds : this.defaultSources) {
            this.combineDefaults(defaults, ds.getDefaults(idMap, exceptionMap));
        }
        this.combineDefaults(defaults, this.getSystemDefaults());
        return defaults;
    }

    public void registerParameter(Parameter param) throws JSAPException {
        Flagged f;
        String paramID = param.getID();
        if (this.paramsByID.containsKey(paramID)) {
            throw new JSAPException("A parameter with ID '" + paramID + "' has already been registered.");
        }
        if (param instanceof Flagged) {
            f = (Flagged)((Object)param);
            if (f.getShortFlagCharacter() == null && f.getLongFlag() == null) {
                throw new JSAPException("FlaggedOption '" + paramID + "' has no flags defined.");
            }
            if (this.paramsByShortFlag.containsKey(f.getShortFlagCharacter())) {
                throw new JSAPException("A parameter with short flag '" + f.getShortFlag() + "' has already been registered.");
            }
            if (this.paramsByLongFlag.containsKey(f.getLongFlag())) {
                throw new JSAPException("A parameter with long flag '" + f.getLongFlag() + "' has already been registered.");
            }
        } else if (this.unflaggedOptions.size() > 0 && ((UnflaggedOption)this.unflaggedOptions.get(this.unflaggedOptions.size() - 1)).isGreedy()) {
            throw new JSAPException("A greedy unflagged option has already been registered; option '" + paramID + "' will never be reached.");
        }
        if (param instanceof Option) {
            ((Option)param).register();
        }
        param.setLocked(true);
        this.paramsByID.put(paramID, param);
        this.paramsByDeclarationOrder.add(param);
        if (param instanceof Flagged) {
            f = (Flagged)((Object)param);
            if (f.getShortFlagCharacter() != null) {
                this.paramsByShortFlag.put(f.getShortFlagCharacter(), param);
            }
            if (f.getLongFlag() != null) {
                this.paramsByLongFlag.put(f.getLongFlag(), param);
            }
        } else if (param instanceof Option) {
            this.unflaggedOptions.add(param);
        }
    }

    public void unregisterParameter(Parameter param) {
        if (this.paramsByID.containsKey(param.getID())) {
            if (param instanceof Option) {
                ((Option)param).unregister();
            }
            this.paramsByID.remove(param.getID());
            this.paramsByDeclarationOrder.remove(param);
            if (param instanceof Flagged) {
                Flagged f = (Flagged)((Object)param);
                this.paramsByShortFlag.remove(f.getShortFlagCharacter());
                this.paramsByLongFlag.remove(f.getLongFlag());
            } else if (param instanceof UnflaggedOption) {
                this.unflaggedOptions.remove(param);
            }
            param.setLocked(false);
        }
    }

    public JSAPResult parse(String[] args) {
        Parser p = new Parser(this, args);
        return p.parse();
    }

    public JSAPResult parse(String cmdLine) {
        String[] args = CommandLineTokenizer.tokenize(cmdLine);
        return this.parse(args);
    }

    public void finalize() {
        Parameter[] params = this.paramsByDeclarationOrder.toArray(new Parameter[0]);
        int paramCount = params.length;
        for (int i = 0; i < paramCount; ++i) {
            this.unregisterParameter(params[i]);
        }
    }

    static {
        if (Boolean.valueOf(System.getProperty("com.martiansoftware.jsap.usenbsp", "false")).booleanValue()) {
            SYNTAX_SPACECHAR = (char)160;
        }
    }
}

