/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.spdy.frames.DataFrame;

public abstract class DataFrameParser {
    private State state = State.STREAM_ID;
    private int cursor;
    private int streamId;
    private byte flags;
    private int length;

    public boolean parse(ByteBuffer buffer) {
        block7: while (buffer.hasRemaining()) {
            switch (this.state) {
                case STREAM_ID: {
                    if (buffer.remaining() >= 4) {
                        this.streamId = buffer.getInt() & Integer.MAX_VALUE;
                        this.state = State.FLAGS;
                        continue block7;
                    }
                    this.state = State.STREAM_ID_BYTES;
                    this.cursor = 4;
                    continue block7;
                }
                case STREAM_ID_BYTES: {
                    byte currByte = buffer.get();
                    --this.cursor;
                    this.streamId += (currByte & 0xFF) << 8 * this.cursor;
                    if (this.cursor != 0) continue block7;
                    this.state = State.FLAGS;
                    continue block7;
                }
                case FLAGS: {
                    this.flags = buffer.get();
                    this.cursor = 3;
                    this.state = State.LENGTH;
                    continue block7;
                }
                case LENGTH: {
                    byte currByte = buffer.get();
                    --this.cursor;
                    this.length += (currByte & 0xFF) << 8 * this.cursor;
                    if (this.cursor > 0) continue block7;
                    this.state = State.DATA;
                    if (this.length > 0) continue block7;
                }
                case DATA: {
                    int size = Math.min(this.length, buffer.remaining());
                    int limit = buffer.limit();
                    buffer.limit(buffer.position() + size);
                    ByteBuffer bytes = buffer.slice();
                    buffer.limit(limit);
                    buffer.position(buffer.position() + size);
                    this.length -= size;
                    if (this.length == 0) {
                        this.onDataFrame(bytes);
                        return true;
                    }
                    this.onDataFragment(bytes);
                    continue block7;
                }
            }
            throw new IllegalStateException();
        }
        return false;
    }

    private void onDataFrame(ByteBuffer bytes) {
        DataFrame frame = new DataFrame(this.streamId, this.flags, bytes.remaining());
        this.onDataFrame(frame, bytes);
        this.reset();
    }

    private void onDataFragment(ByteBuffer bytes) {
        DataFrame frame = new DataFrame(this.streamId, (byte)(this.flags & 0xFFFFFFFE), bytes.remaining());
        this.onDataFrame(frame, bytes);
    }

    protected abstract void onDataFrame(DataFrame var1, ByteBuffer var2);

    private void reset() {
        this.state = State.STREAM_ID;
        this.cursor = 0;
        this.streamId = 0;
        this.flags = 0;
        this.length = 0;
    }

    private static enum State {
        STREAM_ID,
        STREAM_ID_BYTES,
        FLAGS,
        LENGTH,
        DATA;

    }
}

