/*
 * Decompiled with CFR 0.152.
 */
package free.jin.ui;

import free.jin.BadChangesException;
import free.jin.I18n;
import free.jin.Jin;
import free.jin.ui.PreferencesPanel;
import free.util.PlatformUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LookAndFeelPrefPanel
extends PreferencesPanel {
    private static boolean extraLnFsInstalled = false;
    private final JList lookAndFeels;

    public LookAndFeelPrefPanel() {
        int n;
        int n2;
        LookAndFeelPrefPanel.installExtraLookAndFeels();
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        LnF[] lnFArray = new LnF[lookAndFeelInfoArray.length];
        for (n2 = 0; n2 < lnFArray.length; ++n2) {
            lnFArray[n2] = new LnF(lookAndFeelInfoArray[n2]);
        }
        if (System.getSecurityManager() != null && PlatformUtils.isJavaBetterThan("1.5")) {
            n2 = -1;
            for (n = 0; n < lnFArray.length; ++n) {
                if (!lnFArray[n].classname.equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel")) continue;
                n2 = n;
                break;
            }
            if (n2 != -1) {
                int n3;
                LnF[] lnFArray2 = new LnF[lnFArray.length - 1];
                for (n3 = 0; n3 < n2; ++n3) {
                    lnFArray2[n3] = lnFArray[n3];
                }
                for (n3 = n2; n3 < lnFArray2.length; ++n3) {
                    lnFArray2[n3] = lnFArray[n3 + 1];
                }
                lnFArray = lnFArray2;
            }
        }
        this.lookAndFeels = new JList<LnF>(lnFArray);
        String string = Jin.getInstance().getPrefs().getString("lookAndFeel.classname");
        for (n = 0; n < this.lookAndFeels.getModel().getSize(); ++n) {
            String string2 = ((LnF)this.lookAndFeels.getModel().getElementAt((int)n)).classname;
            if (!string.equals(string2)) continue;
            this.lookAndFeels.setSelectedIndex(n);
            this.lookAndFeels.ensureIndexIsVisible(n);
            break;
        }
        this.createUI();
    }

    private static synchronized void installExtraLookAndFeels() {
        if (extraLnFsInstalled) {
            return;
        }
        extraLnFsInstalled = true;
        int n = Integer.parseInt(Jin.getInstance().getAppProperty("lf.extra.count", "0"));
        for (int i = 0; i < n; ++i) {
            String string = Jin.getInstance().getAppProperty("lf.extra." + i + ".name", null);
            String string2 = Jin.getInstance().getAppProperty("lf.extra." + i + ".class", null);
            String string3 = Jin.getInstance().getAppProperty("lf.extra." + i + ".minRequiredJava", "0");
            if (!PlatformUtils.isJavaBetterThan(string3)) continue;
            try {
                Class.forName(string2);
                UIManager.installLookAndFeel(string, string2);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private void createUI() {
        this.lookAndFeels.setSelectionMode(0);
        this.lookAndFeels.setVisibleRowCount(Math.max(5, Math.min(this.lookAndFeels.getModel().getSize(), 10)));
        JScrollPane jScrollPane = new JScrollPane(this.lookAndFeels);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
        this.add(Box.createHorizontalStrut(150), "South");
        this.lookAndFeels.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LookAndFeelPrefPanel.this.fireStateChanged();
            }
        });
    }

    public void applyChanges() throws BadChangesException {
        LnF lnF = (LnF)this.lookAndFeels.getSelectedValue();
        if (lnF == null) {
            I18n i18n = I18n.get(LookAndFeelPrefPanel.class);
            throw new BadChangesException(i18n.getString("noLookNFeelSelectedErrorMessage"), this);
        }
        Jin.getInstance().getPrefs().setString("lookAndFeel.classname", lnF.classname);
    }

    private static class LnF {
        public final String name;
        public final String classname;

        public LnF(UIManager.LookAndFeelInfo lookAndFeelInfo) {
            this.name = lookAndFeelInfo.getName();
            this.classname = lookAndFeelInfo.getClassName();
        }

        public String toString() {
            return this.name;
        }
    }
}

