/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.TransportCcEngine;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.nlj.util.DataSize;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.InstantKt;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b&\u0018\u00002\u00020\u0001:\u0001JB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JF\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010#\u001a\u0004\u0018\u00010!2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020+JH\u0010,\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010#\u001a\u0004\u0018\u00010!2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020+H$J \u0010-\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010!2\u0006\u0010$\u001a\u00020%J\"\u0010.\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010!2\u0006\u0010$\u001a\u00020%H$J\u000e\u0010/\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0010\u00100\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H$J\u0016\u00101\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u00102\u001a\u000203J\u0018\u00104\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u00102\u001a\u000203H$J\u0017\u00105\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!H&\u00a2\u0006\u0004\b6\u00107J\u0012\u00108\u001a\u0002092\b\b\u0002\u0010 \u001a\u00020!H&J\b\u0010:\u001a\u00020\u001fH&J\u001f\u0010C\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010D\u001a\u00020\u0013H\u0004\u00a2\u0006\u0004\bE\u0010FJ\u000e\u0010G\u001a\u00020\u001f2\u0006\u0010H\u001a\u00020=J\u000e\u0010I\u001a\u00020\u001f2\u0006\u0010H\u001a\u00020=R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00020\u0013X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\u00020\u0013X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u0018\u0010\u001b\u001a\u00020\u0013X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u0017R\u0014\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010>\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010?R\u000e\u0010@\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010A\u001a\n \n*\u0004\u0018\u00010303X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010B\u00a8\u0006K"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator;", "", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "<init>", "(Lorg/jitsi/utils/logging/DiagnosticContext;)V", "getDiagnosticContext", "()Lorg/jitsi/utils/logging/DiagnosticContext;", "timeSeriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "kotlin.jvm.PlatformType", "getTimeSeriesLogger", "()Lorg/jitsi/utils/logging/TimeSeriesLogger;", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "algorithmName", "", "getAlgorithmName", "()Ljava/lang/String;", "initBw", "Lorg/jitsi/nlj/util/Bandwidth;", "getInitBw-rlWvAKk", "()J", "setInitBw-_2icLw0", "(J)V", "minBw", "getMinBw-rlWvAKk", "setMinBw-_2icLw0", "maxBw", "getMaxBw-rlWvAKk", "setMaxBw-_2icLw0", "processPacketArrival", "", "now", "Ljava/time/Instant;", "sendTime", "recvTime", "seq", "", "size", "Lorg/jitsi/nlj/util/DataSize;", "ecn", "", "previouslyReportedLost", "", "doProcessPacketArrival", "processPacketLoss", "doProcessPacketLoss", "feedbackComplete", "doFeedbackComplete", "onRttUpdate", "newRtt", "Ljava/time/Duration;", "doRttUpdate", "getCurrentBw", "getCurrentBw-WElJv5I", "(Ljava/time/Instant;)J", "getStats", "Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator$StatisticsSnapshot;", "reset", "listeners", "Ljava/util/LinkedList;", "Lorg/jitsi/nlj/rtp/TransportCcEngine$BandwidthListener;", "curBandwidth", "J", "lastBweLogTime", "minBweLogInterval", "Ljava/time/Duration;", "reportBandwidthEstimate", "newValue", "reportBandwidthEstimate-ERFH51c", "(Ljava/time/Instant;J)V", "addListener", "listener", "removeListener", "StatisticsSnapshot", "jitsi-media-transform"})
public abstract class BandwidthEstimator {
    @NotNull
    private final DiagnosticContext diagnosticContext;
    private final TimeSeriesLogger timeSeriesLogger;
    @NotNull
    private final LinkedList<TransportCcEngine.BandwidthListener> listeners;
    private long curBandwidth;
    @NotNull
    private Instant lastBweLogTime;
    private final Duration minBweLogInterval;

    public BandwidthEstimator(@NotNull DiagnosticContext diagnosticContext) {
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        this.diagnosticContext = diagnosticContext;
        this.timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(this.getClass());
        this.listeners = new LinkedList();
        this.curBandwidth = BandwidthKt.getBps(-1);
        this.lastBweLogTime = InstantKt.NEVER;
        this.minBweLogInterval = Duration.ofMillis(500L);
    }

    @NotNull
    protected final DiagnosticContext getDiagnosticContext() {
        return this.diagnosticContext;
    }

    protected final TimeSeriesLogger getTimeSeriesLogger() {
        return this.timeSeriesLogger;
    }

    @NotNull
    public abstract String getAlgorithmName();

    public abstract long getInitBw-rlWvAKk();

    public abstract void setInitBw-_2icLw0(long var1);

    public abstract long getMinBw-rlWvAKk();

    public abstract void setMinBw-_2icLw0(long var1);

    public abstract long getMaxBw-rlWvAKk();

    public abstract void setMaxBw-_2icLw0(long var1);

    public final void processPacketArrival(@NotNull Instant now, @Nullable Instant sendTime, @Nullable Instant recvTime, int seq, @NotNull DataSize size, byte ecn, boolean previouslyReportedLost) {
        Intrinsics.checkNotNullParameter(now, "now");
        Intrinsics.checkNotNullParameter(size, "size");
        if (this.timeSeriesLogger.isTraceEnabled()) {
            DiagnosticContext.TimeSeriesPoint point = this.diagnosticContext.makeTimeSeriesPoint("bwe_packet_arrival", now);
            if (sendTime != null) {
                point.addField("sendTime", InstantKt.formatMilli(sendTime));
            }
            if (recvTime != null) {
                point.addField("recvTime", InstantKt.formatMilli(recvTime));
            }
            point.addField("seq", seq);
            point.addField("size", size.getBytes());
            if (ecn != 0) {
                point.addField("ecn", ecn);
            }
            point.addField("previouslyReportedLost", previouslyReportedLost);
            this.timeSeriesLogger.trace(point);
        }
        this.doProcessPacketArrival(now, sendTime, recvTime, seq, size, ecn, previouslyReportedLost);
    }

    public static /* synthetic */ void processPacketArrival$default(BandwidthEstimator bandwidthEstimator, Instant instant, Instant instant2, Instant instant3, int n, DataSize dataSize, byte by, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processPacketArrival");
        }
        if ((n2 & 0x20) != 0) {
            by = 0;
        }
        if ((n2 & 0x40) != 0) {
            bl = false;
        }
        bandwidthEstimator.processPacketArrival(instant, instant2, instant3, n, dataSize, by, bl);
    }

    protected abstract void doProcessPacketArrival(@NotNull Instant var1, @Nullable Instant var2, @Nullable Instant var3, int var4, @NotNull DataSize var5, byte var6, boolean var7);

    public static /* synthetic */ void doProcessPacketArrival$default(BandwidthEstimator bandwidthEstimator, Instant instant, Instant instant2, Instant instant3, int n, DataSize dataSize, byte by, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doProcessPacketArrival");
        }
        if ((n2 & 0x20) != 0) {
            by = 0;
        }
        if ((n2 & 0x40) != 0) {
            bl = false;
        }
        bandwidthEstimator.doProcessPacketArrival(instant, instant2, instant3, n, dataSize, by, bl);
    }

    public final void processPacketLoss(@NotNull Instant now, @Nullable Instant sendTime, int seq) {
        Intrinsics.checkNotNullParameter(now, "now");
        if (this.timeSeriesLogger.isTraceEnabled()) {
            DiagnosticContext.TimeSeriesPoint point = this.diagnosticContext.makeTimeSeriesPoint("bwe_packet_loss", now);
            if (sendTime != null) {
                point.addField("sendTime", InstantKt.formatMilli(sendTime));
            }
            point.addField("seq", seq);
            this.timeSeriesLogger.trace(point);
        }
        this.doProcessPacketLoss(now, sendTime, seq);
    }

    protected abstract void doProcessPacketLoss(@NotNull Instant var1, @Nullable Instant var2, int var3);

    public final void feedbackComplete(@NotNull Instant now) {
        Intrinsics.checkNotNullParameter(now, "now");
        if (this.timeSeriesLogger.isTraceEnabled()) {
            DiagnosticContext.TimeSeriesPoint point = this.diagnosticContext.makeTimeSeriesPoint("bwe_feedback_complete", now);
            this.timeSeriesLogger.trace(point);
        }
        this.doFeedbackComplete(now);
    }

    protected abstract void doFeedbackComplete(@NotNull Instant var1);

    public final void onRttUpdate(@NotNull Instant now, @NotNull Duration newRtt) {
        Intrinsics.checkNotNullParameter(now, "now");
        Intrinsics.checkNotNullParameter(newRtt, "newRtt");
        if (this.timeSeriesLogger.isTraceEnabled()) {
            DiagnosticContext.TimeSeriesPoint point = this.diagnosticContext.makeTimeSeriesPoint("bwe_rtt", now);
            point.addField("rtt", DurationKt.formatMilli(newRtt));
            this.timeSeriesLogger.trace(point);
        }
        this.doRttUpdate(now, newRtt);
    }

    protected abstract void doRttUpdate(@NotNull Instant var1, @NotNull Duration var2);

    public abstract long getCurrentBw-WElJv5I(@NotNull Instant var1);

    @NotNull
    public abstract StatisticsSnapshot getStats(@NotNull Instant var1);

    public static /* synthetic */ StatisticsSnapshot getStats$default(BandwidthEstimator bandwidthEstimator, Instant instant, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getStats");
        }
        if ((n & 1) != 0) {
            instant = Clock.systemUTC().instant();
        }
        return bandwidthEstimator.getStats(instant);
    }

    public abstract void reset();

    protected final synchronized void reportBandwidthEstimate-ERFH51c(@NotNull Instant now, long newValue) {
        Intrinsics.checkNotNullParameter(now, "now");
        if (this.timeSeriesLogger.isTraceEnabled() && (!Bandwidth.equals-impl0(newValue, this.curBandwidth) || Intrinsics.areEqual(this.lastBweLogTime, InstantKt.NEVER) || Duration.between(this.lastBweLogTime, now).compareTo(this.minBweLogInterval) >= 0)) {
            DiagnosticContext.TimeSeriesPoint point = this.diagnosticContext.makeTimeSeriesPoint("bwe_estimate", now);
            point.addField("bw", newValue);
            this.timeSeriesLogger.trace(point);
            this.lastBweLogTime = now;
        }
        if (Bandwidth.equals-impl0(newValue, this.curBandwidth)) {
            return;
        }
        Iterator iterator2 = this.listeners.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            TransportCcEngine.BandwidthListener listener = (TransportCcEngine.BandwidthListener)e;
            listener.bandwidthEstimationChanged-_2icLw0(newValue);
        }
        this.curBandwidth = newValue;
    }

    public final synchronized void addListener(@NotNull TransportCcEngine.BandwidthListener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.listeners.add(listener);
    }

    public final synchronized void removeListener(@NotNull TransportCcEngine.BandwidthListener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.listeners.remove(listener);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u000f\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0017\u001a\u00020\u0003J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0017\u001a\u00020\u0003J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001b\u001a\u00020\u0019H\u0002J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0019J\u0016\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003J\u0016\u0010 \u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020!J\u001d\u0010\"\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0005\u00a2\u0006\u0004\b#\u0010$J\u0006\u0010%\u001a\u00020&R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00038F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010*\u0004\b\u000b\u0010\fR+\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00058F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015*\u0004\b\u0011\u0010\f\u00a8\u0006'"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator$StatisticsSnapshot;", "", "algorithmName", "", "currentEstimate", "Lorg/jitsi/nlj/util/Bandwidth;", "<init>", "(Ljava/lang/String;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "stats", "", "<set-?>", "getAlgorithmName$delegate", "(Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator$StatisticsSnapshot;)Ljava/lang/Object;", "getAlgorithmName", "()Ljava/lang/String;", "setAlgorithmName", "(Ljava/lang/String;)V", "getCurrentEstimate-rlWvAKk$delegate", "getCurrentEstimate-rlWvAKk", "()J", "setCurrentEstimate-_2icLw0", "(J)V", "getValue", "name", "getNumber", "", "promote", "n", "addNumber", "", "value", "addString", "addBoolean", "", "addBandwidth", "addBandwidth-ERFH51c", "(Ljava/lang/String;J)V", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "jitsi-media-transform"})
    @SourceDebugExtension(value={"SMAP\nBandwidthEstimator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BandwidthEstimator.kt\norg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator$StatisticsSnapshot\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,349:1\n1#2:350\n216#3,2:351\n*S KotlinDebug\n*F\n+ 1 BandwidthEstimator.kt\norg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator$StatisticsSnapshot\n*L\n340#1:351,2\n*E\n"})
    public static final class StatisticsSnapshot {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final Map<String, Object> stats;

        private StatisticsSnapshot(String algorithmName, long currentEstimate) {
            Intrinsics.checkNotNullParameter(algorithmName, "algorithmName");
            this.stats = new LinkedHashMap();
            this.addString("algorithmName", algorithmName);
            this.addBandwidth-ERFH51c("currentEstimate", currentEstimate);
        }

        @NotNull
        public final String getAlgorithmName() {
            Map<String, Object> map = this.stats;
            return (String)MapsKt.getOrImplicitDefaultNullable(map, $$delegatedProperties[0].getName());
        }

        public final void setAlgorithmName(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            Map<String, Object> map = this.stats;
            map.put($$delegatedProperties[0].getName(), string);
        }

        private static Object getAlgorithmName$delegate(StatisticsSnapshot statisticsSnapshot) {
            return statisticsSnapshot.stats;
        }

        public final long getCurrentEstimate-rlWvAKk() {
            Map<String, Object> map = this.stats;
            return ((Bandwidth)MapsKt.getOrImplicitDefaultNullable(map, $$delegatedProperties[1].getName())).unbox-impl();
        }

        public final void setCurrentEstimate-_2icLw0(long l) {
            Map<String, Object> map = this.stats;
            KProperty<Object> kProperty = $$delegatedProperties[1];
            Bandwidth bandwidth = Bandwidth.box-impl(l);
            map.put(kProperty.getName(), bandwidth);
        }

        private static Object getCurrentEstimate-rlWvAKk$delegate(StatisticsSnapshot statisticsSnapshot) {
            return statisticsSnapshot.stats;
        }

        @Nullable
        public final Object getValue(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return this.stats.get(name);
        }

        @Nullable
        public final Number getNumber(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            Object object = this.stats.get(name);
            return object instanceof Number ? (Number)((Number)object) : (Number)null;
        }

        private final Number promote(Number n) {
            Number number = n;
            return number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long ? (Number)n.longValue() : (Number)(number instanceof Float || number instanceof Double ? (Number)n.doubleValue() : null);
        }

        public final void addNumber(@NotNull String name, @NotNull Number value2) {
            block0: {
                Intrinsics.checkNotNullParameter(name, "name");
                Intrinsics.checkNotNullParameter(value2, "value");
                Number number = this.promote(value2);
                if (number == null) break block0;
                Number it = number;
                boolean bl = false;
                this.stats.put(name, it);
            }
        }

        public final void addString(@NotNull String name, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(value2, "value");
            this.stats.put(name, value2);
        }

        public final void addBoolean(@NotNull String name, boolean value2) {
            Intrinsics.checkNotNullParameter(name, "name");
            Boolean bl = value2;
            this.stats.put(name, bl);
        }

        public final void addBandwidth-ERFH51c(@NotNull String name, long value2) {
            Intrinsics.checkNotNullParameter(name, "name");
            Bandwidth bandwidth = Bandwidth.box-impl(value2);
            this.stats.put(name, bandwidth);
        }

        @NotNull
        public final OrderedJsonObject toJson() {
            OrderedJsonObject orderedJsonObject;
            OrderedJsonObject $this$toJson_u24lambda_u242 = orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            Map<String, Object> $this$forEach$iv = this.stats;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, Object> element$iv;
                Map.Entry<String, Object> entry = element$iv = iterator2.next();
                boolean bl2 = false;
                String name = entry.getKey();
                Object value2 = entry.getValue();
                Object object = value2 instanceof Bandwidth ? $this$toJson_u24lambda_u242.put(name, (Object)((Bandwidth)value2).unbox-impl()) : $this$toJson_u24lambda_u242.put(name, value2);
            }
            return orderedJsonObject;
        }

        public /* synthetic */ StatisticsSnapshot(String algorithmName, long currentEstimate, DefaultConstructorMarker $constructor_marker) {
            this(algorithmName, currentEstimate);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(StatisticsSnapshot.class, "algorithmName", "getAlgorithmName()Ljava/lang/String;", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(StatisticsSnapshot.class, "currentEstimate", "getCurrentEstimate-rlWvAKk()J", 0))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

