/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.outgoing;

import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.rtp.RtpExtensionType;
import org.jitsi.nlj.rtp.TransportCcEngine;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.ModifierNode;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.rtp.header_extensions.TccHeaderExtension;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0019H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u001c\u0010\r\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00030\u00030\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jitsi/nlj/transform/node/outgoing/TccSeqNumTagger;", "Lorg/jitsi/nlj/transform/node/ModifierNode;", "transportCcEngine", "Lorg/jitsi/nlj/rtp/TransportCcEngine;", "streamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "<init>", "(Lorg/jitsi/nlj/rtp/TransportCcEngine;Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;)V", "currTccSeqNum", "", "tccExtensionId", "", "Ljava/lang/Integer;", "weakTcc", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "modify", "Lorg/jitsi/nlj/PacketInfo;", "packetInfo", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "stop", "", "trace", "f", "Lkotlin/Function0;", "jitsi-media-transform"})
public final class TccSeqNumTagger
extends ModifierNode {
    private long currTccSeqNum;
    @Nullable
    private Integer tccExtensionId;
    @NotNull
    private final WeakReference<TransportCcEngine> weakTcc;

    public TccSeqNumTagger(@NotNull TransportCcEngine transportCcEngine, @NotNull ReadOnlyStreamInformationStore streamInformationStore) {
        Intrinsics.checkNotNullParameter(transportCcEngine, "transportCcEngine");
        Intrinsics.checkNotNullParameter(streamInformationStore, "streamInformationStore");
        super("TCC sequence number tagger");
        this.currTccSeqNum = 1L;
        streamInformationStore.onRtpExtensionMapping(RtpExtensionType.TRANSPORT_CC, arg_0 -> TccSeqNumTagger._init_$lambda$0(this, arg_0));
        this.weakTcc = new WeakReference<TransportCcEngine>(transportCcEngine);
    }

    @Override
    @NotNull
    protected PacketInfo modify(@NotNull PacketInfo packetInfo) {
        block3: {
            Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
            Integer n = this.tccExtensionId;
            if (n == null) break block3;
            int tccExtId = ((Number)n).intValue();
            boolean bl = false;
            RtpPacket rtpPacket = (RtpPacket)packetInfo.packetAs();
            if (rtpPacket instanceof VideoRtpPacket) {
                RtpPacket.HeaderExtension headerExtension = rtpPacket.getHeaderExtension(tccExtId);
                if (headerExtension == null) {
                    headerExtension = rtpPacket.addHeaderExtension(tccExtId, 2);
                }
                RtpPacket.HeaderExtension ext = headerExtension;
                long curSeq = this.currTccSeqNum;
                TccHeaderExtension.Companion.setSequenceNumber(ext, (int)curSeq);
                TransportCcEngine transportCcEngine = (TransportCcEngine)this.weakTcc.get();
                if (transportCcEngine != null) {
                    transportCcEngine.mediaPacketTagged(packetInfo, curSeq);
                }
                packetInfo.onSent(arg_0 -> TccSeqNumTagger.modify$lambda$2$lambda$1(this, curSeq, arg_0));
                long l = this.currTccSeqNum;
                this.currTccSeqNum = l + 1L;
            }
        }
        return packetInfo;
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u243 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        $this$getNodeStats_u24lambda_u243.addString("tcc_ext_id", String.valueOf(this.tccExtensionId));
        return nodeStatsBlock;
    }

    @Override
    public void stop() {
        block0: {
            super.stop();
            TransportCcEngine transportCcEngine = (TransportCcEngine)this.weakTcc.get();
            if (transportCcEngine == null) break block0;
            transportCcEngine.stop();
        }
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }

    private static final Unit _init_$lambda$0(TccSeqNumTagger this$0, Integer it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.tccExtensionId = it;
        return Unit.INSTANCE;
    }

    private static final Unit modify$lambda$2$lambda$1(TccSeqNumTagger this$0, long $curSeq, PacketInfo pkt) {
        block0: {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter(pkt, "pkt");
            TransportCcEngine transportCcEngine = (TransportCcEngine)this$0.weakTcc.get();
            if (transportCcEngine == null) break block0;
            transportCcEngine.mediaPacketSent(pkt, $curSeq);
        }
        return Unit.INSTANCE;
    }
}

