/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.stats;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.config.JitsiConfig;
import org.jitsi.metaconfig.ConfigDelegate;
import org.jitsi.metaconfig.SupplierBuilder;
import org.jitsi.metaconfig.supplier.FallbackSupplier;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.stats.BridgeJitterStats;
import org.jitsi.nlj.stats.PacketDelayStats;
import org.jitsi.rtp.extensions.PacketExtensionsKt;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.utils.stats.BucketStats;
import org.jitsi.videobridge.stats.PrometheusPacketDelayStats;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0007J\b\u0010+\u001a\u00020\"H\u0002R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\t\u001a\u0004\b\u000b\u0010\u0007R\u001b\u0010\r\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\t\u001a\u0004\b\u000e\u0010\u0007R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\"8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b#\u0010\u0003\u001a\u0004\b$\u0010%R\u001c\u0010&\u001a\u0004\u0018\u00010'8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b(\u0010\u0003\u001a\u0004\b)\u0010*\u00a8\u0006,"}, d2={"Lorg/jitsi/videobridge/stats/PacketTransitStats;", "", "<init>", "()V", "jsonEnabled", "", "getJsonEnabled", "()Z", "jsonEnabled$delegate", "Lorg/jitsi/metaconfig/ConfigDelegate;", "prometheusEnabled", "getPrometheusEnabled", "prometheusEnabled$delegate", "jitterEnabled", "getJitterEnabled", "jitterEnabled$delegate", "enabled", "logger", "Lorg/jitsi/utils/logging2/Logger;", "clock", "Ljava/time/Clock;", "rtpPacketDelayStats", "Lorg/jitsi/nlj/stats/PacketDelayStats;", "rtcpPacketDelayStats", "prometheusRtpDelayStats", "Lorg/jitsi/videobridge/stats/PrometheusPacketDelayStats;", "prometheusRtcpDelayStats", "bridgeJitterStats", "Lorg/jitsi/nlj/stats/BridgeJitterStats;", "packetSent", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "statsJson", "Lorg/jitsi/utils/OrderedJsonObject;", "getStatsJson$annotations", "getStatsJson", "()Lorg/jitsi/utils/OrderedJsonObject;", "bridgeJitter", "", "getBridgeJitter$annotations", "getBridgeJitter", "()Ljava/lang/Double;", "getPacketDelayStats", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nPacketTransitStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PacketTransitStats.kt\norg/jitsi/videobridge/stats/PacketTransitStats\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Delegates.kt\norg/jitsi/metaconfig/DelegatesKt\n*L\n1#1,149:1\n1#2:150\n68#3,6:151\n68#3,6:157\n68#3,6:163\n*S KotlinDebug\n*F\n+ 1 PacketTransitStats.kt\norg/jitsi/videobridge/stats/PacketTransitStats\n*L\n40#1:151,6\n43#1:157,6\n46#1:163,6\n*E\n"})
public final class PacketTransitStats {
    @NotNull
    public static final PacketTransitStats INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final ConfigDelegate jsonEnabled$delegate;
    @NotNull
    private static final ConfigDelegate prometheusEnabled$delegate;
    @NotNull
    private static final ConfigDelegate jitterEnabled$delegate;
    private static final boolean enabled;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Clock clock;
    @Nullable
    private static final PacketDelayStats rtpPacketDelayStats;
    @Nullable
    private static final PacketDelayStats rtcpPacketDelayStats;
    @Nullable
    private static final PrometheusPacketDelayStats prometheusRtpDelayStats;
    @Nullable
    private static final PrometheusPacketDelayStats prometheusRtcpDelayStats;
    @Nullable
    private static final BridgeJitterStats bridgeJitterStats;

    private PacketTransitStats() {
    }

    private final boolean getJsonEnabled() {
        return (Boolean)jsonEnabled$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final boolean getPrometheusEnabled() {
        return (Boolean)prometheusEnabled$delegate.getValue(this, $$delegatedProperties[1]);
    }

    private final boolean getJitterEnabled() {
        return (Boolean)jitterEnabled$delegate.getValue(this, $$delegatedProperties[2]);
    }

    @JvmStatic
    public static final void packetSent(@NotNull PacketInfo packetInfo) {
        block10: {
            block11: {
                Long delayMs;
                block8: {
                    block9: {
                        Long l;
                        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
                        if (!enabled) {
                            return;
                        }
                        Instant instant = packetInfo.getReceivedTime();
                        if (instant != null) {
                            Instant it = instant;
                            boolean bl = false;
                            l = Duration.between(it, clock.instant()).toMillis();
                        } else {
                            l = delayMs = null;
                        }
                        if (!PacketExtensionsKt.looksLikeRtp(packetInfo.getPacket())) break block8;
                        if (delayMs == null) break block9;
                        PacketDelayStats packetDelayStats = rtpPacketDelayStats;
                        if (packetDelayStats != null) {
                            packetDelayStats.addDelay(delayMs);
                        }
                        PrometheusPacketDelayStats prometheusPacketDelayStats = prometheusRtpDelayStats;
                        if (prometheusPacketDelayStats != null) {
                            prometheusPacketDelayStats.addDelay(delayMs);
                        }
                        BridgeJitterStats bridgeJitterStats = PacketTransitStats.bridgeJitterStats;
                        if (bridgeJitterStats == null) break block10;
                        bridgeJitterStats.packetSent(packetInfo);
                        break block10;
                    }
                    PacketDelayStats packetDelayStats = rtpPacketDelayStats;
                    if (packetDelayStats != null) {
                        packetDelayStats.addUnknown();
                    }
                    PrometheusPacketDelayStats prometheusPacketDelayStats = prometheusRtpDelayStats;
                    if (prometheusPacketDelayStats == null) break block10;
                    prometheusPacketDelayStats.addUnknown();
                    break block10;
                }
                if (!PacketExtensionsKt.looksLikeRtcp(packetInfo.getPacket())) break block10;
                if (delayMs == null) break block11;
                PacketDelayStats packetDelayStats = rtcpPacketDelayStats;
                if (packetDelayStats != null) {
                    packetDelayStats.addDelay(delayMs);
                }
                PrometheusPacketDelayStats prometheusPacketDelayStats = prometheusRtcpDelayStats;
                if (prometheusPacketDelayStats == null) break block10;
                prometheusPacketDelayStats.addDelay(delayMs);
                break block10;
            }
            PacketDelayStats packetDelayStats = rtcpPacketDelayStats;
            if (packetDelayStats != null) {
                packetDelayStats.addUnknown();
            }
            PrometheusPacketDelayStats prometheusPacketDelayStats = prometheusRtcpDelayStats;
            if (prometheusPacketDelayStats == null) break block10;
            prometheusPacketDelayStats.addUnknown();
        }
    }

    @NotNull
    public static final OrderedJsonObject getStatsJson() {
        OrderedJsonObject stats;
        block0: {
            stats = new OrderedJsonObject();
            ((Map)stats).put("e2e_packet_delay", INSTANCE.getPacketDelayStats());
            BridgeJitterStats bridgeJitterStats = PacketTransitStats.bridgeJitterStats;
            if (bridgeJitterStats == null) break block0;
            BridgeJitterStats it = bridgeJitterStats;
            boolean bl = false;
            ((Map)stats).put("overall_bridge_jitter", it.getJitter());
        }
        return stats;
    }

    @JvmStatic
    public static /* synthetic */ void getStatsJson$annotations() {
    }

    @Nullable
    public static final Double getBridgeJitter() {
        BridgeJitterStats bridgeJitterStats = PacketTransitStats.bridgeJitterStats;
        return bridgeJitterStats != null ? Double.valueOf(bridgeJitterStats.getJitter()) : null;
    }

    @JvmStatic
    public static /* synthetic */ void getBridgeJitter$annotations() {
    }

    private final OrderedJsonObject getPacketDelayStats() {
        OrderedJsonObject orderedJsonObject;
        block1: {
            PacketDelayStats it;
            OrderedJsonObject $this$getPacketDelayStats_u24lambda_u247 = orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            PacketDelayStats packetDelayStats = rtpPacketDelayStats;
            if (packetDelayStats != null) {
                it = packetDelayStats;
                boolean bl2 = false;
                $this$getPacketDelayStats_u24lambda_u247.put("rtp", it.toJson(BucketStats.Format.CumulativeRight));
            }
            PacketDelayStats packetDelayStats2 = rtcpPacketDelayStats;
            if (packetDelayStats2 == null) break block1;
            it = packetDelayStats2;
            boolean bl3 = false;
            $this$getPacketDelayStats_u24lambda_u247.put("rtcp", it.toJson(BucketStats.Format.CumulativeRight));
        }
        return orderedJsonObject;
    }

    static {
        SupplierBuilder supplierBuilder;
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(PacketTransitStats.class, "jsonEnabled", "getJsonEnabled()Z", 0)), Reflection.property1(new PropertyReference1Impl(PacketTransitStats.class, "prometheusEnabled", "getPrometheusEnabled()Z", 0)), Reflection.property1(new PropertyReference1Impl(PacketTransitStats.class, "jitterEnabled", "getJitterEnabled()Z", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new PacketTransitStats();
        boolean $i$f$config = false;
        SupplierBuilder $this$jsonEnabled_delegate_u24lambda_u240 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Boolean.TYPE));
        boolean bl = false;
        $this$jsonEnabled_delegate_u24lambda_u240.from("videobridge.stats.transit-time.enable-json", JitsiConfig.Companion.getNewConfig());
        SupplierBuilder supplierBuilder$iv = supplierBuilder;
        jsonEnabled$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate(CollectionsKt.first(supplierBuilder$iv.getSuppliers())) : new ConfigDelegate(new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
        $i$f$config = false;
        SupplierBuilder $this$prometheusEnabled_delegate_u24lambda_u241 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Boolean.TYPE));
        boolean bl2 = false;
        $this$prometheusEnabled_delegate_u24lambda_u241.from("videobridge.stats.transit-time.enable-prometheus", JitsiConfig.Companion.getNewConfig());
        supplierBuilder$iv = supplierBuilder;
        prometheusEnabled$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate(CollectionsKt.first(supplierBuilder$iv.getSuppliers())) : new ConfigDelegate(new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
        $i$f$config = false;
        SupplierBuilder $this$jitterEnabled_delegate_u24lambda_u242 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Boolean.TYPE));
        boolean bl3 = false;
        $this$jitterEnabled_delegate_u24lambda_u242.from("videobridge.stats.transit-time.enable-jitter", JitsiConfig.Companion.getNewConfig());
        supplierBuilder$iv = supplierBuilder;
        jitterEnabled$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate(CollectionsKt.first(supplierBuilder$iv.getSuppliers())) : new ConfigDelegate(new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
        enabled = INSTANCE.getJsonEnabled() || INSTANCE.getPrometheusEnabled() || INSTANCE.getJitterEnabled();
        logger = LoggerExtensionsKt.createLogger$default(INSTANCE, null, null, 3, null);
        Clock clock = Clock.systemUTC();
        Intrinsics.checkNotNullExpressionValue(clock, "systemUTC(...)");
        PacketTransitStats.clock = clock;
        logger.info("Initializing, jsonEnabled=" + INSTANCE.getJsonEnabled() + ", prometheusEnabled=" + INSTANCE.getPrometheusEnabled() + ", jitterEnabled=" + INSTANCE.getJitterEnabled());
        rtpPacketDelayStats = INSTANCE.getJsonEnabled() ? new PacketDelayStats(null, 1, null) : null;
        rtcpPacketDelayStats = INSTANCE.getJsonEnabled() ? new PacketDelayStats(null, 1, null) : null;
        prometheusRtpDelayStats = INSTANCE.getPrometheusEnabled() ? new PrometheusPacketDelayStats("rtp_transit_time") : null;
        prometheusRtcpDelayStats = INSTANCE.getPrometheusEnabled() ? new PrometheusPacketDelayStats("rtcp_transit_time") : null;
        bridgeJitterStats = INSTANCE.getJitterEnabled() ? new BridgeJitterStats(null, 1, null) : null;
    }
}

