/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.TimeWindow;

public final class TimeWindows
extends Windows<TimeWindow> {
    public final long sizeMs;
    public final long advanceMs;

    private TimeWindows(long sizeMs, long advanceMs) {
        this.sizeMs = sizeMs;
        this.advanceMs = advanceMs;
    }

    public static TimeWindows of(long sizeMs) throws IllegalArgumentException {
        if (sizeMs <= 0L) {
            throw new IllegalArgumentException("Window size (sizeMs) must be larger than zero.");
        }
        return new TimeWindows(sizeMs, sizeMs);
    }

    public TimeWindows advanceBy(long advanceMs) {
        if (advanceMs <= 0L || advanceMs > this.sizeMs) {
            throw new IllegalArgumentException(String.format("AdvanceMs must lie within interval (0, %d].", this.sizeMs));
        }
        return new TimeWindows(this.sizeMs, advanceMs);
    }

    @Override
    public Map<Long, TimeWindow> windowsFor(long timestamp) {
        HashMap<Long, TimeWindow> windows = new HashMap<Long, TimeWindow>();
        for (long windowStart = Math.max(0L, timestamp - this.sizeMs + this.advanceMs) / this.advanceMs * this.advanceMs; windowStart <= timestamp; windowStart += this.advanceMs) {
            TimeWindow window = new TimeWindow(windowStart, windowStart + this.sizeMs);
            windows.put(windowStart, window);
        }
        return windows;
    }

    @Override
    public long size() {
        return this.sizeMs;
    }

    public TimeWindows until(long durationMs) throws IllegalArgumentException {
        if (durationMs < this.sizeMs) {
            throw new IllegalArgumentException("Window retention time (durationMs) cannot be smaller than the window size.");
        }
        super.until(durationMs);
        return this;
    }

    @Override
    public long maintainMs() {
        return Math.max(super.maintainMs(), this.sizeMs);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeWindows)) {
            return false;
        }
        TimeWindows other = (TimeWindows)o;
        return this.sizeMs == other.sizeMs && this.advanceMs == other.advanceMs;
    }

    public int hashCode() {
        int result = (int)(this.sizeMs ^ this.sizeMs >>> 32);
        result = 31 * result + (int)(this.advanceMs ^ this.advanceMs >>> 32);
        return result;
    }
}

