/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.processor.PartitionGrouper;
import org.apache.kafka.streams.processor.TaskId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPartitionGrouper
implements PartitionGrouper {
    private static final Logger log = LoggerFactory.getLogger(DefaultPartitionGrouper.class);

    @Override
    public Map<TaskId, Set<TopicPartition>> partitionGroups(Map<Integer, Set<String>> topicGroups, Cluster metadata) {
        HashMap groups = new HashMap();
        for (Map.Entry<Integer, Set<String>> entry : topicGroups.entrySet()) {
            Integer topicGroupId = entry.getKey();
            Set<String> topicGroup = entry.getValue();
            int maxNumPartitions = this.maxNumPartitions(metadata, topicGroup);
            for (int partitionId = 0; partitionId < maxNumPartitions; ++partitionId) {
                HashSet<TopicPartition> group = new HashSet<TopicPartition>(topicGroup.size());
                for (String topic : topicGroup) {
                    List partitions = metadata.partitionsForTopic(topic);
                    if (partitionId >= partitions.size()) continue;
                    group.add(new TopicPartition(topic, partitionId));
                }
                groups.put(new TaskId(topicGroupId, partitionId), Collections.unmodifiableSet(group));
            }
        }
        return Collections.unmodifiableMap(groups);
    }

    protected int maxNumPartitions(Cluster metadata, Set<String> topics) {
        int maxNumPartitions = 0;
        for (String topic : topics) {
            List partitions = metadata.partitionsForTopic(topic);
            if (partitions.isEmpty()) {
                log.info("Skipping assigning topic {} to tasks since its metadata is not available yet", (Object)topic);
                return -2;
            }
            int numPartitions = partitions.size();
            if (numPartitions <= maxNumPartitions) continue;
            maxNumPartitions = numPartitions;
        }
        return maxNumPartitions;
    }
}

