require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ARM32_PMAP_H_)) {
    eval 'sub _ARM32_PMAP_H_ () {1;}' unless defined(&_ARM32_PMAP_H_);
    if(defined(&_KERNEL)) {
	require 'arm/cpuconf.ph';
	require 'arm/arm32/pte.ph';
	unless(defined(&_LOCORE)) {
	    if(defined(&_KERNEL_OPT)) {
		require './arm/arm32/opt_arm32_pmap.ph';
		require './arm/arm32/opt_multiprocessor.ph';
	    }
	    require 'arm/cpufunc.ph';
	    require 'arm/locore.ph';
	    require 'uvm/uvm_object.ph';
	    require 'uvm/pmap/pmap_devmap.ph';
	    require 'uvm/pmap/pmap_pvt.ph';
	}
	if(defined(&ARM_MMU_EXTENDED)) {
	    eval 'sub PMAP_HWPAGEWALKER () {1;}' unless defined(&PMAP_HWPAGEWALKER);
	    eval 'sub PMAP_TLB_MAX () {1;}' unless defined(&PMAP_TLB_MAX);
	    if((defined(&PMAP_TLB_MAX) ? &PMAP_TLB_MAX : undef) > 1) {
		eval 'sub PMAP_TLB_NEED_SHOOTDOWN () {1;}' unless defined(&PMAP_TLB_NEED_SHOOTDOWN);
	    }
	    eval 'sub PMAP_TLB_FLUSH_ASID_ON_RESET () { &arm_has_tlbiasid_p;}' unless defined(&PMAP_TLB_FLUSH_ASID_ON_RESET);
	    eval 'sub PMAP_TLB_NUM_PIDS () {256;}' unless defined(&PMAP_TLB_NUM_PIDS);
	    eval 'sub pmap_md_tlb_asid_max () {
	        eval q(( &PMAP_TLB_NUM_PIDS - 1));
	    }' unless defined(&pmap_md_tlb_asid_max);
	    require 'uvm/pmap/tlb.ph';
	    require 'uvm/pmap/pmap_tlb.ph';
	    if(((defined(&KERNEL_BASE) ? &KERNEL_BASE : undef) & 0x80000000) == 0) {
		die("ARMv6\ or\ later\ systems\ must\ have\ a\ KERNEL_BASE\ \>\=\ 0x80000000");
	    }
	}
	eval 'sub L2_BUCKET_XLOG2 () {( &L1_S_SHIFT);}' unless defined(&L2_BUCKET_XLOG2);
	eval 'sub L2_BUCKET_XSIZE () {(1<<  &L2_BUCKET_XLOG2);}' unless defined(&L2_BUCKET_XSIZE);
	eval 'sub L2_BUCKET_LOG2 () {4;}' unless defined(&L2_BUCKET_LOG2);
	eval 'sub L2_BUCKET_SIZE () {(1<<  &L2_BUCKET_LOG2);}' unless defined(&L2_BUCKET_SIZE);
	eval 'sub L2_LOG2 () {(32- ( &L2_BUCKET_XLOG2 +  &L2_BUCKET_LOG2));}' unless defined(&L2_LOG2);
	eval 'sub L2_SIZE () {(1<<  &L2_LOG2);}' unless defined(&L2_SIZE);
	if(((defined(&ARM_MMU_V6) ? &ARM_MMU_V6 : undef) + (defined(&ARM_MMU_V7) ? &ARM_MMU_V7 : undef)) > 0) {
	    eval 'sub PMAP_CACHE_VIPT () {1;}' unless defined(&PMAP_CACHE_VIPT);
	} else {
	    eval 'sub PMAP_CACHE_VIVT () {1;}' unless defined(&PMAP_CACHE_VIVT);
	}
	unless(defined(&_LOCORE)) {
	    unless(defined(&ARM_MMU_EXTENDED)) {
		eval 'sub cs_cache_id () { ($cs_s->{cs_cache_u}->{csu_cache_b[0]});}' unless defined(&cs_cache_id);
		eval 'sub cs_cache_d () { ($cs_s->{cs_cache_u}->{csu_cache_b[1]});}' unless defined(&cs_cache_d);
		eval 'sub cs_cache () { ($cs_s->{cs_cache_u}->{csu_cache});}' unless defined(&cs_cache);
		eval 'sub cs_tlb_id () { ($cs_s->{cs_tlb_u}->{csu_tlb_b[0]});}' unless defined(&cs_tlb_id);
		eval 'sub cs_tlb_d () { ($cs_s->{cs_tlb_u}->{csu_tlb_b[1]});}' unless defined(&cs_tlb_d);
		eval 'sub cs_tlb () { ($cs_s->{cs_tlb_u}->{csu_tlb});}' unless defined(&cs_tlb);
		eval 'sub PMAP_CACHE_STATE_ALL () {0xffffffff;}' unless defined(&PMAP_CACHE_STATE_ALL);
	    }
	    eval 'sub DEVMAP_ALIGN {
	        my($a) = @_;
    		eval q((($a) & ~ &L1_S_OFFSET));
	    }' unless defined(&DEVMAP_ALIGN);
	    eval 'sub DEVMAP_SIZE {
	        my($s) = @_;
    		eval q( &roundup2(($s),  &L1_S_SIZE));
	    }' unless defined(&DEVMAP_SIZE);
	    eval 'sub DEVMAP_FLAGS () { &PMAP_DEV;}' unless defined(&DEVMAP_FLAGS);
	    unless(defined(&ARM_HAS_VBAR)) {
	    }
	    if(defined(&ARM_MMU_EXTENDED)) {
		if(defined(&MULTIPROCESSOR)) {
		    if((defined(&PMAP_TLB_MAX) ? &PMAP_TLB_MAX : undef) > 1) {
		    }
		}
	    } else {
	    }
	    if(defined(&EFI_RUNTIME)) {
	    }
	    if(defined(&ARM_MMU_EXTENDED)) {
	    }
	    eval 'sub PTE_KERNEL () {0;}' unless defined(&PTE_KERNEL);
	    eval 'sub PTE_USER () {1;}' unless defined(&PTE_USER);
	    eval 'sub PTE_NOCACHE () {0;}' unless defined(&PTE_NOCACHE);
	    eval 'sub PTE_CACHE () {1;}' unless defined(&PTE_CACHE);
	    eval 'sub PTE_PAGETABLE () {2;}' unless defined(&PTE_PAGETABLE);
	    eval 'sub PTE_DEV () {3;}' unless defined(&PTE_DEV);
	    eval 'sub PVF_MOD () {0x1;}' unless defined(&PVF_MOD);
	    eval 'sub PVF_REF () {0x2;}' unless defined(&PVF_REF);
	    eval 'sub PVF_WIRED () {0x4;}' unless defined(&PVF_WIRED);
	    eval 'sub PVF_WRITE () {0x8;}' unless defined(&PVF_WRITE);
	    eval 'sub PVF_EXEC () {0x10;}' unless defined(&PVF_EXEC);
	    if(defined(&PMAP_CACHE_VIVT)) {
		eval 'sub PVF_UNC () {0x20;}' unless defined(&PVF_UNC);
		eval 'sub PVF_KNC () {0x40;}' unless defined(&PVF_KNC);
		eval 'sub PVF_NC () {( &PVF_UNC| &PVF_KNC);}' unless defined(&PVF_NC);
	    }
	    if(defined(&PMAP_CACHE_VIPT)) {
		eval 'sub PVF_NC () {0x20;}' unless defined(&PVF_NC);
		eval 'sub PVF_MULTCLR () {0x40;}' unless defined(&PVF_MULTCLR);
	    }
	    eval 'sub PVF_COLORED () {0x80;}' unless defined(&PVF_COLORED);
	    eval 'sub PVF_KENTRY () {0x100;}' unless defined(&PVF_KENTRY);
	    eval 'sub PVF_KMPAGE () {0x200;}' unless defined(&PVF_KMPAGE);
	    eval 'sub PVF_DIRTY () {0x400;}' unless defined(&PVF_DIRTY);
	    eval 'sub PVF_KMOD () {0x800;}' unless defined(&PVF_KMOD);
	    eval 'sub PVF_KWRITE () {( &PVF_KENTRY| &PVF_WRITE);}' unless defined(&PVF_KWRITE);
	    eval 'sub PVF_DMOD () {( &PVF_MOD| &PVF_KMOD| &PVF_KMPAGE);}' unless defined(&PVF_DMOD);
	    eval 'sub pmap_resident_count {
	        my($pmap) = @_;
    		eval q((($pmap)-> ($pm_stats->{resident_count})));
	    }' unless defined(&pmap_resident_count);
	    eval 'sub pmap_wired_count {
	        my($pmap) = @_;
    		eval q((($pmap)-> ($pm_stats->{wired_count})));
	    }' unless defined(&pmap_wired_count);
	    eval 'sub pmap_is_modified {
	        my($pg) = @_;
    		eval q(((($pg)-> ($mdpage->{pvh_attrs}) &  &PVF_MOD) != 0));
	    }' unless defined(&pmap_is_modified);
	    eval 'sub pmap_is_referenced {
	        my($pg) = @_;
    		eval q(((($pg)-> ($mdpage->{pvh_attrs}) &  &PVF_REF) != 0));
	    }' unless defined(&pmap_is_referenced);
	    eval 'sub pmap_is_page_colored_p {
	        my($md) = @_;
    		eval q(((($md)-> &pvh_attrs &  &PVF_COLORED) != 0));
	    }' unless defined(&pmap_is_page_colored_p);
	    eval 'sub pmap_copy {
	        my($dp, $sp, $da, $l, $sa) = @_;
    		eval q();
	    }' unless defined(&pmap_copy);
	    eval 'sub pmap_phys_address {
	        my($ppn) = @_;
    		eval q(( &arm_ptob(($ppn))));
	    }' unless defined(&pmap_phys_address);
	    eval 'sub ARM32_MMAP_WRITECOMBINE () {0x40000000;}' unless defined(&ARM32_MMAP_WRITECOMBINE);
	    eval 'sub ARM32_MMAP_CACHEABLE () {0x20000000;}' unless defined(&ARM32_MMAP_CACHEABLE);
	    eval 'sub ARM_MMAP_WRITECOMBINE () { &ARM32_MMAP_WRITECOMBINE;}' unless defined(&ARM_MMAP_WRITECOMBINE);
	    eval 'sub ARM_MMAP_CACHEABLE () { &ARM32_MMAP_CACHEABLE;}' unless defined(&ARM_MMAP_CACHEABLE);
	    eval 'sub pmap_mmap_flags {
	        my($ppn) = @_;
    		eval q( &arm32_mmap_flags($ppn));
	    }' unless defined(&pmap_mmap_flags);
	    eval 'sub PMAP_PTE () {0x10000000;}' unless defined(&PMAP_PTE);
	    eval 'sub PMAP_DEV () {0x20000000;}' unless defined(&PMAP_DEV);
	    eval 'sub PMAP_DEV_SO () {0x40000000;}' unless defined(&PMAP_DEV_SO);
	    eval 'sub PMAP_DEV_MASK () {( &PMAP_DEV |  &PMAP_DEV_SO);}' unless defined(&PMAP_DEV_MASK);
	    eval 'sub PMAP_NEED_PROCWR () {1;}' unless defined(&PMAP_NEED_PROCWR);
	    eval 'sub PMAP_GROWKERNEL () {1;}' unless defined(&PMAP_GROWKERNEL);
	    eval 'sub PMAP_ENABLE_PMAP_KMPAGE () {1;}' unless defined(&PMAP_ENABLE_PMAP_KMPAGE);
	    if(((defined(&ARM_MMU_V6) ? &ARM_MMU_V6 : undef) + (defined(&ARM_MMU_V7) ? &ARM_MMU_V7 : undef)) > 0) {
		eval 'sub PMAP_PREFER {
		    my($hint, $vap, $sz, $td) = @_;
    		    eval q( &pmap_prefer(($hint), ($vap), ($td)));
		}' unless defined(&PMAP_PREFER);
	    }
	    if(defined(&ARM_MMU_EXTENDED)) {
	    }
	    if(defined(&PMAP_STEAL_MEMORY)) {
	    }
	    eval 'sub PMAP_PAGEIDLEZERO {
	        my($pa) = @_;
    		eval q( &pmap_pageidlezero(($pa)));
	    }' unless defined(&PMAP_PAGEIDLEZERO);
	    if(defined(&__HAVE_MM_MD_DIRECT_MAPPED_PHYS)) {
	    }
	    if(defined(&ARM_MMU_EXTENDED)  && defined(&__HAVE_MM_MD_DIRECT_MAPPED_PHYS)) {
	    }
	    if(defined(&_KERNEL_OPT)) {
		if(((defined(&ARM_NMMUS) ? &ARM_NMMUS : undef) == 1)) {
		    if(((defined(&ARM_MMU_SA1) ? &ARM_MMU_SA1 : undef) + (defined(&ARM_MMU_V6) ? &ARM_MMU_V6 : undef) != 0)) {
			eval 'sub PMAP_INCLUDE_PTE_SYNC () {1;}' unless defined(&PMAP_INCLUDE_PTE_SYNC);
			eval 'sub PMAP_NEEDS_PTE_SYNC () {1;}' unless defined(&PMAP_NEEDS_PTE_SYNC);
		    }
 elsif(((defined(&ARM_MMU_MEMC) ? &ARM_MMU_MEMC : undef) + (defined(&ARM_MMU_GENERIC) ? &ARM_MMU_GENERIC : undef) + (defined(&ARM_MMU_XSCALE) ? &ARM_MMU_XSCALE : undef) != 0)) {
			eval 'sub PMAP_NEEDS_PTE_SYNC () {0;}' unless defined(&PMAP_NEEDS_PTE_SYNC);
		    }
		}
	    }
	    unless(defined(&PMAP_NEEDS_PTE_SYNC)) {
		eval 'sub PMAP_NEEDS_PTE_SYNC () { &pmap_needs_pte_sync;}' unless defined(&PMAP_NEEDS_PTE_SYNC);
		eval 'sub PMAP_INCLUDE_PTE_SYNC () {1;}' unless defined(&PMAP_INCLUDE_PTE_SYNC);
	    }
# some #ifdef were dropped here -- fill in the blanks
	    eval 'sub pmap_ptesync {
	        my($ptep,$cnt) = @_;
    		eval q({  &if ( &PMAP_NEEDS_PTE_SYNC) {  &cpu_dcache_wb_range(( &vaddr_t)$ptep, $cnt * $sizeof{ &pt_entry_t}); }  &dsb( &sy); });
	    }' unless defined(&pmap_ptesync);
	    eval 'sub PDE_SYNC {
	        my($pdep) = @_;
    		eval q( &pmap_ptesync(($pdep), 1));
	    }' unless defined(&PDE_SYNC);
	    eval 'sub PDE_SYNC_RANGE {
	        my($pdep, $cnt) = @_;
    		eval q( &pmap_ptesync(($pdep), ($cnt)));
	    }' unless defined(&PDE_SYNC_RANGE);
	    eval 'sub PTE_SYNC {
	        my($ptep) = @_;
    		eval q( &pmap_ptesync(($ptep),  &PAGE_SIZE /  &L2_S_SIZE));
	    }' unless defined(&PTE_SYNC);
	    eval 'sub PTE_SYNC_RANGE {
	        my($ptep, $cnt) = @_;
    		eval q( &pmap_ptesync(($ptep), ($cnt)));
	    }' unless defined(&PTE_SYNC_RANGE);
	    eval 'sub l1pte_valid_p {
	        my($pde) = @_;
    		eval q((($pde) != 0));
	    }' unless defined(&l1pte_valid_p);
	    eval 'sub l1pte_section_p {
	        my($pde) = @_;
    		eval q(((($pde) &  &L1_TYPE_MASK) ==  &L1_TYPE_S));
	    }' unless defined(&l1pte_section_p);
	    eval 'sub l1pte_supersection_p {
	        my($pde) = @_;
    		eval q(( &l1pte_section_p($pde)  && (($pde) &  &L1_S_V6_SUPER) != 0));
	    }' unless defined(&l1pte_supersection_p);
	    eval 'sub l1pte_page_p {
	        my($pde) = @_;
    		eval q(((($pde) &  &L1_TYPE_MASK) ==  &L1_TYPE_C));
	    }' unless defined(&l1pte_page_p);
	    eval 'sub l1pte_fpage_p {
	        my($pde) = @_;
    		eval q(((($pde) &  &L1_TYPE_MASK) ==  &L1_TYPE_F));
	    }' unless defined(&l1pte_fpage_p);
	    eval 'sub l1pte_pa {
	        my($pde) = @_;
    		eval q((($pde) &  &L1_C_ADDR_MASK));
	    }' unless defined(&l1pte_pa);
	    eval 'sub l1pte_index {
	        my($v) = @_;
    		eval q((( &vaddr_t)($v) >>  &L1_S_SHIFT));
	    }' unless defined(&l1pte_index);
	    eval 'sub l1pte_setone {
	        my($pdep,$pde) = @_;
    		eval q({ *$pdep = $pde; });
	    }' unless defined(&l1pte_setone);
	    eval 'sub l1pte_set {
	        my($pdep,$pde) = @_;
    		eval q({ *$pdep = $pde;  &if ( &l1pte_page_p($pde)) {  &KASSERTMSG(((( &uintptr_t)$pdep / $sizeof{$pde}) & ( &PAGE_SIZE /  &L2_T_SIZE - 1)) == 0, \\"%p\\", $pdep);  &for (\'int\'  &k = 1;  &k <  &PAGE_SIZE /  &L2_T_SIZE;  &k++) { $pde +=  &L2_T_SIZE; $pdep->[ &k] = $pde; } }  &else  &if ( &l1pte_supersection_p($pde)) {  &KASSERTMSG(((( &uintptr_t)$pdep / $sizeof{$pde}) & ( &L1_SS_SIZE /  &L1_S_SIZE - 1)) == 0, \\"%p\\", $pdep);  &for (\'int\'  &k = 1;  &k <  &L1_SS_SIZE /  &L1_S_SIZE;  &k++) { $pdep->[ &k] = $pde; } } });
	    }' unless defined(&l1pte_set);
	    eval 'sub l2pte_index {
	        my($v) = @_;
    		eval q((((($v) &  &L2_ADDR_BITS) >>  &PGSHIFT) << ( &PGSHIFT- &L2_S_SHIFT)));
	    }' unless defined(&l2pte_index);
	    eval 'sub l2pte_valid_p {
	        my($pte) = @_;
    		eval q(((($pte) &  &L2_TYPE_MASK) !=  &L2_TYPE_INV));
	    }' unless defined(&l2pte_valid_p);
	    eval 'sub l2pte_pa {
	        my($pte) = @_;
    		eval q((($pte) &  &L2_S_FRAME));
	    }' unless defined(&l2pte_pa);
	    eval 'sub l1pte_lpage_p {
	        my($pte) = @_;
    		eval q(((($pte) &  &L2_TYPE_MASK) ==  &L2_TYPE_L));
	    }' unless defined(&l1pte_lpage_p);
	    eval 'sub l2pte_minidata_p {
	        my($pte) = @_;
    		eval q(((($pte) & ( &L2_B |  &L2_C |  &L2_XS_T_TEX( &TEX_XSCALE_X))) == ( &L2_C |  &L2_XS_T_TEX( &TEX_XSCALE_X))));
	    }' unless defined(&l2pte_minidata_p);
	    eval 'sub l2pte_set {
	        my($ptep,$pte,$opte) = @_;
    		eval q({  &if ( &l1pte_lpage_p($pte)) {  &KASSERTMSG(((( &uintptr_t)$ptep / $sizeof{$pte}) & ( &L2_L_SIZE /  &L2_S_SIZE - 1)) == 0, \\"%p\\", $ptep);  &for (\'int\'  &k = 0;  &k <  &L2_L_SIZE /  &L2_S_SIZE;  &k++) { *$ptep++ = $pte; } }  &else {  &KASSERTMSG(((( &uintptr_t)$ptep / $sizeof{$pte}) & ( &PAGE_SIZE /  &L2_S_SIZE - 1)) == 0, \\"%p\\", $ptep);  &for (\'int\'  &k = 0;  &k <  &PAGE_SIZE /  &L2_S_SIZE;  &k++) {  &KASSERTMSG(*$ptep == $opte, \\"%#x [*%p] != %#x\\", *$ptep, $ptep, $opte); *$ptep++ = $pte; $pte +=  &L2_S_SIZE;  &if ($opte) $opte +=  &L2_S_SIZE; } } });
	    }' unless defined(&l2pte_set);
	    eval 'sub l2pte_reset {
	        my($ptep) = @_;
    		eval q({  &KASSERTMSG(((( &uintptr_t)$ptep / $sizeof{$ptep}) & ( &PAGE_SIZE /  &L2_S_SIZE - 1)) == 0, \\"%p\\", $ptep); *$ptep = 0;  &for (\'int\'  &k = 1;  &k <  &PAGE_SIZE /  &L2_S_SIZE;  &k++) { $ptep->[ &k] = 0; } });
	    }' unless defined(&l2pte_reset);
	    eval 'sub pmap_pde_v {
	        my($pde) = @_;
    		eval q( &l1pte_valid(*($pde)));
	    }' unless defined(&pmap_pde_v);
	    eval 'sub pmap_pde_section {
	        my($pde) = @_;
    		eval q( &l1pte_section_p(*($pde)));
	    }' unless defined(&pmap_pde_section);
	    eval 'sub pmap_pde_supersection {
	        my($pde) = @_;
    		eval q( &l1pte_supersection_p(*($pde)));
	    }' unless defined(&pmap_pde_supersection);
	    eval 'sub pmap_pde_page {
	        my($pde) = @_;
    		eval q( &l1pte_page_p(*($pde)));
	    }' unless defined(&pmap_pde_page);
	    eval 'sub pmap_pde_fpage {
	        my($pde) = @_;
    		eval q( &l1pte_fpage_p(*($pde)));
	    }' unless defined(&pmap_pde_fpage);
	    eval 'sub pmap_pte_v {
	        my($pte) = @_;
    		eval q( &l2pte_valid_p(*($pte)));
	    }' unless defined(&pmap_pte_v);
	    eval 'sub pmap_pte_pa {
	        my($pte) = @_;
    		eval q( &l2pte_pa(*($pte)));
	    }' unless defined(&pmap_pte_pa);
	    eval 'sub pte_value {
	        my($pte) = @_;
    		eval q({ $pte; });
	    }' unless defined(&pte_value);
	    eval 'sub pte_valid_p {
	        my($pte) = @_;
    		eval q({  &l2pte_valid_p($pte); });
	    }' unless defined(&pte_valid_p);
	    eval 'sub KERNEL_PD_SIZE () {( &L1_TABLE_SIZE - ( &KERNEL_BASE >>  &L1_S_SHIFT) * $sizeof{ &pd_entry_t});}' unless defined(&KERNEL_PD_SIZE);
	    if(defined(&FPU_VFP)) {
	    }
	    if(((defined(&ARM_MMU_GENERIC) ? &ARM_MMU_GENERIC : undef) + (defined(&ARM_MMU_SA1) ? &ARM_MMU_SA1 : undef) + (defined(&ARM_MMU_V6) ? &ARM_MMU_V6 : undef) + (defined(&ARM_MMU_V7) ? &ARM_MMU_V7 : undef)) != 0) {
		if(defined(&CPU_ARM8)) {
		}
		if(defined(&CPU_ARM9)) {
		}
		if(defined(&CPU_ARM10)) {
		}
		if(defined(&CPU_ARM11) ) {
		}
		if(defined(&CPU_ARM11MPCORE) ) {
		}
		if((defined(&ARM_MMU_V6) ? &ARM_MMU_V6 : undef) == 1) {
		}
		if((defined(&ARM_MMU_V7) ? &ARM_MMU_V7 : undef) == 1) {
		}
	    }
	    if((defined(&ARM_MMU_SA1) ? &ARM_MMU_SA1 : undef) == 1) {
	    }
	    if((defined(&ARM_MMU_XSCALE) ? &ARM_MMU_XSCALE : undef) == 1) {
		eval 'sub PMAP_UAREA {
		    my($va) = @_;
    		    eval q( &pmap_uarea($va));
		}' unless defined(&PMAP_UAREA);
	    }
	}
	eval 'sub KERNEL_PID () {0;}' unless defined(&KERNEL_PID);
	eval 'sub PMAP_DOMAINS () {15;}' unless defined(&PMAP_DOMAINS);
	eval 'sub PMAP_DOMAIN_KERNEL () {0;}' unless defined(&PMAP_DOMAIN_KERNEL);
	if(defined(&ARM_MMU_EXTENDED)) {
	    eval 'sub PMAP_DOMAIN_USER () {1;}' unless defined(&PMAP_DOMAIN_USER);
	    eval 'sub DOMAIN_DEFAULT () {(( &DOMAIN_CLIENT << ( &PMAP_DOMAIN_KERNEL*2)) | ( &DOMAIN_CLIENT << ( &PMAP_DOMAIN_USER*2)));}' unless defined(&DOMAIN_DEFAULT);
	} else {
	    eval 'sub DOMAIN_DEFAULT () {(( &DOMAIN_CLIENT << ( &PMAP_DOMAIN_KERNEL*2)));}' unless defined(&DOMAIN_DEFAULT);
	}
	eval 'sub L1_S_PROT_U_generic () {( &L1_S_AP( &AP_U));}' unless defined(&L1_S_PROT_U_generic);
	eval 'sub L1_S_PROT_W_generic () {( &L1_S_AP( &AP_W));}' unless defined(&L1_S_PROT_W_generic);
	eval 'sub L1_S_PROT_RO_generic () {(0);}' unless defined(&L1_S_PROT_RO_generic);
	eval 'sub L1_S_PROT_MASK_generic () {( &L1_S_PROT_U| &L1_S_PROT_W| &L1_S_PROT_RO);}' unless defined(&L1_S_PROT_MASK_generic);
	eval 'sub L1_S_PROT_U_xscale () {( &L1_S_AP( &AP_U));}' unless defined(&L1_S_PROT_U_xscale);
	eval 'sub L1_S_PROT_W_xscale () {( &L1_S_AP( &AP_W));}' unless defined(&L1_S_PROT_W_xscale);
	eval 'sub L1_S_PROT_RO_xscale () {(0);}' unless defined(&L1_S_PROT_RO_xscale);
	eval 'sub L1_S_PROT_MASK_xscale () {( &L1_S_PROT_U| &L1_S_PROT_W| &L1_S_PROT_RO);}' unless defined(&L1_S_PROT_MASK_xscale);
	eval 'sub L1_S_PROT_U_armv6 () {( &L1_S_AP( &AP_R) |  &L1_S_AP( &AP_U));}' unless defined(&L1_S_PROT_U_armv6);
	eval 'sub L1_S_PROT_W_armv6 () {( &L1_S_AP( &AP_W));}' unless defined(&L1_S_PROT_W_armv6);
	eval 'sub L1_S_PROT_RO_armv6 () {( &L1_S_AP( &AP_R) |  &L1_S_AP( &AP_RO));}' unless defined(&L1_S_PROT_RO_armv6);
	eval 'sub L1_S_PROT_MASK_armv6 () {( &L1_S_PROT_U| &L1_S_PROT_W| &L1_S_PROT_RO);}' unless defined(&L1_S_PROT_MASK_armv6);
	eval 'sub L1_S_PROT_U_armv7 () {( &L1_S_AP( &AP_R) |  &L1_S_AP( &AP_U));}' unless defined(&L1_S_PROT_U_armv7);
	eval 'sub L1_S_PROT_W_armv7 () {( &L1_S_AP( &AP_W));}' unless defined(&L1_S_PROT_W_armv7);
	eval 'sub L1_S_PROT_RO_armv7 () {( &L1_S_AP( &AP_R) |  &L1_S_AP( &AP_RO));}' unless defined(&L1_S_PROT_RO_armv7);
	eval 'sub L1_S_PROT_MASK_armv7 () {( &L1_S_PROT_U| &L1_S_PROT_W| &L1_S_PROT_RO);}' unless defined(&L1_S_PROT_MASK_armv7);
	eval 'sub L1_S_CACHE_MASK_generic () {( &L1_S_B| &L1_S_C);}' unless defined(&L1_S_CACHE_MASK_generic);
	eval 'sub L1_S_CACHE_MASK_xscale () {( &L1_S_B| &L1_S_C| &L1_S_XS_TEX( &TEX_XSCALE_X));}' unless defined(&L1_S_CACHE_MASK_xscale);
	eval 'sub L1_S_CACHE_MASK_armv6 () {( &L1_S_B| &L1_S_C| &L1_S_XS_TEX( &TEX_ARMV6_TEX));}' unless defined(&L1_S_CACHE_MASK_armv6);
	eval 'sub L1_S_CACHE_MASK_armv6n () {( &L1_S_B| &L1_S_C| &L1_S_XS_TEX( &TEX_ARMV6_TEX)| &L1_S_V6_S);}' unless defined(&L1_S_CACHE_MASK_armv6n);
	eval 'sub L1_S_CACHE_MASK_armv7 () {( &L1_S_B| &L1_S_C| &L1_S_XS_TEX( &TEX_ARMV6_TEX)| &L1_S_V6_S);}' unless defined(&L1_S_CACHE_MASK_armv7);
	eval 'sub L2_L_PROT_U_generic () {( &L2_AP( &AP_U));}' unless defined(&L2_L_PROT_U_generic);
	eval 'sub L2_L_PROT_W_generic () {( &L2_AP( &AP_W));}' unless defined(&L2_L_PROT_W_generic);
	eval 'sub L2_L_PROT_RO_generic () {(0);}' unless defined(&L2_L_PROT_RO_generic);
	eval 'sub L2_L_PROT_MASK_generic () {( &L2_L_PROT_U| &L2_L_PROT_W| &L2_L_PROT_RO);}' unless defined(&L2_L_PROT_MASK_generic);
	eval 'sub L2_L_PROT_U_xscale () {( &L2_AP( &AP_U));}' unless defined(&L2_L_PROT_U_xscale);
	eval 'sub L2_L_PROT_W_xscale () {( &L2_AP( &AP_W));}' unless defined(&L2_L_PROT_W_xscale);
	eval 'sub L2_L_PROT_RO_xscale () {(0);}' unless defined(&L2_L_PROT_RO_xscale);
	eval 'sub L2_L_PROT_MASK_xscale () {( &L2_L_PROT_U| &L2_L_PROT_W| &L2_L_PROT_RO);}' unless defined(&L2_L_PROT_MASK_xscale);
	eval 'sub L2_L_PROT_U_armv6n () {( &L2_AP0( &AP_R) |  &L2_AP0( &AP_U));}' unless defined(&L2_L_PROT_U_armv6n);
	eval 'sub L2_L_PROT_W_armv6n () {( &L2_AP0( &AP_W));}' unless defined(&L2_L_PROT_W_armv6n);
	eval 'sub L2_L_PROT_RO_armv6n () {( &L2_AP0( &AP_R) |  &L2_AP0( &AP_RO));}' unless defined(&L2_L_PROT_RO_armv6n);
	eval 'sub L2_L_PROT_MASK_armv6n () {( &L2_L_PROT_U| &L2_L_PROT_W| &L2_L_PROT_RO);}' unless defined(&L2_L_PROT_MASK_armv6n);
	eval 'sub L2_L_PROT_U_armv7 () {( &L2_AP0( &AP_R) |  &L2_AP0( &AP_U));}' unless defined(&L2_L_PROT_U_armv7);
	eval 'sub L2_L_PROT_W_armv7 () {( &L2_AP0( &AP_W));}' unless defined(&L2_L_PROT_W_armv7);
	eval 'sub L2_L_PROT_RO_armv7 () {( &L2_AP0( &AP_R) |  &L2_AP0( &AP_RO));}' unless defined(&L2_L_PROT_RO_armv7);
	eval 'sub L2_L_PROT_MASK_armv7 () {( &L2_L_PROT_U| &L2_L_PROT_W| &L2_L_PROT_RO);}' unless defined(&L2_L_PROT_MASK_armv7);
	eval 'sub L2_L_CACHE_MASK_generic () {( &L2_B| &L2_C);}' unless defined(&L2_L_CACHE_MASK_generic);
	eval 'sub L2_L_CACHE_MASK_xscale () {( &L2_B| &L2_C| &L2_XS_L_TEX( &TEX_XSCALE_X));}' unless defined(&L2_L_CACHE_MASK_xscale);
	eval 'sub L2_L_CACHE_MASK_armv6 () {( &L2_B| &L2_C| &L2_V6_L_TEX( &TEX_ARMV6_TEX));}' unless defined(&L2_L_CACHE_MASK_armv6);
	eval 'sub L2_L_CACHE_MASK_armv6n () {( &L2_B| &L2_C| &L2_V6_L_TEX( &TEX_ARMV6_TEX)| &L2_XS_S);}' unless defined(&L2_L_CACHE_MASK_armv6n);
	eval 'sub L2_L_CACHE_MASK_armv7 () {( &L2_B| &L2_C| &L2_V6_L_TEX( &TEX_ARMV6_TEX)| &L2_XS_S);}' unless defined(&L2_L_CACHE_MASK_armv7);
	eval 'sub L2_S_PROT_U_generic () {( &L2_AP( &AP_U));}' unless defined(&L2_S_PROT_U_generic);
	eval 'sub L2_S_PROT_W_generic () {( &L2_AP( &AP_W));}' unless defined(&L2_S_PROT_W_generic);
	eval 'sub L2_S_PROT_RO_generic () {(0);}' unless defined(&L2_S_PROT_RO_generic);
	eval 'sub L2_S_PROT_MASK_generic () {( &L2_S_PROT_U| &L2_S_PROT_W| &L2_S_PROT_RO);}' unless defined(&L2_S_PROT_MASK_generic);
	eval 'sub L2_S_PROT_U_xscale () {( &L2_AP0( &AP_U));}' unless defined(&L2_S_PROT_U_xscale);
	eval 'sub L2_S_PROT_W_xscale () {( &L2_AP0( &AP_W));}' unless defined(&L2_S_PROT_W_xscale);
	eval 'sub L2_S_PROT_RO_xscale () {(0);}' unless defined(&L2_S_PROT_RO_xscale);
	eval 'sub L2_S_PROT_MASK_xscale () {( &L2_S_PROT_U| &L2_S_PROT_W| &L2_S_PROT_RO);}' unless defined(&L2_S_PROT_MASK_xscale);
	eval 'sub L2_S_PROT_U_armv6n () {( &L2_AP0( &AP_R) |  &L2_AP0( &AP_U));}' unless defined(&L2_S_PROT_U_armv6n);
	eval 'sub L2_S_PROT_W_armv6n () {( &L2_AP0( &AP_W));}' unless defined(&L2_S_PROT_W_armv6n);
	eval 'sub L2_S_PROT_RO_armv6n () {( &L2_AP0( &AP_R) |  &L2_AP0( &AP_RO));}' unless defined(&L2_S_PROT_RO_armv6n);
	eval 'sub L2_S_PROT_MASK_armv6n () {( &L2_S_PROT_U| &L2_S_PROT_W| &L2_S_PROT_RO);}' unless defined(&L2_S_PROT_MASK_armv6n);
	eval 'sub L2_S_PROT_U_armv7 () {( &L2_AP0( &AP_R) |  &L2_AP0( &AP_U));}' unless defined(&L2_S_PROT_U_armv7);
	eval 'sub L2_S_PROT_W_armv7 () {( &L2_AP0( &AP_W));}' unless defined(&L2_S_PROT_W_armv7);
	eval 'sub L2_S_PROT_RO_armv7 () {( &L2_AP0( &AP_R) |  &L2_AP0( &AP_RO));}' unless defined(&L2_S_PROT_RO_armv7);
	eval 'sub L2_S_PROT_MASK_armv7 () {( &L2_S_PROT_U| &L2_S_PROT_W| &L2_S_PROT_RO);}' unless defined(&L2_S_PROT_MASK_armv7);
	eval 'sub L2_S_CACHE_MASK_generic () {( &L2_B| &L2_C);}' unless defined(&L2_S_CACHE_MASK_generic);
	eval 'sub L2_S_CACHE_MASK_xscale () {( &L2_B| &L2_C| &L2_XS_T_TEX( &TEX_XSCALE_X));}' unless defined(&L2_S_CACHE_MASK_xscale);
	eval 'sub L2_XS_CACHE_MASK_armv6 () {( &L2_B| &L2_C| &L2_V6_XS_TEX( &TEX_ARMV6_TEX));}' unless defined(&L2_XS_CACHE_MASK_armv6);
	if(defined(&ARMV6_EXTENDED_SMALL_PAGE)) {
	    eval 'sub L2_S_CACHE_MASK_armv6c () { &L2_XS_CACHE_MASK_armv6;}' unless defined(&L2_S_CACHE_MASK_armv6c);
	} else {
	    eval 'sub L2_S_CACHE_MASK_armv6c () { &L2_S_CACHE_MASK_generic;}' unless defined(&L2_S_CACHE_MASK_armv6c);
	}
	eval 'sub L2_S_CACHE_MASK_armv6n () {( &L2_B| &L2_C| &L2_V6_XS_TEX( &TEX_ARMV6_TEX)| &L2_XS_S);}' unless defined(&L2_S_CACHE_MASK_armv6n);
	eval 'sub L2_S_CACHE_MASK_armv7 () {( &L2_B| &L2_C| &L2_V6_XS_TEX( &TEX_ARMV6_TEX)| &L2_XS_S);}' unless defined(&L2_S_CACHE_MASK_armv7);
	eval 'sub L1_S_PROTO_generic () {( &L1_TYPE_S |  &L1_S_IMP);}' unless defined(&L1_S_PROTO_generic);
	eval 'sub L1_S_PROTO_xscale () {( &L1_TYPE_S);}' unless defined(&L1_S_PROTO_xscale);
	eval 'sub L1_S_PROTO_armv6 () {( &L1_TYPE_S);}' unless defined(&L1_S_PROTO_armv6);
	eval 'sub L1_S_PROTO_armv7 () {( &L1_TYPE_S);}' unless defined(&L1_S_PROTO_armv7);
	eval 'sub L1_SS_PROTO_generic () {0;}' unless defined(&L1_SS_PROTO_generic);
	eval 'sub L1_SS_PROTO_xscale () {0;}' unless defined(&L1_SS_PROTO_xscale);
	eval 'sub L1_SS_PROTO_armv6 () {( &L1_TYPE_S |  &L1_S_V6_SS);}' unless defined(&L1_SS_PROTO_armv6);
	eval 'sub L1_SS_PROTO_armv7 () {( &L1_TYPE_S |  &L1_S_V6_SS);}' unless defined(&L1_SS_PROTO_armv7);
	eval 'sub L1_C_PROTO_generic () {( &L1_TYPE_C |  &L1_C_IMP2);}' unless defined(&L1_C_PROTO_generic);
	eval 'sub L1_C_PROTO_xscale () {( &L1_TYPE_C);}' unless defined(&L1_C_PROTO_xscale);
	eval 'sub L1_C_PROTO_armv6 () {( &L1_TYPE_C);}' unless defined(&L1_C_PROTO_armv6);
	eval 'sub L1_C_PROTO_armv7 () {( &L1_TYPE_C);}' unless defined(&L1_C_PROTO_armv7);
	eval 'sub L2_L_PROTO () {( &L2_TYPE_L);}' unless defined(&L2_L_PROTO);
	eval 'sub L2_S_PROTO_generic () {( &L2_TYPE_S);}' unless defined(&L2_S_PROTO_generic);
	eval 'sub L2_S_PROTO_xscale () {( &L2_TYPE_XS);}' unless defined(&L2_S_PROTO_xscale);
	if(defined(&ARMV6_EXTENDED_SMALL_PAGE)) {
	    eval 'sub L2_S_PROTO_armv6c () {( &L2_TYPE_XS);}' unless defined(&L2_S_PROTO_armv6c);
	} else {
	    eval 'sub L2_S_PROTO_armv6c () {( &L2_TYPE_S);}' unless defined(&L2_S_PROTO_armv6c);
	}
	if(defined(&ARM_MMU_EXTENDED)) {
	    eval 'sub L2_S_PROTO_armv6n () {( &L2_TYPE_S| &L2_XS_XN);}' unless defined(&L2_S_PROTO_armv6n);
	} else {
	    eval 'sub L2_S_PROTO_armv6n () {( &L2_TYPE_S);}' unless defined(&L2_S_PROTO_armv6n);
	}
	if(defined(&ARM_MMU_EXTENDED)) {
	    eval 'sub L2_S_PROTO_armv7 () {( &L2_TYPE_S| &L2_XS_XN);}' unless defined(&L2_S_PROTO_armv7);
	} else {
	    eval 'sub L2_S_PROTO_armv7 () {( &L2_TYPE_S);}' unless defined(&L2_S_PROTO_armv7);
	}
	if((defined(&ARM_NMMUS) ? &ARM_NMMUS : undef) > 1) {
	    eval 'sub L1_S_PROT_U () { &pte_l1_s_prot_u;}' unless defined(&L1_S_PROT_U);
	    eval 'sub L1_S_PROT_W () { &pte_l1_s_prot_w;}' unless defined(&L1_S_PROT_W);
	    eval 'sub L1_S_PROT_RO () { &pte_l1_s_prot_ro;}' unless defined(&L1_S_PROT_RO);
	    eval 'sub L1_S_PROT_MASK () { &pte_l1_s_prot_mask;}' unless defined(&L1_S_PROT_MASK);
	    eval 'sub L2_S_PROT_U () { &pte_l2_s_prot_u;}' unless defined(&L2_S_PROT_U);
	    eval 'sub L2_S_PROT_W () { &pte_l2_s_prot_w;}' unless defined(&L2_S_PROT_W);
	    eval 'sub L2_S_PROT_RO () { &pte_l2_s_prot_ro;}' unless defined(&L2_S_PROT_RO);
	    eval 'sub L2_S_PROT_MASK () { &pte_l2_s_prot_mask;}' unless defined(&L2_S_PROT_MASK);
	    eval 'sub L2_L_PROT_U () { &pte_l2_l_prot_u;}' unless defined(&L2_L_PROT_U);
	    eval 'sub L2_L_PROT_W () { &pte_l2_l_prot_w;}' unless defined(&L2_L_PROT_W);
	    eval 'sub L2_L_PROT_RO () { &pte_l2_l_prot_ro;}' unless defined(&L2_L_PROT_RO);
	    eval 'sub L2_L_PROT_MASK () { &pte_l2_l_prot_mask;}' unless defined(&L2_L_PROT_MASK);
	    eval 'sub L1_S_CACHE_MASK () { &pte_l1_s_cache_mask;}' unless defined(&L1_S_CACHE_MASK);
	    eval 'sub L2_L_CACHE_MASK () { &pte_l2_l_cache_mask;}' unless defined(&L2_L_CACHE_MASK);
	    eval 'sub L2_S_CACHE_MASK () { &pte_l2_s_cache_mask;}' unless defined(&L2_S_CACHE_MASK);
	    eval 'sub L1_SS_PROTO () { &pte_l1_ss_proto;}' unless defined(&L1_SS_PROTO);
	    eval 'sub L1_S_PROTO () { &pte_l1_s_proto;}' unless defined(&L1_S_PROTO);
	    eval 'sub L1_C_PROTO () { &pte_l1_c_proto;}' unless defined(&L1_C_PROTO);
	    eval 'sub L2_S_PROTO () { &pte_l2_s_proto;}' unless defined(&L2_S_PROTO);
	    eval 'sub pmap_copy_page {
	        my($s, $d) = @_;
    		eval q((* &pmap_copy_page_func)(($s), ($d)));
	    }' unless defined(&pmap_copy_page);
	    eval 'sub pmap_zero_page {
	        my($d) = @_;
    		eval q((* &pmap_zero_page_func)(($d)));
	    }' unless defined(&pmap_zero_page);
	}
 elsif(((defined(&ARM_MMU_GENERIC) ? &ARM_MMU_GENERIC : undef) + (defined(&ARM_MMU_SA1) ? &ARM_MMU_SA1 : undef)) != 0) {
	    eval 'sub L1_S_PROT_U () { &L1_S_PROT_U_generic;}' unless defined(&L1_S_PROT_U);
	    eval 'sub L1_S_PROT_W () { &L1_S_PROT_W_generic;}' unless defined(&L1_S_PROT_W);
	    eval 'sub L1_S_PROT_RO () { &L1_S_PROT_RO_generic;}' unless defined(&L1_S_PROT_RO);
	    eval 'sub L1_S_PROT_MASK () { &L1_S_PROT_MASK_generic;}' unless defined(&L1_S_PROT_MASK);
	    eval 'sub L2_S_PROT_U () { &L2_S_PROT_U_generic;}' unless defined(&L2_S_PROT_U);
	    eval 'sub L2_S_PROT_W () { &L2_S_PROT_W_generic;}' unless defined(&L2_S_PROT_W);
	    eval 'sub L2_S_PROT_RO () { &L2_S_PROT_RO_generic;}' unless defined(&L2_S_PROT_RO);
	    eval 'sub L2_S_PROT_MASK () { &L2_S_PROT_MASK_generic;}' unless defined(&L2_S_PROT_MASK);
	    eval 'sub L2_L_PROT_U () { &L2_L_PROT_U_generic;}' unless defined(&L2_L_PROT_U);
	    eval 'sub L2_L_PROT_W () { &L2_L_PROT_W_generic;}' unless defined(&L2_L_PROT_W);
	    eval 'sub L2_L_PROT_RO () { &L2_L_PROT_RO_generic;}' unless defined(&L2_L_PROT_RO);
	    eval 'sub L2_L_PROT_MASK () { &L2_L_PROT_MASK_generic;}' unless defined(&L2_L_PROT_MASK);
	    eval 'sub L1_S_CACHE_MASK () { &L1_S_CACHE_MASK_generic;}' unless defined(&L1_S_CACHE_MASK);
	    eval 'sub L2_L_CACHE_MASK () { &L2_L_CACHE_MASK_generic;}' unless defined(&L2_L_CACHE_MASK);
	    eval 'sub L2_S_CACHE_MASK () { &L2_S_CACHE_MASK_generic;}' unless defined(&L2_S_CACHE_MASK);
	    eval 'sub L1_SS_PROTO () { &L1_SS_PROTO_generic;}' unless defined(&L1_SS_PROTO);
	    eval 'sub L1_S_PROTO () { &L1_S_PROTO_generic;}' unless defined(&L1_S_PROTO);
	    eval 'sub L1_C_PROTO () { &L1_C_PROTO_generic;}' unless defined(&L1_C_PROTO);
	    eval 'sub L2_S_PROTO () { &L2_S_PROTO_generic;}' unless defined(&L2_S_PROTO);
	    eval 'sub pmap_copy_page {
	        my($s, $d) = @_;
    		eval q( &pmap_copy_page_generic(($s), ($d)));
	    }' unless defined(&pmap_copy_page);
	    eval 'sub pmap_zero_page {
	        my($d) = @_;
    		eval q( &pmap_zero_page_generic(($d)));
	    }' unless defined(&pmap_zero_page);
	}
 elsif((defined(&ARM_MMU_V6N) ? &ARM_MMU_V6N : undef) != 0) {
	    eval 'sub L1_S_PROT_U () { &L1_S_PROT_U_armv6;}' unless defined(&L1_S_PROT_U);
	    eval 'sub L1_S_PROT_W () { &L1_S_PROT_W_armv6;}' unless defined(&L1_S_PROT_W);
	    eval 'sub L1_S_PROT_RO () { &L1_S_PROT_RO_armv6;}' unless defined(&L1_S_PROT_RO);
	    eval 'sub L1_S_PROT_MASK () { &L1_S_PROT_MASK_armv6;}' unless defined(&L1_S_PROT_MASK);
	    eval 'sub L2_S_PROT_U () { &L2_S_PROT_U_armv6n;}' unless defined(&L2_S_PROT_U);
	    eval 'sub L2_S_PROT_W () { &L2_S_PROT_W_armv6n;}' unless defined(&L2_S_PROT_W);
	    eval 'sub L2_S_PROT_RO () { &L2_S_PROT_RO_armv6n;}' unless defined(&L2_S_PROT_RO);
	    eval 'sub L2_S_PROT_MASK () { &L2_S_PROT_MASK_armv6n;}' unless defined(&L2_S_PROT_MASK);
	    eval 'sub L2_L_PROT_U () { &L2_L_PROT_U_armv6n;}' unless defined(&L2_L_PROT_U);
	    eval 'sub L2_L_PROT_W () { &L2_L_PROT_W_armv6n;}' unless defined(&L2_L_PROT_W);
	    eval 'sub L2_L_PROT_RO () { &L2_L_PROT_RO_armv6n;}' unless defined(&L2_L_PROT_RO);
	    eval 'sub L2_L_PROT_MASK () { &L2_L_PROT_MASK_armv6n;}' unless defined(&L2_L_PROT_MASK);
	    eval 'sub L1_S_CACHE_MASK () { &L1_S_CACHE_MASK_armv6n;}' unless defined(&L1_S_CACHE_MASK);
	    eval 'sub L2_L_CACHE_MASK () { &L2_L_CACHE_MASK_armv6n;}' unless defined(&L2_L_CACHE_MASK);
	    eval 'sub L2_S_CACHE_MASK () { &L2_S_CACHE_MASK_armv6n;}' unless defined(&L2_S_CACHE_MASK);
	    eval 'sub L1_SS_PROTO () { &L1_SS_PROTO_armv6;}' unless defined(&L1_SS_PROTO);
	    eval 'sub L1_S_PROTO () { &L1_S_PROTO_armv6;}' unless defined(&L1_S_PROTO);
	    eval 'sub L1_C_PROTO () { &L1_C_PROTO_armv6;}' unless defined(&L1_C_PROTO);
	    eval 'sub L2_S_PROTO () { &L2_S_PROTO_armv6n;}' unless defined(&L2_S_PROTO);
	    eval 'sub pmap_copy_page {
	        my($s, $d) = @_;
    		eval q( &pmap_copy_page_generic(($s), ($d)));
	    }' unless defined(&pmap_copy_page);
	    eval 'sub pmap_zero_page {
	        my($d) = @_;
    		eval q( &pmap_zero_page_generic(($d)));
	    }' unless defined(&pmap_zero_page);
	}
 elsif((defined(&ARM_MMU_V6C) ? &ARM_MMU_V6C : undef) != 0) {
	    eval 'sub L1_S_PROT_U () { &L1_S_PROT_U_generic;}' unless defined(&L1_S_PROT_U);
	    eval 'sub L1_S_PROT_W () { &L1_S_PROT_W_generic;}' unless defined(&L1_S_PROT_W);
	    eval 'sub L1_S_PROT_RO () { &L1_S_PROT_RO_generic;}' unless defined(&L1_S_PROT_RO);
	    eval 'sub L1_S_PROT_MASK () { &L1_S_PROT_MASK_generic;}' unless defined(&L1_S_PROT_MASK);
	    eval 'sub L2_S_PROT_U () { &L2_S_PROT_U_generic;}' unless defined(&L2_S_PROT_U);
	    eval 'sub L2_S_PROT_W () { &L2_S_PROT_W_generic;}' unless defined(&L2_S_PROT_W);
	    eval 'sub L2_S_PROT_RO () { &L2_S_PROT_RO_generic;}' unless defined(&L2_S_PROT_RO);
	    eval 'sub L2_S_PROT_MASK () { &L2_S_PROT_MASK_generic;}' unless defined(&L2_S_PROT_MASK);
	    eval 'sub L2_L_PROT_U () { &L2_L_PROT_U_generic;}' unless defined(&L2_L_PROT_U);
	    eval 'sub L2_L_PROT_W () { &L2_L_PROT_W_generic;}' unless defined(&L2_L_PROT_W);
	    eval 'sub L2_L_PROT_RO () { &L2_L_PROT_RO_generic;}' unless defined(&L2_L_PROT_RO);
	    eval 'sub L2_L_PROT_MASK () { &L2_L_PROT_MASK_generic;}' unless defined(&L2_L_PROT_MASK);
	    eval 'sub L1_S_CACHE_MASK () { &L1_S_CACHE_MASK_generic;}' unless defined(&L1_S_CACHE_MASK);
	    eval 'sub L2_L_CACHE_MASK () { &L2_L_CACHE_MASK_generic;}' unless defined(&L2_L_CACHE_MASK);
	    eval 'sub L2_S_CACHE_MASK () { &L2_S_CACHE_MASK_generic;}' unless defined(&L2_S_CACHE_MASK);
	    eval 'sub L1_SS_PROTO () { &L1_SS_PROTO_armv6;}' unless defined(&L1_SS_PROTO);
	    eval 'sub L1_S_PROTO () { &L1_S_PROTO_generic;}' unless defined(&L1_S_PROTO);
	    eval 'sub L1_C_PROTO () { &L1_C_PROTO_generic;}' unless defined(&L1_C_PROTO);
	    eval 'sub L2_S_PROTO () { &L2_S_PROTO_generic;}' unless defined(&L2_S_PROTO);
	    eval 'sub pmap_copy_page {
	        my($s, $d) = @_;
    		eval q( &pmap_copy_page_generic(($s), ($d)));
	    }' unless defined(&pmap_copy_page);
	    eval 'sub pmap_zero_page {
	        my($d) = @_;
    		eval q( &pmap_zero_page_generic(($d)));
	    }' unless defined(&pmap_zero_page);
	}
 elsif((defined(&ARM_MMU_XSCALE) ? &ARM_MMU_XSCALE : undef) == 1) {
	    eval 'sub L1_S_PROT_U () { &L1_S_PROT_U_generic;}' unless defined(&L1_S_PROT_U);
	    eval 'sub L1_S_PROT_W () { &L1_S_PROT_W_generic;}' unless defined(&L1_S_PROT_W);
	    eval 'sub L1_S_PROT_RO () { &L1_S_PROT_RO_generic;}' unless defined(&L1_S_PROT_RO);
	    eval 'sub L1_S_PROT_MASK () { &L1_S_PROT_MASK_generic;}' unless defined(&L1_S_PROT_MASK);
	    eval 'sub L2_S_PROT_U () { &L2_S_PROT_U_xscale;}' unless defined(&L2_S_PROT_U);
	    eval 'sub L2_S_PROT_W () { &L2_S_PROT_W_xscale;}' unless defined(&L2_S_PROT_W);
	    eval 'sub L2_S_PROT_RO () { &L2_S_PROT_RO_xscale;}' unless defined(&L2_S_PROT_RO);
	    eval 'sub L2_S_PROT_MASK () { &L2_S_PROT_MASK_xscale;}' unless defined(&L2_S_PROT_MASK);
	    eval 'sub L2_L_PROT_U () { &L2_L_PROT_U_generic;}' unless defined(&L2_L_PROT_U);
	    eval 'sub L2_L_PROT_W () { &L2_L_PROT_W_generic;}' unless defined(&L2_L_PROT_W);
	    eval 'sub L2_L_PROT_RO () { &L2_L_PROT_RO_generic;}' unless defined(&L2_L_PROT_RO);
	    eval 'sub L2_L_PROT_MASK () { &L2_L_PROT_MASK_generic;}' unless defined(&L2_L_PROT_MASK);
	    eval 'sub L1_S_CACHE_MASK () { &L1_S_CACHE_MASK_xscale;}' unless defined(&L1_S_CACHE_MASK);
	    eval 'sub L2_L_CACHE_MASK () { &L2_L_CACHE_MASK_xscale;}' unless defined(&L2_L_CACHE_MASK);
	    eval 'sub L2_S_CACHE_MASK () { &L2_S_CACHE_MASK_xscale;}' unless defined(&L2_S_CACHE_MASK);
	    eval 'sub L1_SS_PROTO () { &L1_SS_PROTO_xscale;}' unless defined(&L1_SS_PROTO);
	    eval 'sub L1_S_PROTO () { &L1_S_PROTO_xscale;}' unless defined(&L1_S_PROTO);
	    eval 'sub L1_C_PROTO () { &L1_C_PROTO_xscale;}' unless defined(&L1_C_PROTO);
	    eval 'sub L2_S_PROTO () { &L2_S_PROTO_xscale;}' unless defined(&L2_S_PROTO);
	    eval 'sub pmap_copy_page {
	        my($s, $d) = @_;
    		eval q( &pmap_copy_page_xscale(($s), ($d)));
	    }' unless defined(&pmap_copy_page);
	    eval 'sub pmap_zero_page {
	        my($d) = @_;
    		eval q( &pmap_zero_page_xscale(($d)));
	    }' unless defined(&pmap_zero_page);
	}
 elsif((defined(&ARM_MMU_V7) ? &ARM_MMU_V7 : undef) == 1) {
	    eval 'sub L1_S_PROT_U () { &L1_S_PROT_U_armv7;}' unless defined(&L1_S_PROT_U);
	    eval 'sub L1_S_PROT_W () { &L1_S_PROT_W_armv7;}' unless defined(&L1_S_PROT_W);
	    eval 'sub L1_S_PROT_RO () { &L1_S_PROT_RO_armv7;}' unless defined(&L1_S_PROT_RO);
	    eval 'sub L1_S_PROT_MASK () { &L1_S_PROT_MASK_armv7;}' unless defined(&L1_S_PROT_MASK);
	    eval 'sub L2_S_PROT_U () { &L2_S_PROT_U_armv7;}' unless defined(&L2_S_PROT_U);
	    eval 'sub L2_S_PROT_W () { &L2_S_PROT_W_armv7;}' unless defined(&L2_S_PROT_W);
	    eval 'sub L2_S_PROT_RO () { &L2_S_PROT_RO_armv7;}' unless defined(&L2_S_PROT_RO);
	    eval 'sub L2_S_PROT_MASK () { &L2_S_PROT_MASK_armv7;}' unless defined(&L2_S_PROT_MASK);
	    eval 'sub L2_L_PROT_U () { &L2_L_PROT_U_armv7;}' unless defined(&L2_L_PROT_U);
	    eval 'sub L2_L_PROT_W () { &L2_L_PROT_W_armv7;}' unless defined(&L2_L_PROT_W);
	    eval 'sub L2_L_PROT_RO () { &L2_L_PROT_RO_armv7;}' unless defined(&L2_L_PROT_RO);
	    eval 'sub L2_L_PROT_MASK () { &L2_L_PROT_MASK_armv7;}' unless defined(&L2_L_PROT_MASK);
	    eval 'sub L1_S_CACHE_MASK () { &L1_S_CACHE_MASK_armv7;}' unless defined(&L1_S_CACHE_MASK);
	    eval 'sub L2_L_CACHE_MASK () { &L2_L_CACHE_MASK_armv7;}' unless defined(&L2_L_CACHE_MASK);
	    eval 'sub L2_S_CACHE_MASK () { &L2_S_CACHE_MASK_armv7;}' unless defined(&L2_S_CACHE_MASK);
	    eval 'sub L1_SS_PROTO () { &L1_SS_PROTO_armv7;}' unless defined(&L1_SS_PROTO);
	    eval 'sub L1_S_PROTO () { &L1_S_PROTO_armv7;}' unless defined(&L1_S_PROTO);
	    eval 'sub L1_C_PROTO () { &L1_C_PROTO_armv7;}' unless defined(&L1_C_PROTO);
	    eval 'sub L2_S_PROTO () { &L2_S_PROTO_armv7;}' unless defined(&L2_S_PROTO);
	    eval 'sub pmap_copy_page {
	        my($s, $d) = @_;
    		eval q( &pmap_copy_page_generic(($s), ($d)));
	    }' unless defined(&pmap_copy_page);
	    eval 'sub pmap_zero_page {
	        my($d) = @_;
    		eval q( &pmap_zero_page_generic(($d)));
	    }' unless defined(&pmap_zero_page);
	}
	eval 'sub l1pte_set_writable {
	    my($pte) = @_;
    	    eval q(((($pte) & ~ &L1_S_PROT_RO) |  &L1_S_PROT_W));
	}' unless defined(&l1pte_set_writable);
	eval 'sub l1pte_set_readonly {
	    my($pte) = @_;
    	    eval q(((($pte) & ~ &L1_S_PROT_W) |  &L1_S_PROT_RO));
	}' unless defined(&l1pte_set_readonly);
	eval 'sub l2pte_set_writable {
	    my($pte) = @_;
    	    eval q(((($pte) & ~ &L2_S_PROT_RO) |  &L2_S_PROT_W));
	}' unless defined(&l2pte_set_writable);
	eval 'sub l2pte_set_readonly {
	    my($pte) = @_;
    	    eval q(((($pte) & ~ &L2_S_PROT_W) |  &L2_S_PROT_RO));
	}' unless defined(&l2pte_set_readonly);
	eval 'sub l2pte_writable_p {
	    my($pte) = @_;
    	    eval q(((($pte) &  &L2_S_PROT_W) ==  &L2_S_PROT_W  && ( &L2_S_PROT_RO == 0|| (($pte) &  &L2_S_PROT_RO) !=  &L2_S_PROT_RO)));
	}' unless defined(&l2pte_writable_p);
	eval 'sub L1_S_PROT {
	    my($ku, $pr) = @_;
    	    eval q(( ((($ku) ==  &PTE_USER) ?  &L1_S_PROT_U | ((($pr) &  &VM_PROT_WRITE) ?  &L1_S_PROT_W : 0) : ((( &L1_S_PROT_RO  && (($pr) & ( &VM_PROT_READ |  &VM_PROT_WRITE)) ==  &VM_PROT_READ) ?  &L1_S_PROT_RO :  &L1_S_PROT_W))) ));
	}' unless defined(&L1_S_PROT);
	eval 'sub L2_L_PROT {
	    my($ku, $pr) = @_;
    	    eval q(( ((($ku) ==  &PTE_USER) ?  &L2_L_PROT_U | ((($pr) &  &VM_PROT_WRITE) ?  &L2_L_PROT_W : 0) : ((( &L2_L_PROT_RO  && (($pr) & ( &VM_PROT_READ |  &VM_PROT_WRITE)) ==  &VM_PROT_READ) ?  &L2_L_PROT_RO :  &L2_L_PROT_W))) ));
	}' unless defined(&L2_L_PROT);
	eval 'sub L2_S_PROT {
	    my($ku, $pr) = @_;
    	    eval q(( ((($ku) ==  &PTE_USER) ?  &L2_S_PROT_U | ((($pr) &  &VM_PROT_WRITE) ?  &L2_S_PROT_W : 0) : ((( &L2_S_PROT_RO  && (($pr) & ( &VM_PROT_READ |  &VM_PROT_WRITE)) ==  &VM_PROT_READ) ?  &L2_S_PROT_RO :  &L2_S_PROT_W))) ));
	}' unless defined(&L2_S_PROT);
	eval 'sub L1_SS_MAPPABLE_P {
	    my($va, $pa, $size) = @_;
    	    eval q((((($va) | ($pa)) &  &L1_SS_OFFSET) == 0 && ($size) >=  &L1_SS_SIZE));
	}' unless defined(&L1_SS_MAPPABLE_P);
	eval 'sub L1_S_MAPPABLE_P {
	    my($va, $pa, $size) = @_;
    	    eval q((((($va) | ($pa)) &  &L1_S_OFFSET) == 0 && ($size) >=  &L1_S_SIZE));
	}' unless defined(&L1_S_MAPPABLE_P);
	eval 'sub L2_L_MAPPABLE_P {
	    my($va, $pa, $size) = @_;
    	    eval q((((($va) | ($pa)) &  &L2_L_OFFSET) == 0 && ($size) >=  &L2_L_SIZE));
	}' unless defined(&L2_L_MAPPABLE_P);
	eval 'sub PMAP_MAPSIZE1 () { &L2_L_SIZE;}' unless defined(&PMAP_MAPSIZE1);
	eval 'sub PMAP_MAPSIZE2 () { &L1_S_SIZE;}' unless defined(&PMAP_MAPSIZE2);
	if(((defined(&ARM_MMU_V6) ? &ARM_MMU_V6 : undef) + (defined(&ARM_MMU_V7) ? &ARM_MMU_V7 : undef)) > 0) {
	    eval 'sub PMAP_MAPSIZE3 () { &L1_SS_SIZE;}' unless defined(&PMAP_MAPSIZE3);
	}
	unless(defined(&_LOCORE)) {
	    eval 'sub POOL_VTOPHYS {
	        my($va) = @_;
    		eval q( &vtophys(( &vaddr_t) ($va)));
	    }' unless defined(&POOL_VTOPHYS);
	    if(defined(&PMAP_NEED_ALLOC_POOLPAGE)) {
		eval 'sub PMAP_ALLOC_POOLPAGE () { &arm_pmap_alloc_poolpage;}' unless defined(&PMAP_ALLOC_POOLPAGE);
	    }
	    if(defined(&PMAP_NEED_ALLOC_POOLPAGE) || defined(&__HAVE_MM_MD_DIRECT_MAPPED_PHYS)) {
		eval 'sub PMAP_MAP_POOLPAGE {
		    my($pa) = @_;
    		    eval q( &pmap_map_poolpage($pa));
		}' unless defined(&PMAP_MAP_POOLPAGE);
		eval 'sub PMAP_UNMAP_POOLPAGE {
		    my($va) = @_;
    		    eval q( &pmap_unmap_poolpage($va));
		}' unless defined(&PMAP_UNMAP_POOLPAGE);
	    }
	    eval 'sub __HAVE_PMAP_PV_TRACK () {1;}' unless defined(&__HAVE_PMAP_PV_TRACK);
	    eval 'sub __HAVE_VM_PAGE_MD () {1;}' unless defined(&__HAVE_VM_PAGE_MD);
	    eval 'sub pvh_list () { ($pp->{pvh_list});}' unless defined(&pvh_list);
	    eval 'sub pvh_attrs () { ($pp->{pvh_attrs});}' unless defined(&pvh_attrs);
	    eval 'sub uro_mappings () { ($pp->{uro_mappings});}' unless defined(&uro_mappings);
	    eval 'sub urw_mappings () { ($pp->{urw_mappings});}' unless defined(&urw_mappings);
	    eval 'sub kro_mappings () { ($pp->{k_u}->{s_mappings[0]});}' unless defined(&kro_mappings);
	    eval 'sub krw_mappings () { ($pp->{k_u}->{s_mappings[1]});}' unless defined(&krw_mappings);
	    eval 'sub k_mappings () { ($pp->{k_u}->{i_mappings});}' unless defined(&k_mappings);
	    eval 'sub PMAP_PAGE_TO_MD {
	        my($ppage) = @_;
    		eval q( &container_of(($ppage), \'struct vm_page_md\',  &pp));
	    }' unless defined(&PMAP_PAGE_TO_MD);
	    if((defined(&ARM_MMU_V6) ? &ARM_MMU_V6 : undef) > 0) {
		eval 'sub VM_MDPAGE_PVH_ATTRS_INIT {
		    my($pg) = @_;
    		    eval q(($pg)-> ($mdpage->{pvh_attrs}) =  &VM_PAGE_TO_PHYS($pg) &  &arm_cache_prefer_mask);
		}' unless defined(&VM_MDPAGE_PVH_ATTRS_INIT);
	    } else {
		eval 'sub VM_MDPAGE_PVH_ATTRS_INIT {
		    my($pg) = @_;
    		    eval q(($pg)-> ($mdpage->{pvh_attrs}) = 0);
		}' unless defined(&VM_MDPAGE_PVH_ATTRS_INIT);
	    }
	    eval 'sub VM_MDPAGE_INIT {
	        my($pg) = @_;
    		eval q( &do {  &SLIST_INIT(($pg)-> ($mdpage->{pvh_list}));  &VM_MDPAGE_PVH_ATTRS_INIT($pg); ($pg)-> ($mdpage->{uro_mappings}) = 0; ($pg)-> ($mdpage->{urw_mappings}) = 0; ($pg)-> ($mdpage->{k_mappings}) = 0; }  &while ( 0));
	    }' unless defined(&VM_MDPAGE_INIT);
	    unless(defined(&__BSD_PTENTRY_T__)) {
		eval 'sub __BSD_PTENTRY_T__ () {1;}' unless defined(&__BSD_PTENTRY_T__);
		eval 'sub PRIxPTE () { &PRIx32;}' unless defined(&PRIxPTE);
	    }
	}
    }
}
1;
