/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkCredentials;
import com.jetbrains.php.config.interpreters.PhpSdkHelpersManager;
import com.jetbrains.php.remote.PhpRemoteSdkBundle;
import com.jetbrains.php.remote.PhpRemoteTransfer;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import javax.swing.JComponent;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRemoteSshHelpersManager
extends PhpSdkHelpersManager {
    private static final RemoteSdkUtil.RemoteSdkUpdatedCallback EMPTY_CALLBACK = new RemoteSdkUtil.RemoteSdkUpdatedCallback(){

        public void updated(RemoteSdkCredentials data) {
        }
    };
    private final PhpRemoteSdkAdditionalData mySdkData;

    public PhpRemoteSshHelpersManager(PhpRemoteSdkAdditionalData sdkData) {
        this.mySdkData = sdkData;
    }

    @Nullable
    public String getHelperScript(@NotNull String scriptName) throws ExecutionException {
        if (scriptName == null) {
            PhpRemoteSshHelpersManager.$$$reportNull$$$0(0);
        }
        return StringUtil.isEmpty((String)this.mySdkData.getHelpersPath()) ? null : this.mySdkData.getHelpersPath() + "/" + scriptName;
    }

    public void update(@NotNull Project project, @Nullable JComponent parentComponent) throws ExecutionException, InterruptedException {
        if (project == null) {
            PhpRemoteSshHelpersManager.$$$reportNull$$$0(1);
        }
        RemoteSdkCredentials credentials = this.mySdkData.getRemoteSdkCredentials(project, false);
        String helpersPath = this.mySdkData.getHelpersPath();
        String title = PhpRemoteSdkBundle.message("validation.ssh.connecting.to.remote.host.title", credentials.getHost());
        try {
            RemoteSdkUtil.RemoteSdkUpdatedCallback callback;
            Object object = callback = StringUtil.isEmpty((String)helpersPath) ? EMPTY_CALLBACK : null;
            if (!RemoteSdkUtil.testConnectionAndCreateHelpersPath((Project)project, (RemoteSdkCredentials)credentials, (String)title, (RemoteSdkUtil.RemoteSdkUpdatedCallback)callback)) {
                throw new ExecutionException(PhpRemoteSdkBundle.message("validation.ssh.can.not.connect.to.remote.host", credentials.getFullInterpreterPath()));
            }
            String newHelpersPath = credentials.getHelpersPath();
            if (StringUtil.isNotEmpty((String)newHelpersPath) && !StringUtil.equals((CharSequence)helpersPath, (CharSequence)newHelpersPath)) {
                this.mySdkData.setHelpersPath(newHelpersPath);
            }
        }
        catch (FileSystemException e) {
            throw new ExecutionException((Throwable)e);
        }
        if (StringUtil.isEmpty((String)this.mySdkData.getHelpersPath())) {
            throw new ExecutionException(PhpRemoteSdkBundle.message("validation.ssh.can.not.connect.to.remote.host", credentials.getFullInterpreterPath()));
        }
        new PhpRemoteTransfer(project, parentComponent, credentials).uploadHelpers();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/remote/PhpRemoteSshHelpersManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getHelperScript";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

