/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.injection;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.blade.psi.BladePsiLanguageInjectionHost;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import com.jetbrains.php.lang.PhpLanguage;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BladeInjectionInfo {
    @NotNull
    @NonNls
    private final String myPhpPrefix;
    @NotNull
    @NonNls
    private final String myPhpSuffix;
    @NotNull
    private final IElementType myContentType;

    public static BladeInjectionInfo createForDirective(@NotNull @NonNls String phpPrefix, @NotNull @NonNls String phpSuffix) {
        if (phpPrefix == null) {
            BladeInjectionInfo.$$$reportNull$$$0(0);
        }
        if (phpSuffix == null) {
            BladeInjectionInfo.$$$reportNull$$$0(1);
        }
        return new BladeInjectionInfo(phpPrefix, phpSuffix, BladeTokenTypes.DIRECTIVE_PARAMETER_CONTENT){

            @Override
            public int getBladePrefixLength() {
                return "(".length();
            }

            @Override
            public int getBladeSuffixLength() {
                return ")".length();
            }
        };
    }

    public BladeInjectionInfo(@NotNull @NonNls String phpPrefix, @NotNull @NonNls String phpSuffix, @NotNull IElementType contentType) {
        if (phpPrefix == null) {
            BladeInjectionInfo.$$$reportNull$$$0(2);
        }
        if (phpSuffix == null) {
            BladeInjectionInfo.$$$reportNull$$$0(3);
        }
        if (contentType == null) {
            BladeInjectionInfo.$$$reportNull$$$0(4);
        }
        this.myPhpPrefix = phpPrefix;
        this.myPhpSuffix = phpSuffix;
        this.myContentType = contentType;
    }

    @NotNull
    public String getPhpPrefix() {
        String string = this.myPhpPrefix;
        if (string == null) {
            BladeInjectionInfo.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getPhpSuffix() {
        String string = this.myPhpSuffix;
        if (string == null) {
            BladeInjectionInfo.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isConfigurable() {
        return true;
    }

    public abstract int getBladePrefixLength();

    public abstract int getBladeSuffixLength();

    @NotNull
    public IElementType getContentType() {
        IElementType iElementType = this.myContentType;
        if (iElementType == null) {
            BladeInjectionInfo.$$$reportNull$$$0(7);
        }
        return iElementType;
    }

    @Nullable
    public String getUnmodifiablePresentableDescription() {
        return null;
    }

    @Nullable
    public TextRange convertInjectedRangeToInnerVisible(BladePsiLanguageInjectionHost host, TextRange injected, int length, boolean showEmptyBorderIntersections) {
        if (injected.getEndOffset() < this.getPhpPrefix().length() || injected.getStartOffset() > length - this.getPhpSuffix().length()) {
            return null;
        }
        if (!(showEmptyBorderIntersections || injected.getEndOffset() != this.getPhpPrefix().length() && injected.getStartOffset() != length - this.getPhpSuffix().length())) {
            return null;
        }
        int start = Math.max(injected.getStartOffset() - this.getPhpPrefix().length(), 0);
        int end = Math.min(injected.getEndOffset() - this.getPhpPrefix().length(), length - this.getPhpSuffix().length() - this.getPhpPrefix().length());
        return TextRange.create((int)(this.getBladePrefixLength() + start), (int)(this.getBladePrefixLength() + end));
    }

    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars, @NotNull BladePsiLanguageInjectionHost host) {
        String text;
        TextRange intersection;
        if (rangeInsideHost == null) {
            BladeInjectionInfo.$$$reportNull$$$0(8);
        }
        if (outChars == null) {
            BladeInjectionInfo.$$$reportNull$$$0(9);
        }
        if (host == null) {
            BladeInjectionInfo.$$$reportNull$$$0(10);
        }
        if ((intersection = rangeInsideHost.intersection(new TextRange(0, (text = host.getText()).length()))) != null) {
            outChars.append(intersection.substring(text));
        }
        return true;
    }

    public void handleContentChange(@NotNull LeafElement content, @NotNull TextRange changeRange, String newContent) {
        int startOffsetInParent;
        TextRange contentRange;
        TextRange intersection;
        if (content == null) {
            BladeInjectionInfo.$$$reportNull$$$0(11);
        }
        if (changeRange == null) {
            BladeInjectionInfo.$$$reportNull$$$0(12);
        }
        if ((intersection = changeRange.intersection(contentRange = new TextRange(startOffsetInParent = content.getStartOffsetInParent(), startOffsetInParent + content.getTextLength()))) == null) {
            return;
        }
        if (intersection.getStartOffset() > changeRange.getStartOffset()) {
            newContent = newContent.substring(intersection.getStartOffset() - changeRange.getStartOffset());
        }
        if (intersection.getEndOffset() < changeRange.getEndOffset()) {
            newContent = newContent.substring(0, newContent.length() - changeRange.getEndOffset() + intersection.getEndOffset());
        }
        String oldContentText = content.getText();
        if (intersection.getStartOffset() > contentRange.getStartOffset()) {
            newContent = oldContentText.substring(0, intersection.getStartOffset() - contentRange.getStartOffset()) + newContent;
        }
        if (intersection.getEndOffset() < contentRange.getEndOffset()) {
            newContent = newContent + oldContentText.substring(oldContentText.length() - contentRange.getEndOffset() + intersection.getEndOffset());
        }
        content.replaceWithText(newContent);
    }

    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        int offsetInHost;
        if (rangeInsideHost == null) {
            BladeInjectionInfo.$$$reportNull$$$0(13);
        }
        if ((offsetInHost = offsetInDecoded + rangeInsideHost.getStartOffset()) < 0 || offsetInHost > rangeInsideHost.getEndOffset()) {
            return -1;
        }
        return offsetInHost;
    }

    public void register(MultiHostRegistrar registrar, BladePsiLanguageInjectionHost host, PsiElement child) {
        int startOffsetInParent = child.getStartOffsetInParent();
        TextRange rangeInsideHost = new TextRange(startOffsetInParent, startOffsetInParent + child.getTextLength());
        registrar.startInjecting((Language)PhpLanguage.INSTANCE).addPlace(this.getPhpPrefix(), this.getPhpSuffix(), (PsiLanguageInjectionHost)host, rangeInsideHost).doneInjecting();
    }

    @NonNls
    public String toString() {
        return "BIInfo{prefix='" + this.myPhpPrefix + '\'' + ", suffix='" + this.myPhpSuffix + '\'' + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpPrefix";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpSuffix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/blade/injection/BladeInjectionInfo";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInsideHost";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/blade/injection/BladeInjectionInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpPrefix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpSuffix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createForDirective";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getOffsetInHost";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

