/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.clt;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.jetbrains.php.framework.FrameworkUtils;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkDescription;
import com.jetbrains.php.framework.generators.FrameworkDescriptionProvider;
import com.jetbrains.php.wordpress.WPBundle;
import com.jetbrains.php.wordpress.clt.WPCommand;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class WPCliUtils {
    private static final Logger LOG = Logger.getInstance(WPCliUtils.class);

    private WPCliUtils() {
    }

    static List<FrameworkCommand> getFrameworkCommands(String[] wpCliPath, @NotNull ProgressIndicator pi) throws ExecutionException, FrameworkDescriptionProvider.FrameworkParseException {
        List<FrameworkCommand> commands;
        if (pi == null) {
            WPCliUtils.$$$reportNull$$$0(0);
        }
        FrameworkDescription wpCliFramework = WPCliUtils.getWPCliFrameworkDescription(wpCliPath);
        ScriptRunnerUtil.ScriptOutput commandsOutput = WPCliUtils.getCommandsDescription(wpCliPath);
        FrameworkUtils.checkProgress((ProgressIndicator)pi);
        String descriptiveOutput = commandsOutput.getDescriptiveOutput();
        try {
            commands = WPCliUtils.parseCommandsJson(descriptiveOutput, wpCliFramework);
        }
        catch (JsonSyntaxException e) {
            LOG.warn(descriptiveOutput, (Throwable)e);
            throw new FrameworkDescriptionProvider.FrameworkParseException(WPCliUtils.getDescriptionCommand(wpCliPath), descriptiveOutput, WPBundle.message("wp.cli.failed.to.parse.output.0", e.getMessage()));
        }
        if (commands.isEmpty()) {
            throw new FrameworkDescriptionProvider.FrameworkParseException(WPCliUtils.getDescriptionCommand(wpCliPath), descriptiveOutput, WPBundle.message("wp.cli.no.commands.found", new Object[0]));
        }
        return commands;
    }

    static List<FrameworkCommand> parseCommandsJson(String json, @NotNull FrameworkDescription framework) {
        JsonParser parser;
        JsonElement element;
        if (framework == null) {
            WPCliUtils.$$$reportNull$$$0(1);
        }
        if (!((element = (parser = new JsonParser()).parse(json)) instanceof JsonObject)) {
            throw new JsonSyntaxException("Parsed element is not an object.");
        }
        JsonObject object = (JsonObject)element;
        ArrayList<WPCommand> commands = new ArrayList<WPCommand>();
        String name = WPCliUtils.getPrimitiveString(object, "name", true);
        String description = WPCliUtils.getPrimitiveString(object, "description", true);
        String longdesc = WPCliUtils.getPrimitiveString(object, "longdesc", true);
        JsonElement subcommands = object.get("subcommands");
        if (subcommands.isJsonArray()) {
            JsonArray subcommandsArray = subcommands.getAsJsonArray();
            for (JsonElement commandElement : subcommandsArray) {
                WPCommand command = WPCommand.parseCommand(commandElement, null);
                commands.add(command);
            }
        }
        String help = WPCliUtils.constructHelp(name, description, longdesc, commands);
        framework.setHelp(help);
        ArrayList<FrameworkCommand> result = new ArrayList<FrameworkCommand>();
        for (WPCommand command : commands) {
            result.addAll(command.transform(framework));
        }
        return result;
    }

    private static String constructHelp(String name, String description, String longdesc, List<WPCommand> commands) {
        StringBuilder sb = new StringBuilder();
        sb.append("<strong>").append(name).append("</strong><br/>");
        sb.append(description).append("<br/><br/>");
        sb.append(longdesc).append("<br/><br/>");
        sb.append("<table>\n<tr><td><strong>Arguments:</strong></td>");
        for (WPCommand command : commands) {
            sb.append("<tr>");
            sb.append("<td valign=\"baseline\">").append(command.getName()).append("</td></td>").append(command.getDescription()).append("</td>");
            sb.append("</tr>");
        }
        sb.append("</table><br/>\n");
        return sb.toString();
    }

    static String getPrimitiveString(JsonObject source, String name, boolean failFast) {
        JsonElement element = source.get(name);
        if (element != null && element.isJsonPrimitive()) {
            return element.getAsString();
        }
        if (failFast) {
            if (element == null) {
                throw new JsonSyntaxException("Failed to find element " + name + " in " + source);
            }
            if (!element.isJsonPrimitive()) {
                throw new JsonSyntaxException("Failed element " + name + " is not primitive in " + source);
            }
        }
        return "";
    }

    private static ScriptRunnerUtil.ScriptOutput getCommandsDescription(String[] wpCliPath) throws ExecutionException {
        return FrameworkUtils.executeCommandWithFullOutput((String[])WPCliUtils.getDescriptionCommand(wpCliPath), null, (boolean)true, (boolean)false);
    }

    @NonNls
    private static String[] getDescriptionCommand(String[] wpCliPath) {
        switch (wpCliPath.length) {
            case 0: {
                return new String[]{"", "cli", "cmd-dump"};
            }
            case 1: {
                return new String[]{wpCliPath[0], "cli", "cmd-dump"};
            }
        }
        return new String[]{wpCliPath[0], wpCliPath[1], "cli", "cmd-dump"};
    }

    @NonNls
    static FrameworkDescription getWPCliFrameworkDescription(@NonNls String[] wpCliPath) {
        String invokeText = wpCliPath[0];
        if (invokeText.contains(" ")) {
            invokeText = "\"" + invokeText + "\"";
        }
        if (wpCliPath.length > 1) {
            String pharPath = wpCliPath[1];
            if (pharPath.contains(" ")) {
                pharPath = "\"" + pharPath + "\"";
            }
            invokeText = invokeText + " " + pharPath;
        }
        return new FrameworkDescription("WP-CLI_" + FrameworkUtils.getCurrentFormattedDate(), invokeText, "wp", "", true, "org.wp-cli", null);
    }

    static String htmlizeText(String helpText) {
        helpText = helpText.replaceAll("<", "&lt;");
        helpText = helpText.replaceAll(">", "&gt;");
        helpText = helpText.replaceAll("\n", "<br>");
        return helpText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pi";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/wordpress/clt/WPCliUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFrameworkCommands";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseCommandsJson";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

