/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.util;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.Utils;
import com.intellij.openapi.graph.GraphUtil;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.ui.popup.JBPopup;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class DiagramUtils {
    private DiagramUtils() {
    }

    public static boolean setBestPopupSizeForGraph(JBPopup popup, DiagramBuilder builder) {
        return GraphUtil.setBestPopupSizeForGraph((JBPopup)popup, (GraphBuilder)((GraphBuilder)builder));
    }

    public static Point getBestPositionForNode(DiagramBuilder builder) {
        return Utils.getBestPositionForNode((GraphBuilder)builder);
    }

    public static Dimension calcGraphSize(DiagramBuilder builder) {
        return GraphUtil.calcGraphSize((GraphBuilder)((GraphBuilder)builder));
    }

    public static <NODE_TYPE> List<NODE_TYPE> getSelectedNodes(GraphBuilder<NODE_TYPE, ?> builder) {
        return GraphUtil.getSelectedNodes(builder);
    }

    public static ArrayList<DiagramNode> getSelectedNodes(DiagramBuilder builder) {
        return (ArrayList)GraphUtil.getSelectedNodes((GraphBuilder)((GraphBuilder)builder));
    }

    public static boolean isNodeWithoutBody(DiagramBuilder builder, Node node) {
        NodeRealizer realizer = builder.getGraph().getRealizer(node);
        if (realizer == null) {
            return false;
        }
        return realizer.getHeight() < 30.0;
    }

    public static List<DiagramEdge> getSelectedEdges(DiagramBuilder builder) {
        ArrayList<DiagramEdge> selectedEdges = new ArrayList<DiagramEdge>();
        EdgeCursor ec = builder.getGraph().selectedEdges();
        while (ec.ok()) {
            Edge edge = ec.edge();
            DiagramEdge edgeObject = builder.getEdgeObject(edge);
            if (edgeObject != null) {
                selectedEdges.add(edgeObject);
            }
            ec.next();
        }
        return selectedEdges;
    }

    public static void navigateTo(DiagramNode node) {
        DiagramBuilder builder = (DiagramBuilder)node.getUserData(Utils.GRAPH_BUILDER);
        if (builder != null) {
            GraphViewUtil.navigateTo((Object)node, (GraphBuilder)((GraphBuilder)builder));
        }
    }
}

