/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.Indent;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonLanguage;
import com.intellij.json.formatter.JsonBlock;
import com.intellij.json.formatter.JsonCodeStyleSettings;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class JsonFormattingBuilderModel
implements FormattingModelBuilder {
    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        JsonCodeStyleSettings customSettings = (JsonCodeStyleSettings)settings.getCustomSettings(JsonCodeStyleSettings.class);
        SpacingBuilder spacingBuilder = JsonFormattingBuilderModel.createSpacingBuilder(settings);
        JsonBlock block = new JsonBlock(null, element.getNode(), customSettings, null, Indent.getSmartIndent((Indent.Type)Indent.Type.CONTINUATION), null, spacingBuilder);
        FormattingModel formattingModel = FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)element.getContainingFile(), (Block)block, (CodeStyleSettings)settings);
        if (formattingModel == null) {
            JsonFormattingBuilderModel.$$$reportNull$$$0(0);
        }
        return formattingModel;
    }

    @NotNull
    static SpacingBuilder createSpacingBuilder(CodeStyleSettings settings) {
        JsonCodeStyleSettings jsonSettings = (JsonCodeStyleSettings)settings.getCustomSettings(JsonCodeStyleSettings.class);
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)JsonLanguage.INSTANCE);
        int spacesBeforeComma = commonSettings.SPACE_BEFORE_COMMA ? 1 : 0;
        int spacesBeforeColon = jsonSettings.SPACE_BEFORE_COLON ? 1 : 0;
        int spacesAfterColon = jsonSettings.SPACE_AFTER_COLON ? 1 : 0;
        SpacingBuilder spacingBuilder = new SpacingBuilder(settings, (Language)JsonLanguage.INSTANCE).before(JsonElementTypes.COLON).spacing(spacesBeforeColon, spacesBeforeColon, 0, false, 0).after(JsonElementTypes.COLON).spacing(spacesAfterColon, spacesAfterColon, 0, false, 0).withinPair(JsonElementTypes.L_BRACKET, JsonElementTypes.R_BRACKET).spaceIf(commonSettings.SPACE_WITHIN_BRACKETS, true).withinPair(JsonElementTypes.L_CURLY, JsonElementTypes.R_CURLY).spaceIf(commonSettings.SPACE_WITHIN_BRACES, true).before(JsonElementTypes.COMMA).spacing(spacesBeforeComma, spacesBeforeComma, 0, false, 0).after(JsonElementTypes.COMMA).spaceIf(commonSettings.SPACE_AFTER_COMMA);
        if (spacingBuilder == null) {
            JsonFormattingBuilderModel.$$$reportNull$$$0(1);
        }
        return spacingBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/json/formatter/JsonFormattingBuilderModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSpacingBuilder";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

