/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.Nullable;

public class TestEditorTabGroup {
    private final String name;
    private final LinkedHashMap<VirtualFile, Pair<FileEditor, FileEditorProvider>> myOpenedTabs = new LinkedHashMap();
    private VirtualFile myOpenedFile;

    public TestEditorTabGroup(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void openTab(VirtualFile virtualFile, FileEditor fileEditor, FileEditorProvider fileEditorProvider) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myOpenedTabs.put(virtualFile, (Pair<FileEditor, FileEditorProvider>)Pair.pair((Object)fileEditor, (Object)fileEditorProvider));
        this.myOpenedFile = virtualFile;
    }

    @Nullable
    public Pair<FileEditor, FileEditorProvider> getOpenedEditor() {
        VirtualFile openedFile = this.getOpenedFile();
        if (openedFile == null) {
            return null;
        }
        return this.myOpenedTabs.get(openedFile);
    }

    @Nullable
    public VirtualFile getOpenedFile() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myOpenedFile;
    }

    public void setOpenedFile(VirtualFile file2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myOpenedFile = file2;
    }

    public void closeTab(VirtualFile virtualFile) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myOpenedFile = null;
        this.myOpenedTabs.remove(virtualFile);
    }

    @Nullable
    public Pair<FileEditor, FileEditorProvider> getEditorAndProvider(VirtualFile file2) {
        return this.myOpenedTabs.get(file2);
    }

    public boolean contains(VirtualFile file2) {
        return this.myOpenedTabs.containsKey(file2);
    }

    public int getTabCount() {
        return this.myOpenedTabs.size();
    }
}

