/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ComboContentLayout;
import com.intellij.openapi.wm.impl.content.ComboIcon;
import com.intellij.ui.Gray;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class ContentComboLabel
extends BaseLabel {
    private final ComboIcon myComboIcon = new ComboIcon(){

        @Override
        public Rectangle getIconRec() {
            return new Rectangle(ContentComboLabel.this.getWidth() - this.getIconWidth() - 3, 0, this.getIconWidth(), ContentComboLabel.this.getHeight());
        }

        @Override
        public boolean isActive() {
            return ContentComboLabel.this.myUi.myWindow.isActive();
        }
    };
    private final ComboContentLayout myLayout;

    public ContentComboLabel(ComboContentLayout layout) {
        super(layout.myUi, true);
        this.myLayout = layout;
        this.addMouseListener(new MouseAdapter(){});
        if (ScreenReader.isActive()) {
            this.setFocusable(true);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getModifiers() == 0 && e.getKeyCode() == 32) {
                        ContentComboLabel.this.myUi.toggleContentPopup();
                    }
                    super.keyPressed(e);
                }
            });
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (UIUtil.isActionClick((MouseEvent)e)) {
            this.myUi.toggleContentPopup();
        }
    }

    void update() {
        this.setBorder((Border)(this.isToDrawCombo() ? JBUI.Borders.empty((int)0, (int)8) : JBUI.Borders.empty()));
        this.updateTextAndIcon(this.getContent(), true);
    }

    @Override
    protected boolean allowEngravement() {
        return this.myUi == null || this.myUi.myWindow.isActive();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        if (!this.isMinimumSizeSet()) {
            Insets insets;
            size.width = this.isToDrawCombo() ? this.myComboIcon.getIconWidth() : 0;
            Icon icon = this.getIcon();
            if (icon != null) {
                size.width += icon.getIconWidth() + this.getIconTextGap();
            }
            if ((insets = this.getInsets()) != null) {
                size.width += insets.left + insets.right;
            }
        }
        return size;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (!this.isPreferredSizeSet() && this.isToDrawCombo()) {
            size.width += this.myComboIcon.getIconWidth();
        }
        return size;
    }

    private boolean isToDrawCombo() {
        return this.myLayout.isToDrawCombo();
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.isToDrawCombo()) {
            this.myComboIcon.paintIcon(this, g);
            g.setColor(Gray._255.withAlpha(100));
        }
    }

    @Override
    public Content getContent() {
        return this.myUi.myManager.getSelectedContent();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleContentComboLabel();
        }
        return this.accessibleContext;
    }

    protected class AccessibleContentComboLabel
    extends BaseLabel.AccessibleBaseLabel
    implements AccessibleAction {
        protected AccessibleContentComboLabel() {
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }

        @Override
        public String getAccessibleActionDescription(int index) {
            return index == 0 ? UIManager.getString("ComboBox.togglePopupText") : null;
        }

        @Override
        public boolean doAccessibleAction(int index) {
            if (index == 0) {
                ContentComboLabel.this.myUi.toggleContentPopup();
                return true;
            }
            return false;
        }
    }
}

