/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.idea.StartupUtil;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.net.NetUtils;
import io.netty.channel.oio.OioEventLoopGroup;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.CustomPortServerManager;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.SubServer;

public class BuiltInServerManagerImpl
extends BuiltInServerManager
implements BaseComponent {
    private static final Logger LOG = Logger.getInstance(BuiltInServerManager.class);
    public static final NotNullLazyValue<NotificationGroup> NOTIFICATION_GROUP = new NotNullLazyValue<NotificationGroup>(){

        @NotNull
        protected NotificationGroup compute() {
            NotificationGroup notificationGroup = new NotificationGroup("Built-in Server", NotificationDisplayType.STICKY_BALLOON, true);
            if (notificationGroup == null) {
                1.$$$reportNull$$$0(0);
            }
            return notificationGroup;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/BuiltInServerManagerImpl$1", "compute"));
        }
    };
    @NonNls
    public static final String PROPERTY_RPC_PORT = "rpc.port";
    private static final int PORTS_COUNT = 20;
    private final AtomicBoolean started = new AtomicBoolean(false);
    @Nullable
    private BuiltInServer server;

    public int getPort() {
        return this.server == null ? BuiltInServerManagerImpl.getDefaultPort() : this.server.getPort();
    }

    public BuiltInServerManager waitForStart() {
        Future<?> serverStartFuture = this.startServerInPooledThread();
        if (serverStartFuture != null) {
            LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode() || !ApplicationManager.getApplication().isDispatchThread());
            try {
                serverStartFuture.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        return this;
    }

    private static int getDefaultPort() {
        if (System.getProperty(PROPERTY_RPC_PORT) == null) {
            return ApplicationManager.getApplication().isUnitTestMode() ? 64463 : 63342;
        }
        return Integer.parseInt(System.getProperty(PROPERTY_RPC_PORT));
    }

    public void initComponent() {
        this.startServerInPooledThread();
    }

    private Future<?> startServerInPooledThread() {
        if (!this.started.compareAndSet(false, true)) {
            return null;
        }
        return ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                BuiltInServer mainServer = StartupUtil.getServer();
                this.server = mainServer == null || mainServer.getEventLoopGroup() instanceof OioEventLoopGroup ? BuiltInServer.start(1, BuiltInServerManagerImpl.getDefaultPort(), 20, false, null) : BuiltInServer.start(mainServer.getEventLoopGroup(), false, BuiltInServerManagerImpl.getDefaultPort(), 20, true, null);
                BuiltInServerManagerImpl.bindCustomPorts(this.server);
            }
            catch (Throwable e) {
                LOG.info(e);
                ((NotificationGroup)NOTIFICATION_GROUP.getValue()).createNotification("Cannot start internal HTTP server. Git integration, JavaScript debugger and LiveEdit may operate with errors. Please check your firewall settings and restart " + ApplicationNamesInfo.getInstance().getFullProductName(), NotificationType.ERROR).notify(null);
                return;
            }
            LOG.info("built-in server started, port " + this.server.getPort());
            Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)this.server);
        });
    }

    @Nullable
    public Disposable getServerDisposable() {
        return this.server;
    }

    public boolean isOnBuiltInWebServer(@Nullable Url url) {
        return url != null && !StringUtil.isEmpty((String)url.getAuthority()) && BuiltInServerManagerImpl.isOnBuiltInWebServerByAuthority(url.getAuthority());
    }

    public Url addAuthToken(@NotNull Url url) {
        if (url == null) {
            BuiltInServerManagerImpl.$$$reportNull$$$0(0);
        }
        if (url.getParameters() != null) {
            return url;
        }
        return Urls.newUrl(Objects.requireNonNull(url.getScheme()), Objects.requireNonNull(url.getAuthority()), url.getPath(), Collections.singletonMap("_ijt", BuiltInWebServerKt.acquireToken()));
    }

    public void configureRequestToWebServer(@NotNull URLConnection connection) {
        if (connection == null) {
            BuiltInServerManagerImpl.$$$reportNull$$$0(1);
        }
        connection.setRequestProperty("x-ijt", BuiltInWebServerKt.acquireToken());
    }

    private static void bindCustomPorts(@NotNull BuiltInServer server) {
        if (server == null) {
            BuiltInServerManagerImpl.$$$reportNull$$$0(2);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        for (CustomPortServerManager customPortServerManager : (CustomPortServerManager[])CustomPortServerManager.EP_NAME.getExtensions()) {
            try {
                new SubServer(customPortServerManager, server).bind(customPortServerManager.getPort());
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    public static boolean isOnBuiltInWebServerByAuthority(@NotNull String authority) {
        int portIndex;
        if (authority == null) {
            BuiltInServerManagerImpl.$$$reportNull$$$0(3);
        }
        if ((portIndex = authority.indexOf(58)) < 0 || portIndex == authority.length() - 1) {
            return false;
        }
        int port = StringUtil.parseInt((String)authority.substring(portIndex + 1), (int)-1);
        if (port == -1) {
            return false;
        }
        BuiltInServerOptions options = BuiltInServerOptions.getInstance();
        int idePort = BuiltInServerManager.getInstance().getPort();
        if (options.builtInServerPort != port && idePort != port) {
            return false;
        }
        String host = authority.substring(0, portIndex);
        if (NetUtils.isLocalhost((String)host)) {
            return true;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(host);
            return inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress() || options.builtInServerAvailableExternally && idePort != port && NetworkInterface.getByInetAddress(inetAddress) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authority";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/ide/BuiltInServerManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addAuthToken";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "configureRequestToWebServer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "bindCustomPorts";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isOnBuiltInWebServerByAuthority";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

