/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.Platform;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CommandLineUtil {
    private static final char INESCAPABLE_QUOTE = '\uefef';
    private static final Pattern WIN_BACKSLASHES_PRECEDING_QUOTE = Pattern.compile("(\\\\+)(?=\"|$)");
    private static final Pattern WIN_CARET_SPECIAL = Pattern.compile("[&<>()@^|!%]");
    private static final Pattern WIN_QUOTE_SPECIAL = Pattern.compile("[ \t\"*?\\[{}~()']");
    private static final Pattern WIN_QUIET_COMMAND = Pattern.compile("((?:@\\s*)++)(.*)", 2);
    private static final char Q = '\"';
    private static final String QQ = "\"\"";

    @NotNull
    public static String specialQuote(@NotNull String parameter) {
        if (parameter == null) {
            CommandLineUtil.$$$reportNull$$$0(0);
        }
        String string = CommandLineUtil.quote(parameter, '\uefef');
        if (string == null) {
            CommandLineUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static List<String> toCommandLine(@NotNull List<String> command) {
        if (command == null) {
            CommandLineUtil.$$$reportNull$$$0(2);
        }
        assert (!command.isEmpty());
        List<String> list = CommandLineUtil.toCommandLine(command.get(0), command.subList(1, command.size()));
        if (list == null) {
            CommandLineUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public static List<String> toCommandLine(@NotNull String command, @NotNull List<String> parameters) {
        if (command == null) {
            CommandLineUtil.$$$reportNull$$$0(4);
        }
        if (parameters == null) {
            CommandLineUtil.$$$reportNull$$$0(5);
        }
        List<String> list = CommandLineUtil.toCommandLine(command, parameters, Platform.current());
        if (list == null) {
            CommandLineUtil.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public static List<String> toCommandLine(@NotNull String command, @NotNull List<String> parameters, @NotNull Platform platform) {
        if (command == null) {
            CommandLineUtil.$$$reportNull$$$0(7);
        }
        if (parameters == null) {
            CommandLineUtil.$$$reportNull$$$0(8);
        }
        if (platform == null) {
            CommandLineUtil.$$$reportNull$$$0(9);
        }
        ArrayList<String> commandLine = ContainerUtil.newArrayListWithCapacity(parameters.size() + 1);
        commandLine.add(FileUtilRt.toSystemDependentName(command, platform.fileSeparator));
        if (platform != Platform.WINDOWS) {
            for (String parameter : parameters) {
                if (CommandLineUtil.isQuoted(parameter, '\uefef')) {
                    parameter = CommandLineUtil.quote(StringUtil.unquoteString(parameter, '\uefef'), '\"');
                }
                commandLine.add(parameter);
            }
        } else {
            CommandLineUtil.addToWindowsCommandLine(command, parameters, commandLine);
        }
        ArrayList<String> arrayList = commandLine;
        if (arrayList == null) {
            CommandLineUtil.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static void addToWindowsCommandLine(String command, List<String> parameters, List<? super String> commandLine) {
        boolean isCmdParam = CommandLineUtil.isWinShell(command);
        int cmdInvocationDepth = CommandLineUtil.isWinShellScript(command) ? 2 : (isCmdParam ? 1 : 0);
        QuoteFlag quoteFlag = new QuoteFlag(false);
        for (int i = 0; i < parameters.size(); ++i) {
            boolean inescapableQuoting;
            String parameter = parameters.get(i);
            boolean bl = inescapableQuoting = !(parameter = StringUtil.unquoteString(parameter, '\uefef')).equals(parameters.get(i));
            if (parameter.isEmpty()) {
                commandLine.add(QQ);
                continue;
            }
            if (isCmdParam && parameter.startsWith("/") && parameter.length() == 2) {
                commandLine.add(parameter);
                continue;
            }
            String parameterPrefix = "";
            if (isCmdParam) {
                Matcher m = WIN_QUIET_COMMAND.matcher(parameter);
                if (m.matches()) {
                    parameterPrefix = m.group(1);
                    parameter = m.group(2);
                }
                if (parameter.equalsIgnoreCase("echo")) {
                    String parametersJoin = StringUtil.join(ContainerUtil.subList(parameters, i), " ");
                    quoteFlag.toggle();
                    parameter = CommandLineUtil.escapeParameter(parametersJoin, quoteFlag, cmdInvocationDepth, false);
                    commandLine.add(parameter);
                    break;
                }
                if (!parameter.equalsIgnoreCase("call") && ((isCmdParam = CommandLineUtil.isWinShell(parameter)) || CommandLineUtil.isWinShellScript(parameter))) {
                    ++cmdInvocationDepth;
                }
            }
            parameter = cmdInvocationDepth > 0 && !isCmdParam || inescapableQuoting ? CommandLineUtil.escapeParameter(parameter, quoteFlag, cmdInvocationDepth, !inescapableQuoting) : CommandLineUtil.backslashEscapeQuotes(parameter);
            commandLine.add(parameterPrefix.isEmpty() ? parameter : parameterPrefix + parameter);
        }
    }

    private static String escapeParameter(String s, QuoteFlag quoteFlag, int cmdInvocationDepth, boolean escapeQuotingInside) {
        String escapingCarets = StringUtil.repeatSymbol('^', (1 << cmdInvocationDepth) - 1);
        return escapeQuotingInside ? CommandLineUtil.quoteEscape(s, quoteFlag, escapingCarets) : CommandLineUtil.caretEscape(s, quoteFlag, escapingCarets);
    }

    private static String caretEscape(String s, QuoteFlag quoteFlag, String escapingCarets) {
        StringBuilder sb = new StringBuilder().append('\"');
        quoteFlag.toggle();
        int lastPos = 0;
        Matcher m = WIN_CARET_SPECIAL.matcher(s);
        while (m.find()) {
            quoteFlag.update(s, lastPos, m.start());
            sb.append(s, lastPos, m.start());
            if (!quoteFlag.enabled) {
                sb.append(escapingCarets);
            }
            sb.append(m.group());
            lastPos = m.end();
        }
        quoteFlag.update(s, lastPos, s.length());
        sb.append(s, lastPos, s.length());
        quoteFlag.toggle();
        return sb.append('\"').toString();
    }

    private static String quoteEscape(String s, QuoteFlag quoteFlag, String escapingCarets) {
        StringBuilder sb = new StringBuilder();
        int lastPos = 0;
        Matcher m = WIN_CARET_SPECIAL.matcher(s);
        while (m.find()) {
            quoteFlag.update(s, lastPos, m.start());
            CommandLineUtil.appendQuoted(sb, s.substring(lastPos, m.start()));
            String specialText = m.group();
            boolean isCaret = specialText.equals("^");
            if (isCaret) {
                specialText = escapingCarets + specialText;
            }
            if (isCaret == quoteFlag.enabled) {
                CommandLineUtil.appendQuoted(sb, specialText);
            } else {
                sb.append(specialText);
            }
            lastPos = m.end();
        }
        quoteFlag.update(s, lastPos, s.length());
        CommandLineUtil.appendQuoted(sb, s.substring(lastPos));
        if (!CommandLineUtil.isQuoted(sb, '\"') && StringUtil.indexOfAny(sb, " \t") >= 0) {
            if (sb.charAt(0) != '\"') {
                sb.insert(0, QQ);
            }
            if (sb.charAt(sb.length() - 1) != '\"') {
                sb.append(QQ);
            }
        }
        return sb.toString();
    }

    private static void appendQuoted(StringBuilder sb, String s) {
        int numTrailingBackslashes;
        if (s.isEmpty()) {
            return;
        }
        if (WIN_CARET_SPECIAL.matcher(s = CommandLineUtil.backslashEscapeQuotes(s)).find()) {
            s = CommandLineUtil.quote(s, '\"');
        }
        if ((numTrailingBackslashes = CommandLineUtil.removeClosingQuote(sb)) < 0) {
            sb.append(s);
        } else {
            if (WIN_BACKSLASHES_PRECEDING_QUOTE.matcher(s = StringUtil.unquoteString(s, '\"')).matches()) {
                StringUtil.repeatSymbol(sb, '\\', numTrailingBackslashes);
            }
            sb.append(s).append('\"');
        }
    }

    private static String backslashEscapeQuotes(String s) {
        assert (!s.isEmpty());
        String result = WIN_BACKSLASHES_PRECEDING_QUOTE.matcher(s).replaceAll("$1$1").replace("\"", "\\\"");
        if (!result.equals(s) || WIN_QUOTE_SPECIAL.matcher(s).find()) {
            result = CommandLineUtil.quote(result, '\"');
        }
        return result;
    }

    private static int removeClosingQuote(StringBuilder sb) {
        if (sb.length() < 2 || sb.charAt(sb.length() - 1) != '\"') {
            return -1;
        }
        sb.setLength(sb.length() - 1);
        int numTrailingBackslashes = sb.length() - StringUtil.trimTrailing(sb, '\\').length();
        StringUtil.repeatSymbol(sb, '\\', numTrailingBackslashes / 2);
        if (numTrailingBackslashes % 2 == 1) {
            StringUtil.repeatSymbol(sb, '\\', numTrailingBackslashes / 2 + 1);
            sb.append('\"');
            return -1;
        }
        return numTrailingBackslashes / 2;
    }

    @NotNull
    public static String getWinShellName() {
        if ("cmd.exe" == null) {
            CommandLineUtil.$$$reportNull$$$0(11);
        }
        return "cmd.exe";
    }

    private static boolean isWinShell(String command) {
        return "cmd".equalsIgnoreCase(command) || "cmd.exe".equalsIgnoreCase(command);
    }

    private static boolean isWinShellScript(String command) {
        return CommandLineUtil.endsWithIgnoreCase(command, ".cmd") || CommandLineUtil.endsWithIgnoreCase(command, ".bat");
    }

    private static boolean endsWithIgnoreCase(String str, String suffix) {
        return str.regionMatches(true, str.length() - suffix.length(), suffix, 0, suffix.length());
    }

    private static String quote(String s, char ch) {
        return !CommandLineUtil.isQuoted(s, ch) ? ch + s + ch : s;
    }

    private static boolean isQuoted(CharSequence s, char ch) {
        return s.length() >= 2 && s.charAt(0) == ch && s.charAt(s.length() - 1) == ch;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeParameterOnWindows(@NotNull String parameter, boolean isWinShell) {
        String result;
        String s;
        if (parameter == null) {
            CommandLineUtil.$$$reportNull$$$0(12);
        }
        if ((s = StringUtil.convertLineSeparators(parameter, "")).isEmpty()) {
            if (QQ == null) {
                CommandLineUtil.$$$reportNull$$$0(13);
            }
            return QQ;
        }
        boolean hadLineBreaks = !s.equals(parameter);
        String string = result = isWinShell ? CommandLineUtil.escapeParameter(s, new QuoteFlag(hadLineBreaks), 1, true) : CommandLineUtil.backslashEscapeQuotes(s);
        if (hadLineBreaks) {
            result = CommandLineUtil.quote(result, '\"');
        }
        String string2 = result;
        if (string2 == null) {
            CommandLineUtil.$$$reportNull$$$0(14);
        }
        return string2;
    }

    @NotNull
    public static String extractPresentableName(@NotNull String commandLine) {
        List<String> args;
        String execName;
        String executable;
        List<String> words;
        if (commandLine == null) {
            CommandLineUtil.$$$reportNull$$$0(15);
        }
        if ((words = StringUtil.splitHonorQuotes(executable = commandLine.trim(), ' ')).isEmpty()) {
            execName = executable;
            args = Collections.emptyList();
        } else {
            execName = words.get(0);
            args = words.subList(1, words.size());
        }
        boolean verbose = Logger.getInstance(CommandLineUtil.class).isDebugEnabled();
        String string = verbose ? StringUtil.shortenPathWithEllipsis(execName + " " + StringUtil.join(args, " "), 250) : new File(StringUtil.unquoteString(execName)).getName();
        if (string == null) {
            CommandLineUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    public static boolean hasWinShellSpecialChars(@NotNull String parameter) {
        if (parameter == null) {
            CommandLineUtil.$$$reportNull$$$0(17);
        }
        return WIN_CARET_SPECIAL.matcher(parameter).find();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/CommandLineUtil";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/CommandLineUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "specialQuote";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toCommandLine";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getWinShellName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeParameterOnWindows";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "specialQuote";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toCommandLine";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "escapeParameterOnWindows";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "extractPresentableName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasWinShellSpecialChars";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class QuoteFlag {
        private boolean enabled;

        private QuoteFlag(boolean value) {
            this.enabled = value;
        }

        public void toggle() {
            this.enabled = !this.enabled;
        }

        public void update(CharSequence s, int start, int end) {
            this.enabled ^= StringUtil.countChars(s, '\"', start, end, false) % 2 != 0;
        }
    }
}

