/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.JarMemoryLoader;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.Resource;
import gnu.trove.TIntHashSet;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JarLoader
extends Loader {
    private static final List<Pair<Resource.Attribute, Attributes.Name>> PACKAGE_FIELDS = Arrays.asList(Pair.pair(Resource.Attribute.SPEC_TITLE, Attributes.Name.SPECIFICATION_TITLE), Pair.pair(Resource.Attribute.SPEC_VERSION, Attributes.Name.SPECIFICATION_VERSION), Pair.pair(Resource.Attribute.SPEC_VENDOR, Attributes.Name.SPECIFICATION_VENDOR), Pair.pair(Resource.Attribute.IMPL_TITLE, Attributes.Name.IMPLEMENTATION_TITLE), Pair.pair(Resource.Attribute.IMPL_VERSION, Attributes.Name.IMPLEMENTATION_VERSION), Pair.pair(Resource.Attribute.IMPL_VENDOR, Attributes.Name.IMPLEMENTATION_VENDOR));
    private final String myFilePath;
    private final ClassPath myConfiguration;
    private final URL myUrl;
    private SoftReference<JarMemoryLoader> myMemoryLoader;
    private volatile SoftReference<ZipFile> myZipFileSoftReference;
    private volatile Map<Resource.Attribute, String> myAttributes;
    private volatile String myClassPathManifestAttribute;
    private static final String NULL_STRING = "<null>";
    private final AtomicInteger myNumberOfRequests = new AtomicInteger();
    private volatile TIntHashSet myPackageHashesInside;
    private static final Object ourLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JarLoader(URL url, int index, ClassPath configuration) throws IOException {
        super(new URL("jar", "", -1, url + "!/"), index);
        this.myFilePath = JarLoader.urlToFilePath(url);
        this.myConfiguration = configuration;
        this.myUrl = url;
        if (!configuration.myLazyClassloadingCaches) {
            ZipFile zipFile = this.getZipFile();
            try {
                JarMemoryLoader loader;
                if (configuration.myPreloadJarContents && (loader = JarMemoryLoader.load(zipFile, this.getBaseURL(), this)) != null) {
                    this.myMemoryLoader = new SoftReference<JarMemoryLoader>(loader);
                }
            }
            finally {
                this.releaseZipFile(zipFile);
            }
        }
    }

    Map<Resource.Attribute, String> getAttributes() {
        this.loadManifestAttributes();
        return this.myAttributes;
    }

    @Nullable
    String getClassPathManifestAttribute() {
        this.loadManifestAttributes();
        String manifestAttribute = this.myClassPathManifestAttribute;
        return manifestAttribute != NULL_STRING ? manifestAttribute : null;
    }

    private static String urlToFilePath(URL url) {
        try {
            return new File(url.toURI()).getPath();
        }
        catch (Throwable ignore) {
            return url.getPath();
        }
    }

    @Nullable
    private static Map<Resource.Attribute, String> getAttributes(@Nullable Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        EnumMap<Resource.Attribute, String> map = null;
        for (Pair<Resource.Attribute, Attributes.Name> p : PACKAGE_FIELDS) {
            String value = attributes.getValue((Attributes.Name)p.second);
            if (value == null) continue;
            if (map == null) {
                map = new EnumMap<Resource.Attribute, String>(Resource.Attribute.class);
            }
            map.put((Resource.Attribute)((Object)p.first), value);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadManifestAttributes() {
        if (this.myClassPathManifestAttribute != null) {
            return;
        }
        JarLoader jarLoader = this;
        synchronized (jarLoader) {
            try {
                if (this.myClassPathManifestAttribute != null) {
                    return;
                }
                ZipFile zipFile = this.getZipFile();
                try {
                    Attributes manifestAttributes = this.myConfiguration.getManifestData(this.myUrl);
                    if (manifestAttributes == null) {
                        ZipEntry entry = zipFile.getEntry("META-INF/MANIFEST.MF");
                        manifestAttributes = JarLoader.loadManifestAttributes(entry != null ? zipFile.getInputStream(entry) : null);
                        if (manifestAttributes == null) {
                            manifestAttributes = new Attributes(0);
                        }
                        this.myConfiguration.cacheManifestData(this.myUrl, manifestAttributes);
                    }
                    this.myAttributes = JarLoader.getAttributes(manifestAttributes);
                    Object attribute = manifestAttributes.get(Attributes.Name.CLASS_PATH);
                    this.myClassPathManifestAttribute = attribute instanceof String ? (String)attribute : NULL_STRING;
                }
                finally {
                    this.releaseZipFile(zipFile);
                }
            }
            catch (IOException io) {
                throw new RuntimeException(io);
            }
        }
    }

    @Nullable
    private static Attributes loadManifestAttributes(@Nullable InputStream stream) {
        Attributes attributes;
        if (stream == null) {
            return null;
        }
        try {
            attributes = new Manifest(stream).getMainAttributes();
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (Exception exception) {
                return null;
            }
        }
        stream.close();
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ClasspathCache.LoaderData buildData() throws IOException {
        ZipFile zipFile = this.getZipFile();
        ClasspathCache.LoaderData loaderData = new ClasspathCache.LoaderData();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            loaderData.addResourceEntry(name);
            loaderData.addNameEntry(name);
        }
        ClasspathCache.LoaderData loaderData2 = loaderData;
        ClasspathCache.LoaderData loaderData3 = loaderData2;
        if (loaderData3 == null) {
            JarLoader.$$$reportNull$$$0(0);
        }
        return loaderData3;
        finally {
            this.releaseZipFile(zipFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TIntHashSet buildPackageHashes() {
        TIntHashSet tIntHashSet;
        ZipFile zipFile = this.getZipFile();
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            TIntHashSet result = new TIntHashSet();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                int ind = name.lastIndexOf(47);
                if (ind == -1) continue;
                int packageHash = StringUtil.stringHashCodeInsensitive(name, 0, ind);
                result.add(packageHash);
            }
            tIntHashSet = result;
        }
        catch (Throwable throwable) {
            try {
                this.releaseZipFile(zipFile);
                throw throwable;
            }
            catch (Exception e) {
                this.error("url: " + this.myFilePath, e);
                return new TIntHashSet(0);
            }
        }
        this.releaseZipFile(zipFile);
        return tIntHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    Resource getResource(String name) {
        Resource resource;
        JarMemoryLoader loader;
        if (this.myConfiguration.myLazyClassloadingCaches) {
            int packageHash;
            int ind;
            int numberOfHits = this.myNumberOfRequests.incrementAndGet();
            TIntHashSet packagesInside = this.myPackageHashesInside;
            if (numberOfHits > 1000 && packagesInside == null) {
                this.myPackageHashesInside = packagesInside = this.buildPackageHashes();
            }
            if (packagesInside != null && (ind = name.lastIndexOf(47)) != -1 && !packagesInside.contains(packageHash = StringUtil.stringHashCodeInsensitive(name, 0, ind))) {
                return null;
            }
        }
        JarMemoryLoader jarMemoryLoader = loader = this.myMemoryLoader != null ? (JarMemoryLoader)this.myMemoryLoader.get() : null;
        if (loader != null && (resource = loader.getResource(name)) != null) {
            return resource;
        }
        try {
            ZipFile zipFile = this.getZipFile();
            try {
                ZipEntry entry = zipFile.getEntry(name);
                if (entry == null) return null;
                MyResource myResource = new MyResource(this.getBaseURL(), entry);
                return myResource;
            }
            finally {
                this.releaseZipFile(zipFile);
            }
        }
        catch (Exception e) {
            this.error("url: " + this.myFilePath, e);
        }
        return null;
    }

    protected void error(String message, Throwable t) {
        if (this.myConfiguration.myLogErrorOnMissingJar) {
            Logger.getInstance(JarLoader.class).error(message, t);
        } else {
            Logger.getInstance(JarLoader.class).warn(message, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private ZipFile getZipFile() throws IOException {
        if (!this.myConfiguration.myCanLockJars) {
            ZipFile zipFile = new ZipFile(this.myFilePath);
            if (zipFile != null) return zipFile;
            JarLoader.$$$reportNull$$$0(4);
            return zipFile;
        }
        ZipFile zipFile = SoftReference.dereference(this.myZipFileSoftReference);
        if (zipFile != null) {
            ZipFile zipFile2 = zipFile;
            if (zipFile2 != null) return zipFile2;
            JarLoader.$$$reportNull$$$0(1);
            return zipFile2;
        }
        Object object = ourLock;
        // MONITORENTER : object
        zipFile = SoftReference.dereference(this.myZipFileSoftReference);
        if (zipFile != null) {
            ZipFile zipFile3 = zipFile;
            // MONITOREXIT : object
            if (zipFile3 != null) return zipFile3;
            JarLoader.$$$reportNull$$$0(2);
            return zipFile3;
        }
        zipFile = new ZipFile(this.myFilePath);
        this.myZipFileSoftReference = new SoftReference<ZipFile>(zipFile);
        ZipFile zipFile4 = zipFile;
        // MONITOREXIT : object
        if (zipFile4 != null) return zipFile4;
        JarLoader.$$$reportNull$$$0(3);
        return zipFile4;
    }

    private void releaseZipFile(ZipFile zipFile) throws IOException {
        if (!this.myConfiguration.myCanLockJars) {
            zipFile.close();
        }
    }

    public String toString() {
        return "JarLoader [" + this.myFilePath + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/lang/JarLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildData";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getZipFile";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class MyResource
    extends Resource {
        private final URL myUrl;
        private final ZipEntry myEntry;

        MyResource(URL url, ZipEntry entry) throws IOException {
            this.myUrl = new URL(url, entry.getName());
            this.myEntry = entry;
        }

        @Override
        public URL getURL() {
            return this.myUrl;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.getBytes());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getBytes() throws IOException {
            ZipFile file = JarLoader.this.getZipFile();
            InputStream stream = null;
            try {
                stream = file.getInputStream(this.myEntry);
                byte[] byArray = FileUtil.loadBytes(stream, (int)this.myEntry.getSize());
                return byArray;
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
                JarLoader.this.releaseZipFile(file);
            }
        }

        @Override
        public String getValue(Resource.Attribute key) {
            JarLoader.this.loadManifestAttributes();
            return JarLoader.this.myAttributes != null ? (String)JarLoader.this.myAttributes.get((Object)key) : null;
        }
    }
}

