/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvLexer {
    public static final int MAX_CHARACTERS = 0x500000;
    private CsvRecordFormat myCsvFormat;
    private long myCharacters;
    private long myLine;
    private long myLineCharacters;
    private TokenType myType;
    private long myStart;
    private long myEnd;
    private long myOffset;
    private long myTokenLine;
    private String myText;
    private State myState = State.RECORD_START;

    public void setCsvFormat(@NotNull CsvRecordFormat csvFormat) {
        if (csvFormat == null) {
            CsvLexer.$$$reportNull$$$0(0);
        }
        this.myCsvFormat = csvFormat;
    }

    public void advance(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            CsvLexer.$$$reportNull$$$0(1);
        }
        if (!CsvLexer.isReady(reader)) {
            this.setNullToken();
            return;
        }
        this.myState.nextToken(this, reader);
        while (CsvLexer.isReady(reader) && this.myType == null) {
            this.nextState();
            this.myState.nextToken(this, reader);
        }
        this.nextState();
    }

    public long getTokenLine() {
        return this.myTokenLine;
    }

    @Nullable
    public TokenType getType() {
        return this.myType;
    }

    public long getStart() {
        return this.myStart;
    }

    public long getEnd() {
        return this.myEnd;
    }

    public long getOffset() {
        return this.myOffset;
    }

    @Nullable
    public String getText() {
        return this.myText;
    }

    public boolean hasToken() {
        return this.myType != null;
    }

    public long getLine() {
        return this.myLine;
    }

    public long getCharacters() {
        return this.myCharacters;
    }

    public long getLineCharacters() {
        return this.myLineCharacters;
    }

    public void valueOrQuoted(@NotNull Reader reader) throws IOException {
        CsvRecordFormat.Quotes quotes;
        if (reader == null) {
            CsvLexer.$$$reportNull$$$0(2);
        }
        if ((quotes = this.findQuotes(this.myCsvFormat, reader)) == null) {
            this.value(reader, this.myCsvFormat);
            return;
        }
        this.quotedValue(quotes, this.myCsvFormat, reader);
    }

    protected void nextState() throws IOException {
        this.setState(this.myState.nextState(this.myType));
    }

    private void setState(@Nullable State state) {
        this.myState = state;
    }

    private void setToken(@Nullable TokenType type, @Nullable String text2, long start, long end, long line, long offset) {
        this.myType = type;
        this.myText = text2;
        this.myStart = start;
        this.myEnd = end;
        this.myTokenLine = line;
        this.myOffset = offset;
    }

    private void setNullToken() {
        this.setToken(null, null, -1L, -1L, -1L, -1L);
    }

    private void getSymbolToken(@NotNull Reader reader, @NotNull String symbol, @NotNull TokenType type) throws IOException {
        if (reader == null) {
            CsvLexer.$$$reportNull$$$0(3);
        }
        if (symbol == null) {
            CsvLexer.$$$reportNull$$$0(4);
        }
        if (type == null) {
            CsvLexer.$$$reportNull$$$0(5);
        }
        this.token((line, offset, l) -> {
            void character;
            if (symbol == null) {
                CsvLexer.$$$reportNull$$$0(49);
            }
            if (reader == null) {
                CsvLexer.$$$reportNull$$$0(50);
            }
            if (type == null) {
                CsvLexer.$$$reportNull$$$0(51);
            }
            if (StringUtil.isEmpty((String)symbol)) {
                this.setNullToken();
                return;
            }
            String prefix = CsvLexer.readAhead(reader, symbol.length());
            if (!StringUtil.equals((CharSequence)prefix, (CharSequence)symbol)) {
                this.setNullToken();
                return;
            }
            this.setToken(type, (String)ObjectUtils.assertNotNull((Object)this.read(reader, symbol.length())), (long)character, this.myCharacters, line, offset);
        }, reader);
    }

    @Nullable
    private CsvRecordFormat.Quotes findQuotes(@NotNull CsvRecordFormat format, @NotNull Reader reader) throws IOException {
        if (format == null) {
            CsvLexer.$$$reportNull$$$0(6);
        }
        if (reader == null) {
            CsvLexer.$$$reportNull$$$0(7);
        }
        for (CsvRecordFormat.Quotes quote : format.quotes) {
            String text2;
            if (quote.leftQuote.isEmpty() || quote.rightQuote.isEmpty() || !StringUtil.equals((CharSequence)(text2 = CsvLexer.readAhead(reader, quote.leftQuote.length())), (CharSequence)quote.leftQuote)) continue;
            this.read(reader, quote.leftQuote.length());
            return quote;
        }
        return null;
    }

    private void quotedValue(@NotNull CsvRecordFormat.Quotes quotes, @NotNull CsvRecordFormat format, @NotNull Reader reader) throws IOException {
        if (quotes == null) {
            CsvLexer.$$$reportNull$$$0(8);
        }
        if (format == null) {
            CsvLexer.$$$reportNull$$$0(9);
        }
        if (reader == null) {
            CsvLexer.$$$reportNull$$$0(10);
        }
        this.token((line, offset, l) -> {
            void character;
            if (quotes == null) {
                CsvLexer.$$$reportNull$$$0(46);
            }
            if (reader == null) {
                CsvLexer.$$$reportNull$$$0(47);
            }
            if (format == null) {
                CsvLexer.$$$reportNull$$$0(48);
            }
            StringBuilder sb = new StringBuilder();
            Pattern pattern = Pattern.compile(Pattern.quote(quotes.rightQuoteEscaped));
            boolean maxChars = false;
            while (CsvLexer.isReady(reader) && !CsvLexer.isEndWithQuote(sb, quotes, reader, pattern)) {
                String text2 = this.read(reader, 1);
                if (sb.length() < 0x500000) {
                    sb.append(text2);
                    continue;
                }
                maxChars = true;
                break;
            }
            if (maxChars) {
                this.readForQuote(quotes, sb, reader, pattern);
            }
            boolean quote = !maxChars && CsvLexer.isEndWithQuote(sb, quotes, reader, pattern);
            String text3 = quote ? sb.delete(Math.max(sb.length() - quotes.rightQuote.length(), 0), sb.length()).toString() : sb.toString();
            long end = quote ? this.myCharacters - (long)quotes.rightQuote.length() : this.myCharacters;
            String withQuotes = StringUtil.replace((String)text3, (String)quotes.rightQuoteEscaped, (String)quotes.rightQuote);
            this.trimAndSet(withQuotes, format, TokenType.QUOTED_VALUE, line, offset, (long)character, end);
        }, reader);
    }

    private void readForQuote(@NotNull CsvRecordFormat.Quotes quotes, @NotNull StringBuilder old, @NotNull Reader reader, @NotNull Pattern pattern) throws IOException {
        if (quotes == null) {
            CsvLexer.$$$reportNull$$$0(11);
        }
        if (old == null) {
            CsvLexer.$$$reportNull$$$0(12);
        }
        if (reader == null) {
            CsvLexer.$$$reportNull$$$0(13);
        }
        if (pattern == null) {
            CsvLexer.$$$reportNull$$$0(14);
        }
        String begin = CsvLexer.getStartString(quotes, old);
        StringBuilder sb = new StringBuilder(begin);
        while (CsvLexer.isReady(reader) && !CsvLexer.isEndWithQuote(sb, quotes, reader, pattern)) {
            sb.append(this.read(reader, 1));
            if (sb.length() < 0x500000) continue;
            String startStr = CsvLexer.getStartString(quotes, sb);
            sb = new StringBuilder(startStr);
        }
    }

    private void value(@NotNull Reader reader, @NotNull CsvRecordFormat format) throws IOException {
        if (reader == null) {
            CsvLexer.$$$reportNull$$$0(15);
        }
        if (format == null) {
            CsvLexer.$$$reportNull$$$0(16);
        }
        this.token((line, offset, l) -> {
            void character;
            if (reader == null) {
                CsvLexer.$$$reportNull$$$0(44);
            }
            if (format == null) {
                CsvLexer.$$$reportNull$$$0(45);
            }
            StringBuilder value = new StringBuilder();
            while (CsvLexer.isReady(reader)) {
                boolean isRecordSeparator = CsvLexer.lookAhead(reader, this.myCsvFormat.recordSeparator);
                boolean isValueSeparator = !isRecordSeparator && CsvLexer.lookAhead(reader, this.myCsvFormat.valueSeparator);
                boolean isSuffix = this.isSuffix(reader);
                if (isRecordSeparator || isValueSeparator || isSuffix) break;
                String text2 = this.read(reader);
                if (value.length() >= 0x500000) continue;
                value.append(text2);
            }
            this.trimAndSet(value.toString(), format, TokenType.VALUE, line, offset, (long)character, this.myCharacters);
        }, reader);
    }

    private void separator(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            CsvLexer.$$$reportNull$$$0(17);
        }
        this.token((line, offset, l) -> {
            void character;
            TokenType type;
            int count2;
            boolean isRecordSeparator;
            if (reader == null) {
                CsvLexer.$$$reportNull$$$0(43);
            }
            boolean isValueSeparator = !(isRecordSeparator = CsvLexer.lookAhead(reader, this.myCsvFormat.recordSeparator)) && CsvLexer.lookAhead(reader, this.myCsvFormat.valueSeparator);
            boolean isSuffix = this.isSuffix(reader);
            int n = isSuffix ? this.myCsvFormat.suffix.length() : (count2 = isRecordSeparator ? this.myCsvFormat.recordSeparator.length() : this.myCsvFormat.valueSeparator.length());
            TokenType tokenType = isSuffix ? TokenType.SUFFIX : (type = isRecordSeparator ? TokenType.RECORD_SEPARATOR : TokenType.VALUE_SEPARATOR);
            if (!(isRecordSeparator || isValueSeparator || isSuffix)) {
                this.setNullToken();
                return;
            }
            this.setToken(type, (String)ObjectUtils.assertNotNull((Object)this.read(reader, count2)), (long)character, this.myCharacters, line, offset);
        }, reader);
    }

    private void token(@NotNull MyComputable computable, @NotNull Reader reader) throws IOException {
        if (computable == null) {
            CsvLexer.$$$reportNull$$$0(18);
        }
        if (reader == null) {
            CsvLexer.$$$reportNull$$$0(19);
        }
        if (!CsvLexer.isReady(reader)) {
            this.setNullToken();
        }
        long character = this.myCharacters;
        long offset = this.myLineCharacters;
        long line = this.myLine;
        computable.compute(line, offset, character);
    }

    @Nullable
    private String read(@NotNull Reader reader, int count2) throws IOException {
        String read2;
        if (reader == null) {
            CsvLexer.$$$reportNull$$$0(20);
        }
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < count2 && (read2 = this.read(reader)) != null; ++i2) {
            sb.append(read2);
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    @Nullable
    private String read(@NotNull Reader reader) throws IOException {
        boolean isDoubleSeparator;
        char[] buffer;
        int symbols;
        if (reader == null) {
            CsvLexer.$$$reportNull$$$0(21);
        }
        if ((symbols = reader.read(buffer = new char[1])) == -1) {
            return null;
        }
        boolean bl = isDoubleSeparator = buffer[0] == '\n' && StringUtil.equals((CharSequence)CsvLexer.readAhead(reader, 1), (CharSequence)"\r") || buffer[0] == '\r' && StringUtil.equals((CharSequence)CsvLexer.readAhead(reader, 1), (CharSequence)"\n");
        if (isDoubleSeparator) {
            symbols = reader.read(buffer);
        }
        String result2 = StringUtil.convertLineSeparators((String)String.valueOf(buffer, 0, symbols));
        ++this.myCharacters;
        if (StringUtil.isLineBreak((char)buffer[0])) {
            this.myLineCharacters = 0L;
            ++this.myLine;
        } else {
            ++this.myLineCharacters;
        }
        return result2;
    }

    static boolean isReady(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            CsvLexer.$$$reportNull$$$0(22);
        }
        return CsvLexer.readAhead(reader, 1) != null;
    }

    @NotNull
    private static String getStartString(@NotNull CsvRecordFormat.Quotes quotes, @NotNull StringBuilder sb) {
        if (quotes == null) {
            CsvLexer.$$$reportNull$$$0(23);
        }
        if (sb == null) {
            CsvLexer.$$$reportNull$$$0(24);
        }
        int start = Math.max(0, sb.length() - Math.max(quotes.rightQuote.length(), quotes.rightQuoteEscaped.length()));
        String string = sb.substring(start, sb.length());
        if (string == null) {
            CsvLexer.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Nullable
    public static String readAhead(@NotNull Reader reader, int count2) throws IOException {
        if (reader == null) {
            CsvLexer.$$$reportNull$$$0(26);
        }
        char[] buffer = new char[count2];
        reader.mark(count2);
        int symbols = reader.read(buffer);
        if (symbols == -1) {
            return null;
        }
        String result2 = String.valueOf(buffer, 0, symbols);
        reader.reset();
        return StringUtil.convertLineSeparators((String)result2);
    }

    /*
     * WARNING - void declaration
     */
    private void trimAndSet(@NotNull String text2, @NotNull CsvRecordFormat format, @NotNull TokenType type, long line, long offset, long l, long l2) {
        if (text2 == null) {
            CsvLexer.$$$reportNull$$$0(27);
        }
        if (format == null) {
            CsvLexer.$$$reportNull$$$0(28);
        }
        if (type == null) {
            CsvLexer.$$$reportNull$$$0(29);
        }
        if (!format.trimWhitespace) {
            void end;
            void start;
            this.setToken(type, text2, (long)start, (long)end, line, offset);
            return;
        }
        String withoutLeading = StringUtil.trimLeading((String)text2);
        int diff = text2.length() - withoutLeading.length();
        String withoutTrailing = StringUtil.trimTrailing((String)withoutLeading);
        this.setToken(type, withoutTrailing, (long)(start += (long)diff), (long)(end -= (long)(withoutLeading.length() - withoutTrailing.length())), line, offset += (long)diff);
    }

    private boolean isSuffix(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            CsvLexer.$$$reportNull$$$0(30);
        }
        if (this.myCsvFormat.suffix.isEmpty()) {
            return false;
        }
        String suffix = this.myCsvFormat.suffix + this.myCsvFormat.recordSeparator;
        String s = CsvLexer.readAhead(reader, suffix.length());
        return s != null && StringUtil.startsWith((CharSequence)suffix, (CharSequence)s);
    }

    private static boolean lookAhead(@NotNull Reader reader, @NotNull String value) throws IOException {
        if (reader == null) {
            CsvLexer.$$$reportNull$$$0(31);
        }
        if (value == null) {
            CsvLexer.$$$reportNull$$$0(32);
        }
        if (value.length() == 0) {
            return false;
        }
        String read2 = CsvLexer.readAhead(reader, value.length());
        return StringUtil.equals((CharSequence)read2, (CharSequence)value);
    }

    private static boolean isEndWithQuote(@NotNull StringBuilder sb, @NotNull CsvRecordFormat.Quotes quotes, @NotNull Reader reader, @NotNull Pattern pattern) throws IOException {
        if (sb == null) {
            CsvLexer.$$$reportNull$$$0(33);
        }
        if (quotes == null) {
            CsvLexer.$$$reportNull$$$0(34);
        }
        if (reader == null) {
            CsvLexer.$$$reportNull$$$0(35);
        }
        if (pattern == null) {
            CsvLexer.$$$reportNull$$$0(36);
        }
        if (!StringUtil.endsWith((CharSequence)sb, (CharSequence)quotes.rightQuote)) {
            return false;
        }
        if (quotes.rightQuote.length() >= quotes.rightQuoteEscaped.length()) {
            return true;
        }
        if (StringUtil.endsWith((CharSequence)sb, (CharSequence)quotes.rightQuoteEscaped)) {
            return CsvLexer.isNotEscapedQuote(sb, quotes, reader, pattern);
        }
        String read2 = sb + StringUtil.notNullize((String)CsvLexer.readAhead(reader, quotes.rightQuoteEscaped.length() - quotes.rightQuote.length()));
        return !StringUtil.endsWith((CharSequence)read2, (CharSequence)quotes.rightQuoteEscaped);
    }

    private static boolean isNotEscapedQuote(@NotNull StringBuilder sb, @NotNull CsvRecordFormat.Quotes quotes, @NotNull Reader reader, @NotNull Pattern pattern) throws IOException {
        if (sb == null) {
            CsvLexer.$$$reportNull$$$0(37);
        }
        if (quotes == null) {
            CsvLexer.$$$reportNull$$$0(38);
        }
        if (reader == null) {
            CsvLexer.$$$reportNull$$$0(39);
        }
        if (pattern == null) {
            CsvLexer.$$$reportNull$$$0(40);
        }
        Matcher matcher = pattern.matcher(sb);
        int end = -1;
        while (matcher.find()) {
            end = matcher.end();
        }
        if (end == -1) {
            return true;
        }
        int length = quotes.rightQuoteEscaped.length();
        int symbolsToRead = (length - sb.length() + end) % length;
        String text2 = sb + StringUtil.notNullize((String)CsvLexer.readAhead(reader, symbolsToRead));
        return symbolsToRead != 0 && !CsvLexer.isReady(reader) || !StringUtil.endsWith((CharSequence)text2, (CharSequence)quotes.rightQuoteEscaped);
    }

    @NotNull
    private static String getElementText(@NotNull IElementType type) {
        if (type == null) {
            CsvLexer.$$$reportNull$$$0(41);
        }
        String s = StringUtil.toLowerCase((String)type.toString());
        String string = StringUtil.join((String[])s.split("_"), (String)" ");
        if (string == null) {
            CsvLexer.$$$reportNull$$$0(42);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 25: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 25: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "csvFormat";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 30: 
            case 31: 
            case 35: 
            case 39: 
            case 43: 
            case 44: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 4: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 5: 
            case 29: 
            case 41: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 9: 
            case 16: 
            case 28: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 8: 
            case 11: 
            case 23: 
            case 34: 
            case 38: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "old";
                break;
            }
            case 14: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 24: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 25: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/CsvLexer";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/CsvLexer";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartString";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setCsvFormat";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "advance";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "valueOrQuoted";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolToken";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findQuotes";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "quotedValue";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readForQuote";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "value";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "separator";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "token";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isReady";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getStartString";
                break;
            }
            case 25: 
            case 42: {
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "readAhead";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "trimAndSet";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isSuffix";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lookAhead";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isEndWithQuote";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isNotEscapedQuote";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getElementText";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$separator$3";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$value$2";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$quotedValue$1";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSymbolToken$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 25: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum State {
        RECORD_START{

            @Override
            void nextToken(@NotNull CsvLexer lexer, @NotNull Reader reader) throws IOException {
                if (lexer == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (reader == null) {
                    1.$$$reportNull$$$0(1);
                }
                lexer.getSymbolToken(reader, ((CsvLexer)lexer).myCsvFormat.prefix, TokenType.PREFIX);
            }

            @Override
            @NotNull
            State nextState(@Nullable TokenType type) throws IOException {
                State state = VALUE_START;
                if (state == null) {
                    1.$$$reportNull$$$0(2);
                }
                return state;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lexer";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reader";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/datagrid/CsvLexer$State$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/datagrid/CsvLexer$State$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "nextState";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "nextToken";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
        ,
        RECORD_END{

            @Override
            void nextToken(@NotNull CsvLexer lexer, @NotNull Reader reader) throws IOException {
                if (lexer == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (reader == null) {
                    2.$$$reportNull$$$0(1);
                }
                lexer.getSymbolToken(reader, ((CsvLexer)lexer).myCsvFormat.suffix, TokenType.SUFFIX);
            }

            @Override
            @NotNull
            State nextState(@Nullable TokenType type) throws IOException {
                State state = type == null || type == TokenType.RECORD_SEPARATOR ? VALUE_START : VALUE_END;
                if (state == null) {
                    2.$$$reportNull$$$0(2);
                }
                return state;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lexer";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reader";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/datagrid/CsvLexer$State$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/datagrid/CsvLexer$State$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "nextState";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "nextToken";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
        ,
        VALUE_START{

            @Override
            void nextToken(@NotNull CsvLexer lexer, @NotNull Reader reader) throws IOException {
                if (lexer == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (reader == null) {
                    3.$$$reportNull$$$0(1);
                }
                lexer.valueOrQuoted(reader);
            }

            @Override
            @NotNull
            State nextState(@Nullable TokenType type) throws IOException {
                State state = VALUE_END;
                if (state == null) {
                    3.$$$reportNull$$$0(2);
                }
                return state;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lexer";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reader";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/datagrid/CsvLexer$State$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/datagrid/CsvLexer$State$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "nextState";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "nextToken";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
        ,
        VALUE_END{

            @Override
            void nextToken(@NotNull CsvLexer lexer, @NotNull Reader reader) throws IOException {
                if (lexer == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (reader == null) {
                    4.$$$reportNull$$$0(1);
                }
                lexer.separator(reader);
            }

            @Override
            @NotNull
            State nextState(@Nullable TokenType type) throws IOException {
                State state = type == null ? RECORD_END : (type == TokenType.SUFFIX ? VALUE_END : (type == TokenType.RECORD_SEPARATOR ? RECORD_START : VALUE_START));
                if (state == null) {
                    4.$$$reportNull$$$0(2);
                }
                return state;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lexer";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reader";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/datagrid/CsvLexer$State$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/datagrid/CsvLexer$State$4";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "nextState";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "nextToken";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };


        abstract void nextToken(@NotNull CsvLexer var1, @NotNull Reader var2) throws IOException;

        @NotNull
        abstract State nextState(@Nullable TokenType var1) throws IOException;
    }

    public static class TokenType {
        private static final IElementType RECORD_SEPARATOR_TYPE = new IElementType("RECORD_SEPARATOR", null);
        private static final IElementType VALUE_SEPARATOR_TYPE = new IElementType("VALUE_SEPARATOR", null);
        private static final IElementType VALUE_TYPE = new IElementType("VALUE", null);
        private static final IElementType QUOTED_VALUE_TYPE = new IElementType("QUOTED_VALUE", null);
        private static final IElementType SUFFIX_TYPE = new IElementType("SUFFIX", null);
        private static final IElementType PREFIX_TYPE = new IElementType("PREFIX", null);
        public static final TokenType RECORD_SEPARATOR = new TokenType(RECORD_SEPARATOR_TYPE){

            @Override
            @NotNull
            public String getDebugName(@NotNull CsvRecordFormat format) {
                if (format == null) {
                    1.$$$reportNull$$$0(0);
                }
                String string = super.getDebugName(format) + " (" + format.recordSeparator + ")";
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @NotNull
            String getTokenRepresentation(@NotNull String text2) {
                if (text2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                String string = this.myName + " " + super.getTokenRepresentation(text2);
                if (string == null) {
                    1.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "format";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/datagrid/CsvLexer$TokenType$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/datagrid/CsvLexer$TokenType$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDebugName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTokenRepresentation";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getDebugName";
                        break;
                    }
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getTokenRepresentation";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        public static final TokenType VALUE_SEPARATOR = new TokenType(VALUE_SEPARATOR_TYPE){

            @Override
            @NotNull
            public String getDebugName(@NotNull CsvRecordFormat format) {
                if (format == null) {
                    2.$$$reportNull$$$0(0);
                }
                String string = super.getDebugName(format) + " (" + format.valueSeparator + ")";
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @NotNull
            String getTokenRepresentation(@NotNull String text2) {
                if (text2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                String string = this.myName + " " + super.getTokenRepresentation(text2);
                if (string == null) {
                    2.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "format";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/datagrid/CsvLexer$TokenType$2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/datagrid/CsvLexer$TokenType$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDebugName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTokenRepresentation";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getDebugName";
                        break;
                    }
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getTokenRepresentation";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        public static final TokenType VALUE = new TokenType(VALUE_TYPE){

            @Override
            @NotNull
            protected String wrap(@NotNull String s) {
                if (s == null) {
                    3.$$$reportNull$$$0(0);
                }
                String string = "\"" + s + "\"";
                if (string == null) {
                    3.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "s";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/datagrid/CsvLexer$TokenType$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/datagrid/CsvLexer$TokenType$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "wrap";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "wrap";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        public static final TokenType QUOTED_VALUE = new TokenType(QUOTED_VALUE_TYPE){

            @Override
            @NotNull
            public String getDebugName(@NotNull CsvRecordFormat format) {
                if (format == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ("value" == null) {
                    4.$$$reportNull$$$0(1);
                }
                return "value";
            }

            @Override
            @NotNull
            protected String wrap(@NotNull String s) {
                if (s == null) {
                    4.$$$reportNull$$$0(2);
                }
                String string = s;
                if (string == null) {
                    4.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "format";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/datagrid/CsvLexer$TokenType$4";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "s";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/datagrid/CsvLexer$TokenType$4";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDebugName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "wrap";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getDebugName";
                        break;
                    }
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "wrap";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        public static final TokenType PREFIX = new TokenType(PREFIX_TYPE){

            @Override
            @NotNull
            public String getDebugName(@NotNull CsvRecordFormat format) {
                if (format == null) {
                    5.$$$reportNull$$$0(0);
                }
                String string = super.getDebugName(format) + " (" + format.prefix + ")";
                if (string == null) {
                    5.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @NotNull
            String getTokenRepresentation(@NotNull String text2) {
                if (text2 == null) {
                    5.$$$reportNull$$$0(2);
                }
                String string = this.myName + " " + super.getTokenRepresentation(text2);
                if (string == null) {
                    5.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "format";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/datagrid/CsvLexer$TokenType$5";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/datagrid/CsvLexer$TokenType$5";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDebugName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTokenRepresentation";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getDebugName";
                        break;
                    }
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getTokenRepresentation";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        public static final TokenType SUFFIX = new TokenType(SUFFIX_TYPE){

            @Override
            @NotNull
            public String getDebugName(@NotNull CsvRecordFormat format) {
                if (format == null) {
                    6.$$$reportNull$$$0(0);
                }
                String string = super.getDebugName(format) + " (" + format.suffix + ")";
                if (string == null) {
                    6.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @NotNull
            String getTokenRepresentation(@NotNull String text2) {
                if (text2 == null) {
                    6.$$$reportNull$$$0(2);
                }
                String string = this.myName + " " + super.getTokenRepresentation(text2);
                if (string == null) {
                    6.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "format";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/datagrid/CsvLexer$TokenType$6";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/datagrid/CsvLexer$TokenType$6";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDebugName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTokenRepresentation";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getDebugName";
                        break;
                    }
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getTokenRepresentation";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        protected final String myName;
        private final IElementType myElementType;

        private TokenType(@NotNull IElementType type) {
            if (type == null) {
                TokenType.$$$reportNull$$$0(0);
            }
            this.myElementType = type;
            this.myName = CsvLexer.getElementText(type);
        }

        @NotNull
        public String getDebugName(@NotNull CsvRecordFormat format) {
            if (format == null) {
                TokenType.$$$reportNull$$$0(1);
            }
            String string = this.myName;
            if (string == null) {
                TokenType.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        String getTokenRepresentation(@NotNull String text2) {
            if (text2 == null) {
                TokenType.$$$reportNull$$$0(3);
            }
            String string = this.wrap(StringUtil.escapeStringCharacters((String)text2));
            if (string == null) {
                TokenType.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        protected String wrap(@NotNull String s) {
            if (s == null) {
                TokenType.$$$reportNull$$$0(5);
            }
            String string = "(" + s + ")";
            if (string == null) {
                TokenType.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public IElementType getElementType() {
            IElementType iElementType = this.myElementType;
            if (iElementType == null) {
                TokenType.$$$reportNull$$$0(7);
            }
            return iElementType;
        }

        public String toString() {
            return this.myElementType.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/CsvLexer$TokenType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/CsvLexer$TokenType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDebugName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTokenRepresentation";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "wrap";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getDebugName";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getTokenRepresentation";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "wrap";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface MyComputable {
        public void compute(long var1, long var3, long var5) throws IOException;
    }
}

