/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dialects.oracle.model.OraArgument;
import com.intellij.database.dialects.oracle.model.OraMajorObject;
import com.intellij.database.dialects.oracle.model.OraRoutine;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraSourceAware;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SourceError;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraSingleRoutine
extends OraRoutine,
OraMajorObject,
OraSourceAware {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.ROUTINE;
        if (objectKind == null) {
            OraSingleRoutine.$$$reportNull$$$0(0);
        }
        return objectKind;
    }

    @Override
    @Nullable
    public OraSchema getSchema();

    @Override
    @Nullable
    default public OraSchema getParent() {
        return this.getSchema();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends OraSingleRoutine> getParentFamily() {
        return null;
    }

    @Override
    @NotNull
    public @NotNull PositioningNamingFamily<@NotNull ? extends OraArgument> getArguments();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.singletonList(ObjectKind.ARGUMENT);
        if (list == null) {
            OraSingleRoutine.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<Iterable> list = Collections.singletonList(this.getArguments());
        if (list == null) {
            OraSingleRoutine.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @NotNull
    default public DasRoutine.Kind getRoutineKind() {
        DasRoutine.Kind kind = DasRoutine.Kind.NONE;
        if (kind == null) {
            OraSingleRoutine.$$$reportNull$$$0(3);
        }
        return kind;
    }

    @Override
    default public boolean isDeterministic() {
        return false;
    }

    @Override
    default public int getSourceTextLength() {
        return 0;
    }

    @Override
    @NotNull
    default public List<SourceError> getErrors() {
        List<SourceError> list = Collections.emptyList();
        if (list == null) {
            OraSingleRoutine.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    default public boolean isInvalid() {
        return false;
    }

    @Override
    default public boolean isObfuscated() {
        return false;
    }

    @Override
    @NotNull
    default public Set<Long> getDependsOnIds() {
        Set<Long> set = Collections.emptySet();
        if (set == null) {
            OraSingleRoutine.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Override
    @Nullable
    default public Date getCreatedTimestamp() {
        return null;
    }

    @Override
    @Nullable
    default public Date getModifiedTimestamp() {
        return null;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer2) {
        Date modifiedTimestamp;
        Date createdTimestamp;
        Set<Long> dependsOnIds;
        boolean obfuscated;
        boolean invalid;
        int sourceTextLength;
        boolean deterministic;
        DasRoutine.Kind routineKind;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        long objectId;
        if (consumer2 == null) {
            OraSingleRoutine.$$$reportNull$$$0(6);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer2.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer2.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer2.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer2.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer2.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer2.accept("Comment", PropertyConverter.export(comment));
        }
        if ((routineKind = this.getRoutineKind()) != null && routineKind != DasRoutine.Kind.NONE) {
            consumer2.accept("RoutineKind", PropertyConverter.export((Enum)routineKind));
        }
        if (deterministic = this.isDeterministic()) {
            consumer2.accept("Deterministic", PropertyConverter.export(deterministic));
        }
        if ((sourceTextLength = this.getSourceTextLength()) != 0) {
            consumer2.accept("SourceTextLength", PropertyConverter.export(sourceTextLength));
        }
        if (invalid = this.isInvalid()) {
            consumer2.accept("Invalid", PropertyConverter.export(invalid));
        }
        if (obfuscated = this.isObfuscated()) {
            consumer2.accept("Obfuscated", PropertyConverter.export(obfuscated));
        }
        if (!(dependsOnIds = this.getDependsOnIds()).isEmpty()) {
            consumer2.accept("DependsOnIds", PropertyConverter.exportSetOfLong(dependsOnIds));
        }
        if ((createdTimestamp = this.getCreatedTimestamp()) != null) {
            consumer2.accept("CreatedTimestamp", PropertyConverter.export(createdTimestamp));
        }
        if ((modifiedTimestamp = this.getModifiedTimestamp()) != null) {
            consumer2.accept("ModifiedTimestamp", PropertyConverter.export(modifiedTimestamp));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "RoutineKind", "Deterministic", "SourceTextLength", "Errors", "Invalid", "Obfuscated", "DependsOnIds", "CreatedTimestamp", "ModifiedTimestamp");
        if (list == null) {
            OraSingleRoutine.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/model/OraSingleRoutine";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoutineKind";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependsOnIds";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/model/OraSingleRoutine";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

