/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.validation;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.psi.Axis;
import org.intellij.lang.xpath.psi.XPathAxisSpecifier;
import org.intellij.lang.xpath.psi.XPathBinaryExpression;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathFilterExpression;
import org.intellij.lang.xpath.psi.XPathFunctionCall;
import org.intellij.lang.xpath.psi.XPathLocationPath;
import org.intellij.lang.xpath.psi.XPathNumber;
import org.intellij.lang.xpath.psi.XPathStep;
import org.intellij.lang.xpath.psi.XPathString;
import org.intellij.lang.xpath.psi.XPathVariableReference;
import org.intellij.lang.xpath.xslt.context.Xslt2ContextProvider;

class XsltPatternValidator {
    private XsltPatternValidator() {
    }

    public static void validate(AnnotationHolder annotationHolder, PsiFile file) {
        XPathExpression expression = ((XPathFile)file).getExpression();
        if (expression != null) {
            if (!XsltPatternValidator.checkPattern(expression)) {
                annotationHolder.createErrorAnnotation((PsiElement)expression, "Bad pattern");
            }
        } else {
            annotationHolder.createErrorAnnotation(TextRange.from((int)0, (int)1), "Missing pattern");
        }
    }

    private static boolean checkPattern(XPathExpression element) {
        if (element instanceof XPathBinaryExpression) {
            XPathBinaryExpression expression = (XPathBinaryExpression)element;
            if (expression.getOperator() == XPathTokenTypes.UNION && XsltPatternValidator.checkPattern(expression.getLOperand()) && XsltPatternValidator.checkPattern(expression.getROperand())) {
                return true;
            }
        } else {
            if (element instanceof XPathLocationPath) {
                return XsltPatternValidator.checkLocationPathPattern((XPathLocationPath)element);
            }
            if (element instanceof XPathFunctionCall) {
                return XsltPatternValidator.checkIdKeyPattern(element);
            }
        }
        return false;
    }

    private static boolean checkLocationPathPattern(XPathLocationPath locationPath) {
        XPathStep step = locationPath.getFirstStep();
        return step == null || XsltPatternValidator.checkStep(step);
    }

    private static boolean checkStep(XPathStep step) {
        XPathExpression prev = step.getPreviousStep();
        if (prev instanceof XPathFilterExpression && (prev = ((XPathFilterExpression)prev).getExpression()) != null && !(prev instanceof XPathStep)) {
            return false;
        }
        if (prev instanceof XPathStep ? !XsltPatternValidator.checkStep((XPathStep)prev) : (prev instanceof XPathFunctionCall ? !XsltPatternValidator.checkIdKeyPattern(prev) : step.getStep() != null || prev != null)) {
            return false;
        }
        XPathAxisSpecifier axisSpecifier = step.getAxisSpecifier();
        if (axisSpecifier != null) {
            return axisSpecifier.getAxis() == Axis.CHILD || axisSpecifier.getAxis() == Axis.ATTRIBUTE;
        }
        return true;
    }

    private static boolean checkIdKeyPattern(PsiElement child) {
        if (child instanceof XPathFunctionCall) {
            XPathFunctionCall call = (XPathFunctionCall)child;
            XPathExpression[] arguments = call.getArgumentList();
            if ("id".equals(call.getFunctionName())) {
                if (arguments.length != 1) {
                    return false;
                }
                return XsltPatternValidator.isIdValue(arguments[0]);
            }
            if ("key".equals(call.getFunctionName())) {
                if (arguments.length != 2) {
                    return false;
                }
                return arguments[0] instanceof XPathString && XsltPatternValidator.isKeyValue(arguments[1]);
            }
        }
        return false;
    }

    private static boolean isIdValue(XPathExpression argument) {
        if (argument.getXPathContext() instanceof Xslt2ContextProvider) {
            return argument instanceof XPathString || argument instanceof XPathVariableReference;
        }
        return argument instanceof XPathString;
    }

    private static boolean isKeyValue(XPathExpression argument) {
        if (argument.getXPathContext() instanceof Xslt2ContextProvider) {
            return argument instanceof XPathString || argument instanceof XPathNumber || argument instanceof XPathVariableReference;
        }
        return argument instanceof XPathString;
    }
}

