/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ide;

import com.intellij.openapi.editor.Document;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KillRingTransferable
implements Transferable {
    private static final DataFlavor[] DATA_FLAVORS = new DataFlavor[]{DataFlavor.stringFlavor};
    private final String myData;
    private final WeakReference<Document> myDocument;
    private final int myStartOffset;
    private final int myEndOffset;
    private final boolean myCut;
    private volatile boolean myReadyToCombine;

    public KillRingTransferable(@NotNull String data, @NotNull Document document, int startOffset, int endOffset, boolean cut) {
        if (data == null) {
            KillRingTransferable.$$$reportNull$$$0(0);
        }
        if (document == null) {
            KillRingTransferable.$$$reportNull$$$0(1);
        }
        this.myReadyToCombine = true;
        this.myData = data;
        this.myDocument = new WeakReference<Document>(document);
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myCut = cut;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return DATA_FLAVORS;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor == DataFlavor.stringFlavor;
    }

    @Override
    @Nullable
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        return this.isDataFlavorSupported(flavor) ? this.myData : null;
    }

    @Nullable
    public Document getDocument() {
        return (Document)this.myDocument.get();
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    public boolean isCut() {
        return this.myCut;
    }

    public boolean isReadyToCombine() {
        return this.myReadyToCombine;
    }

    public void setReadyToCombine(boolean readyToCombine) {
        this.myReadyToCombine = readyToCombine;
    }

    public String toString() {
        return "data='" + this.myData + "', startOffset=" + this.myStartOffset + ", endOffset=" + this.myEndOffset + ", cut=" + this.myCut;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "data";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "document";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/ide/KillRingTransferable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

