/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntNonSharedSettings;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.SemVer;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntUtil {
    public static final String DEFAULT_TASK_NAME = "default";
    private static final String GRUNT_PKG = "grunt";
    public static final NodePackageDescriptor GRUNT = new NodePackageDescriptor("grunt-cli", "grunt");
    private static final String STORAGE_GRUNT_CLI_PACKAGE_DIR_PATH = "js.buildTools.grunt.grunt-cli.package";

    public static void checkConfiguration(@NotNull Project project, @NotNull GruntNonSharedSettings nonSharedSettings, @NotNull GruntRunSettings settings) throws RuntimeConfigurationError {
        if (project == null) {
            GruntUtil.$$$reportNull$$$0(0);
        }
        if (nonSharedSettings == null) {
            GruntUtil.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            GruntUtil.$$$reportNull$$$0(2);
        }
        GruntUtil.validateFile(settings.getGruntfilePath(), "Unspecified Gruntfile", "Gruntfile not found", null);
        NodeInterpreterUtil.checkForRunConfiguration(settings.getInterpreterRef().resolve(project));
        nonSharedSettings.getGruntCliPackage().validateForRunConfiguration(GRUNT.getPackageNames().get(0));
    }

    private static void validateFile(@NotNull String filePath, @NotNull String emptyPathMessage, @NotNull String fileNotFoundMessage, @Nullable String canNotExecuteFileMessage) throws RuntimeConfigurationError {
        if (filePath == null) {
            GruntUtil.$$$reportNull$$$0(3);
        }
        if (emptyPathMessage == null) {
            GruntUtil.$$$reportNull$$$0(4);
        }
        if (fileNotFoundMessage == null) {
            GruntUtil.$$$reportNull$$$0(5);
        }
        if (filePath.trim().isEmpty()) {
            throw new RuntimeConfigurationError(emptyPathMessage);
        }
        File file2 = new File(filePath);
        if (!file2.isAbsolute() || !file2.isFile()) {
            throw new RuntimeConfigurationError(fileNotFoundMessage);
        }
        if (canNotExecuteFileMessage != null && !file2.canExecute()) {
            throw new RuntimeConfigurationError(canNotExecuteFileMessage);
        }
    }

    @NotNull
    public static String getBaseTaskName(@NotNull String fullTaskName) {
        int ind;
        if (fullTaskName == null) {
            GruntUtil.$$$reportNull$$$0(6);
        }
        if ((ind = fullTaskName.indexOf(58)) == -1) {
            String string = fullTaskName;
            if (string == null) {
                GruntUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = fullTaskName.substring(0, ind);
        if (string == null) {
            GruntUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static GruntNonSharedSettings getGruntPackage(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextGruntfile) {
        String packageDir;
        if (project == null) {
            GruntUtil.$$$reportNull$$$0(9);
        }
        if (StringUtil.isEmpty((String)(packageDir = PropertiesComponent.getInstance((Project)project).getValue(STORAGE_GRUNT_CLI_PACKAGE_DIR_PATH)))) {
            SemVer version;
            NodePackage pkg = GRUNT.findFirstDirectDependencyPackage(project, interpreter, contextGruntfile);
            if (GRUNT_PKG.equals(pkg.getName()) && (version = pkg.getVersion()) != null && !version.isGreaterOrEqualThan(1, 0, 0)) {
                pkg = new NodePackage("");
            }
            if (!pkg.isEmptyPath()) {
                GruntUtil.setGruntPackage(project, pkg);
                GruntNonSharedSettings gruntNonSharedSettings = new GruntNonSharedSettings(pkg);
                if (gruntNonSharedSettings == null) {
                    GruntUtil.$$$reportNull$$$0(10);
                }
                return gruntNonSharedSettings;
            }
        }
        GruntNonSharedSettings gruntNonSharedSettings = new GruntNonSharedSettings(new NodePackage(StringUtil.notNullize((String)packageDir)));
        if (gruntNonSharedSettings == null) {
            GruntUtil.$$$reportNull$$$0(11);
        }
        return gruntNonSharedSettings;
    }

    public static void setGruntPackage(@NotNull Project project, @NotNull NodePackage gruntPackage) {
        if (project == null) {
            GruntUtil.$$$reportNull$$$0(12);
        }
        if (gruntPackage == null) {
            GruntUtil.$$$reportNull$$$0(13);
        }
        PropertiesComponent.getInstance((Project)project).setValue(STORAGE_GRUNT_CLI_PACKAGE_DIR_PATH, gruntPackage.getSystemIndependentPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonSharedSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyPathMessage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNotFoundMessage";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullTaskName";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/grunt/GruntUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gruntPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/grunt/GruntUtil";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseTaskName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getGruntPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkConfiguration";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBaseTaskName";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getGruntPackage";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setGruntPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

