/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterEditorNotificationPanel;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.JSLinterWithInspectionExternalAnnotator;
import com.intellij.lang.javascript.linter.UntypedJSLinterConfigurable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.Function;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterAnnotationsBuilder<T extends JSLinterState> {
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final JSLinterAnnotationResult<T> myResult;
    @NotNull
    private final AnnotationHolder myHolder;
    @NotNull
    private final HighlightDisplayKey myKey;
    @NotNull
    private final UntypedJSLinterConfigurable myConfigurable;
    @NotNull
    private final String myPrefix;
    private int myTabSize;
    @NotNull
    private JSLinterWithInspectionExternalAnnotator.HighlightingGranularity myHighlightingGranularity;
    @NotNull
    private final Class<? extends JSLinterInspection> myInspectionClass;
    @NotNull
    private final JSLinterStandardFixes myStandardFixes;

    public JSLinterAnnotationsBuilder(@NotNull PsiFile file2, @NotNull JSLinterAnnotationResult<T> annotationResult, @NotNull AnnotationHolder holder, @NotNull UntypedJSLinterConfigurable configurable, @NotNull String errorPrefix, @NotNull Class<? extends JSLinterInspection> inspectionClass, @NotNull JSLinterStandardFixes fixes) {
        if (file2 == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(0);
        }
        if (annotationResult == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(2);
        }
        if (configurable == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(3);
        }
        if (errorPrefix == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(4);
        }
        if (inspectionClass == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(5);
        }
        if (fixes == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(6);
        }
        this.myTabSize = 1;
        this.myFile = file2;
        this.myResult = annotationResult;
        this.myHolder = holder;
        this.myKey = JSLinterInspection.getHighlightDisplayKeyByClass(inspectionClass);
        this.myConfigurable = configurable;
        this.myPrefix = errorPrefix;
        this.myInspectionClass = inspectionClass;
        this.myStandardFixes = fixes;
        this.myHighlightingGranularity = JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.none;
    }

    @NotNull
    public JSLinterAnnotationsBuilder<T> setTabSize(int tabSize) {
        this.myTabSize = tabSize;
        JSLinterAnnotationsBuilder jSLinterAnnotationsBuilder = this;
        if (jSLinterAnnotationsBuilder == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(7);
        }
        return jSLinterAnnotationsBuilder;
    }

    public void apply() {
        Annotation annotation;
        Document document = PsiDocumentManager.getInstance((Project)this.myFile.getProject()).getDocument(this.myFile);
        if (document == null) {
            return;
        }
        InspectionProjectProfileManager inspectionProjectProfileManager = InspectionProjectProfileManager.getInstance((Project)this.myFile.getProject());
        SeverityRegistrar severityRegistrar = inspectionProjectProfileManager.getSeverityRegistrar();
        EditorColorsScheme colorsScheme = this.myResult.getInput().getColorsScheme();
        Function severityTextAttributesProvider = severity -> JSLinterUtil.getTextAttributes(colorsScheme, severityRegistrar, severity);
        List<JSLinterError> limitedErrors = JSLinterUtil.limitErrorsAtTheSamePosition(this.myResult.getErrors(), 10);
        if (this.myHolder.isBatchMode()) {
            JSLinterFileLevelAnnotation fileLevelError;
            JSLinterError globalLinterError;
            if (this.myResult.hasFileLevelInfo() && (annotation = this.createAnnotation(document, globalLinterError = new JSLinterError(1, 1, (fileLevelError = this.myResult.getFileLevelError()).getMessage(), null, fileLevelError.getSeverity()), (Function<HighlightSeverity, TextAttributes>)severityTextAttributesProvider)) != null) {
                fileLevelError.getFixes().createListForError(this.myResult.getConfigFile(), this.myConfigurable, globalLinterError).forEach(error -> annotation.registerFix(error));
            }
        } else {
            this.createFileLevelAnnotations();
        }
        for (JSLinterError linterError : limitedErrors) {
            ProblemGroup problemGroup;
            annotation = this.createAnnotation(document, linterError, (Function<HighlightSeverity, TextAttributes>)severityTextAttributesProvider);
            if (annotation == null) continue;
            Function<JSLinterErrorBase, ProblemGroup> getProblemGroup = this.myStandardFixes.getProblemGroup();
            ProblemGroup problemGroup2 = problemGroup = getProblemGroup != null ? (ProblemGroup)getProblemGroup.fun((Object)linterError) : null;
            if (problemGroup != null) {
                annotation.setProblemGroup(problemGroup);
            }
            List<IntentionAction> list = this.myStandardFixes.createListForError(this.myResult.getConfigFile(), this.myConfigurable, linterError);
            list.forEach(action -> annotation.registerFix(action, null, this.myKey));
        }
    }

    private void createFileLevelAnnotations() {
        JSLinterFileLevelAnnotation error = this.myResult.getFileLevelError();
        if (error != null) {
            error.prefix(this.myPrefix);
            JSLinterStandardFixes fixes = new JSLinterStandardFixes().setShowEditSettings(false).setOtherFixes(error.getFixes().createList(this.myResult.getConfigFile(), this.myConfigurable)).setEditConfig(false);
            JSLinterFileLevelAnnotation copy = new JSLinterFileLevelAnnotation(error.getIcon(), error.getMessage(), error.getSeverity(), fixes);
            if (error.getShortMessage() != null) {
                copy.setShortMessage(error.getShortMessage());
            }
            JSLinterEditorNotificationPanel.setNotification(this.myFile.getProject(), this.myInspectionClass, this.myFile.getVirtualFile(), copy);
        } else {
            JSLinterEditorNotificationPanel.clearNotification(this.myFile.getProject(), this.myInspectionClass, this.myFile.getVirtualFile());
        }
    }

    @Nullable
    private Annotation createAnnotation(@NotNull Document document, @NotNull JSLinterError linterError, @NotNull Function<HighlightSeverity, TextAttributes> severityTextAttributesProvider) {
        if (document == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(8);
        }
        if (linterError == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(9);
        }
        if (severityTextAttributesProvider == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(10);
        }
        int errorLine = linterError.getLine();
        int errorColumn = linterError.getColumn();
        if (errorLine < 0 || errorLine >= document.getLineCount()) {
            return null;
        }
        TextRange range = this.calculateAnnotationRange(document, errorLine, errorColumn);
        if (range == null) {
            return null;
        }
        String message = this.myPrefix + linterError.getDescription();
        String code = linterError.getCode();
        if (code != null) {
            message = message + " (" + code + ")";
        }
        HighlightSeverity severity = JSLinterInspection.getSeverityForError(linterError.getLinterSeverity(), this.myFile, this.myInspectionClass);
        TextAttributes severityTextAttributes = (TextAttributes)severityTextAttributesProvider.fun((Object)severity);
        Annotation annotation = JSLinterUtil.createAnnotation(this.myHolder, severity, severityTextAttributes, range, message);
        annotation.setTooltip(JSLinterUtil.addHtmlURLMarkupIfNeeded(message));
        annotation.setAfterEndOfLine(range.getStartOffset() == document.getLineEndOffset(errorLine));
        return annotation;
    }

    private TextRange calculateAnnotationRange(@NotNull Document document, int errorLine, int errorColumn) {
        int errorLineStartOffset;
        if (document == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(11);
        }
        int lineEndOffset = document.getLineEndOffset(errorLine);
        int lineStartOffset = document.getLineStartOffset(errorLine);
        if (errorColumn == -1) {
            errorLineStartOffset = JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.line == this.myHighlightingGranularity ? lineStartOffset : lineEndOffset;
        } else {
            errorLineStartOffset = JSLinterAnnotationsBuilder.calcErrorStartOffsetInDocument(document, lineStartOffset, lineEndOffset, errorColumn, this.myTabSize);
            errorLineStartOffset = Math.min(errorLineStartOffset, document.getTextLength() - 1);
        }
        if (errorLineStartOffset == -1) {
            return null;
        }
        PsiElement element = this.myFile.findElementAt(errorLineStartOffset);
        if (element != null && element.isValid()) {
            Set suppressors = InspectionProfileEntry.getSuppressors((PsiElement)element);
            for (InspectionSuppressor suppressor : suppressors) {
                if (!suppressor.isSuppressedFor(element, this.myKey.getID())) continue;
                return null;
            }
        }
        if (JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.line.equals((Object)this.myHighlightingGranularity)) {
            return new TextRange(lineStartOffset, lineEndOffset);
        }
        if (JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.element.equals((Object)this.myHighlightingGranularity) && element != null && element.isValid()) {
            if (element instanceof PsiWhiteSpace) {
                TextRange range = element.getTextRange();
                return new TextRange(Math.max(lineStartOffset, range.getStartOffset()), range.getEndOffset());
            }
            return element.getTextRange();
        }
        return new TextRange(errorLineStartOffset, errorLineStartOffset + 1);
    }

    private static int calcErrorStartOffsetInDocument(@NotNull Document document, int lineStartOffset, int lineEndOffset, int errorColumn, int tabSize) {
        if (document == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(12);
        }
        if (tabSize <= 1) {
            if (errorColumn < 0) {
                return lineStartOffset;
            }
            if (lineStartOffset + errorColumn <= lineEndOffset) {
                return lineStartOffset + errorColumn;
            }
            return lineEndOffset;
        }
        CharSequence docText = document.getCharsSequence();
        int offset = lineStartOffset;
        for (int col = 0; offset < lineEndOffset && col < errorColumn; col += docText.charAt(offset) == '\t' ? tabSize : 1, ++offset) {
        }
        return offset;
    }

    public JSLinterAnnotationsBuilder<T> setHighlightingGranularity(@NotNull JSLinterWithInspectionExternalAnnotator.HighlightingGranularity highlightingGranularity) {
        if (highlightingGranularity == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(13);
        }
        this.myHighlightingGranularity = highlightingGranularity;
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationResult";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorPrefix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder";
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linterError";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityTextAttributesProvider";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightingGranularity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setTabSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "calculateAnnotationRange";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calcErrorStartOffsetInDocument";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightingGranularity";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

