/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsContent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class DirectoryContent {
    private final Collection<String> mySubDirectories = new HashSet<String>();
    private final Collection<String> myFiles = new HashSet<String>();
    private final Collection<String> myModules = new HashSet<String>();

    public int getTotalSize() {
        return this.mySubDirectories.size() + this.myFiles.size() + this.myModules.size();
    }

    public void addSubDirectory(String subDirectoryName) {
        this.mySubDirectories.add(subDirectoryName);
    }

    public void addFile(String fileName) {
        this.myFiles.add(fileName);
    }

    public void addModule(String moduleName) {
        this.myModules.add(moduleName);
    }

    public Collection<String> getSubDirectories() {
        return DirectoryContent.convertToSortedCollection(this.mySubDirectories);
    }

    public Collection<String> getFiles() {
        return DirectoryContent.convertToSortedCollection(this.myFiles);
    }

    public Collection<String> getSubModules() {
        return DirectoryContent.convertToSortedCollection(this.myModules);
    }

    public Collection<String> getSubDirectoriesRaw() {
        return this.mySubDirectories;
    }

    public Collection<String> getFilesRaw() {
        return this.myFiles;
    }

    public Collection<String> getSubModulesRaw() {
        return this.myModules;
    }

    private static Collection<String> convertToSortedCollection(Collection<String> collection) {
        ArrayList<String> result = new ArrayList<String>(collection);
        Collections.sort(result, (o, o1) -> o.compareToIgnoreCase((String)o1));
        return result;
    }

    public void copyDataFrom(DirectoryContent directoryContent) {
        this.mySubDirectories.addAll(directoryContent.getSubDirectories());
        this.myFiles.addAll(directoryContent.getFiles());
        this.myModules.addAll(directoryContent.getSubModules());
    }

    public void clear() {
        this.mySubDirectories.clear();
        this.myFiles.clear();
        this.myModules.clear();
    }
}

