/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PathUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocCommentGenerator;
import com.jetbrains.php.lang.inspections.quickfix.createClass.PhpCreateClassQuickFix;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.roots.PhpPsrNamespaceRootDetector;
import com.jetbrains.php.templates.PhpCreateFileFromTemplateDataProvider;
import java.io.File;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpNewBaseAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(PhpNewBaseAction.class);
    private static final String SEPARATOR = "/";

    protected PhpNewBaseAction(@NotNull String actionName, @NotNull String description, @NotNull Icon icon) {
        if (actionName == null) {
            PhpNewBaseAction.$$$reportNull$$$0(0);
        }
        if (description == null) {
            PhpNewBaseAction.$$$reportNull$$$0(1);
        }
        if (icon == null) {
            PhpNewBaseAction.$$$reportNull$$$0(2);
        }
        super(actionName, description, icon);
    }

    protected PhpNewBaseAction(@NotNull String actionName, @NotNull String description) {
        if (actionName == null) {
            PhpNewBaseAction.$$$reportNull$$$0(3);
        }
        if (description == null) {
            PhpNewBaseAction.$$$reportNull$$$0(4);
        }
        this(actionName, description, PhpIcons.PHP_FILE);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext;
        IdeView view;
        if (e == null) {
            PhpNewBaseAction.$$$reportNull$$$0(5);
        }
        if ((view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext = e.getDataContext())) == null) {
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        PsiDirectory initialBaseDir = view.getOrChooseDirectory();
        if (initialBaseDir == null) {
            return;
        }
        this.invoke(project, initialBaseDir, this.getFile(dataContext), view, (Editor)CommonDataKeys.EDITOR.getData(dataContext));
    }

    public PsiFile getFile(DataContext dataContext) {
        return (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
    }

    @Deprecated
    public void invoke(@NotNull Project project, @NotNull PsiDirectory initialBaseDir, @Nullable PsiFile file, @Nullable IdeView view) {
        if (project == null) {
            PhpNewBaseAction.$$$reportNull$$$0(6);
        }
        if (initialBaseDir == null) {
            PhpNewBaseAction.$$$reportNull$$$0(7);
        }
        this.invoke(project, initialBaseDir, file, view, null);
    }

    public void invoke(@NotNull Project project, @NotNull PsiDirectory initialBaseDir, @Nullable PsiFile file, @Nullable IdeView view, @Nullable Editor editor) {
        PhpCreateFileFromTemplateDataProvider providerByEditor;
        PhpCreateFileFromTemplateDataProvider dataProvider;
        if (project == null) {
            PhpNewBaseAction.$$$reportNull$$$0(8);
        }
        if (initialBaseDir == null) {
            PhpNewBaseAction.$$$reportNull$$$0(9);
        }
        PhpCreateFileFromTemplateDataProvider phpCreateFileFromTemplateDataProvider = dataProvider = (providerByEditor = this.getDataProvider(project, initialBaseDir, file, editor)) != null ? providerByEditor : this.getDataProvider(project, initialBaseDir, file);
        if (dataProvider == null) {
            return;
        }
        PsiFile createdFile = this.createFile(project, dataProvider);
        if (createdFile == null) {
            return;
        }
        PhpNewBaseAction.navigateToCreatedFile(project, view, dataProvider.getFilePath(), createdFile);
        PhpNewBaseAction.startLiveTemplate(project, dataProvider.getTemplateName(), createdFile);
    }

    @Nullable
    protected PsiFile createFile(@NotNull Project project, @NotNull PhpCreateFileFromTemplateDataProvider dataProvider) {
        if (project == null) {
            PhpNewBaseAction.$$$reportNull$$$0(10);
        }
        if (dataProvider == null) {
            PhpNewBaseAction.$$$reportNull$$$0(11);
        }
        PsiDirectory baseDir = dataProvider.getBaseDirectory();
        String templateName = dataProvider.getTemplateName();
        String filePath = dataProvider.getFilePath();
        Properties properties = dataProvider.getProperties(baseDir);
        properties.setProperty("FILE_NAME", PathUtil.getFileName((String)filePath));
        PsiFile createdFile = PhpCreateClassQuickFix.createClassInSeparateFile(project, properties, filePath, baseDir, this.getActionName(), templateName);
        if (createdFile == null) {
            return null;
        }
        if (createdFile instanceof PhpFile) {
            PhpPsrNamespaceRootDetector.detectNewRootDirectory(project, (PhpFile)createdFile, properties.getProperty("NAMESPACE"));
        }
        return createdFile;
    }

    protected static void navigateToCreatedFile(@NotNull Project project, @Nullable IdeView view, @NotNull String filePath, @NotNull PsiFile createdFile) {
        if (project == null) {
            PhpNewBaseAction.$$$reportNull$$$0(12);
        }
        if (filePath == null) {
            PhpNewBaseAction.$$$reportNull$$$0(13);
        }
        if (createdFile == null) {
            PhpNewBaseAction.$$$reportNull$$$0(14);
        }
        if (view != null) {
            view.selectElement((PsiElement)createdFile);
        } else if (createdFile instanceof PhpFile) {
            VirtualFile virtualFile = createdFile.getVirtualFile();
            if (virtualFile == null) {
                LOG.warn("Can not open created file: '" + filePath + "'");
            } else {
                PsiNavigationSupport.getInstance().createNavigatable(project, virtualFile, -1).navigate(false);
            }
        }
    }

    protected static void startLiveTemplate(@NotNull Project project, @NotNull String templateName, @NotNull PsiFile createdFile) {
        FileTemplate template;
        if (project == null) {
            PhpNewBaseAction.$$$reportNull$$$0(15);
        }
        if (templateName == null) {
            PhpNewBaseAction.$$$reportNull$$$0(16);
        }
        if (createdFile == null) {
            PhpNewBaseAction.$$$reportNull$$$0(17);
        }
        if ((template = FileTemplateManager.getInstance((Project)project).findInternalTemplate(templateName)) != null && template.isLiveTemplateEnabled()) {
            CreateFromTemplateActionBase.startLiveTemplate((PsiFile)createdFile);
        } else {
            Editor editor;
            PhpDocComment docComment;
            PhpClass clazz = (PhpClass)PsiTreeUtil.findChildOfType((PsiElement)createdFile, PhpClass.class, (boolean)false);
            PhpDocComment phpDocComment = docComment = clazz != null ? clazz.getDocComment() : null;
            if (docComment != null && (editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor()) != null) {
                WriteCommandAction.runWriteCommandAction((Project)project, () -> PhpDocCommentGenerator.tryMoveCaretOnMarker(editor, docComment.getTextRange()));
            }
        }
    }

    @Nullable
    protected abstract PhpCreateFileFromTemplateDataProvider getDataProvider(@NotNull Project var1, @NotNull PsiDirectory var2, @Nullable PsiFile var3);

    @Nullable
    protected PhpCreateFileFromTemplateDataProvider getDataProvider(@NotNull Project project, @NotNull PsiDirectory directory, @Nullable PsiFile file, @Nullable Editor editor) {
        if (project == null) {
            PhpNewBaseAction.$$$reportNull$$$0(18);
        }
        if (directory == null) {
            PhpNewBaseAction.$$$reportNull$$$0(19);
        }
        return null;
    }

    @NotNull
    private String getActionName() {
        String string = this.getTemplatePresentation().getText();
        if (string == null) {
            PhpNewBaseAction.$$$reportNull$$$0(20);
        }
        return string;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PhpNewBaseAction.$$$reportNull$$$0(21);
        }
        boolean enabled = PhpNewBaseAction.isAvailable(e.getDataContext());
        Presentation presentation = e.getPresentation();
        presentation.setVisible(enabled);
        presentation.setEnabled(enabled);
    }

    public static boolean isAvailable(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        if (DumbService.getInstance((Project)project).isDumb()) {
            return false;
        }
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        return view != null && view.getDirectories().length != 0;
    }

    @Nullable
    protected static String isValidFilePath(@NotNull String fullFilePath, @NotNull PsiDirectory baseDirectory) {
        String filePath;
        if (fullFilePath == null) {
            PhpNewBaseAction.$$$reportNull$$$0(22);
        }
        if (baseDirectory == null) {
            PhpNewBaseAction.$$$reportNull$$$0(23);
        }
        if ((filePath = StringUtil.replace((String)fullFilePath, (String)File.separator, (String)SEPARATOR)).length() == 0) {
            return PhpBundle.message("validation.file.not.valid.name", fullFilePath);
        }
        List split = StringUtil.split((String)filePath, (String)SEPARATOR);
        if (split.size() == 0) {
            return PhpBundle.message("validation.file.not.valid.name", fullFilePath);
        }
        for (int i = 0; i < split.size(); ++i) {
            String path = (String)split.get(i);
            if (PhpNameUtil.isValidFileName(path)) continue;
            return PhpBundle.message("validation.file.not.valid.name", fullFilePath);
        }
        VirtualFile baseDirectoryFile = baseDirectory.getVirtualFile();
        VirtualFile fileByRelativePath = baseDirectoryFile.findFileByRelativePath(PhpNameUtil.trimStart(filePath, '/'));
        if (fileByRelativePath != null) {
            return PhpBundle.message("validation.file.already.exists", fullFilePath);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 5: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialBaseDir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/actions/PhpNewBaseAction";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullFilePath";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/actions/PhpNewBaseAction";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "navigateToCreatedFile";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "startLiveTemplate";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDataProvider";
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isValidFilePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

