/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.builtInWebServer;

import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.SingletonNotificationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.PathUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.builtInWebServer.PhpCgiService;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.PhpProjectWorkspaceConfiguration;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "NOTIFICATION_GROUP", "Lcom/intellij/notification/NotificationGroup;", "getPhpCgiPath", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "notification", "Lcom/intellij/notification/SingletonNotificationManager;", "intellij.php.jsDebugger"})
public final class PhpCgiServiceKt {
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("PHP-CGI Server", NotificationDisplayType.STICKY_BALLOON, true);
    private static final Logger LOG;

    private static final File getPhpCgiPath(Project project, SingletonNotificationManager notification2) {
        File phpCgi;
        PhpProjectConfigurationFacade phpProjectConfigurationFacade = PhpProjectConfigurationFacade.getInstance(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)phpProjectConfigurationFacade, (String)"PhpProjectConfigurationFacade.getInstance(project)");
        PhpProjectWorkspaceConfiguration.State state = phpProjectConfigurationFacade.getProjectConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)state, (String)"PhpProjectConfigurationF\u2026ect).projectConfiguration");
        String interpreterName = state.getInterpreterName();
        PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreter(interpreterName);
        if (interpreter == null) {
            SingletonNotificationManager singletonNotificationManager = notification2;
            if (singletonNotificationManager != null) {
                String string = PhpBundle.message("php.interpreter.not.configured.title", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PhpBundle.message(\"php.i\u2026er.not.configured.title\")");
                String string2 = PhpBundle.message("php.interpreter.not.configured", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PhpBundle.message(\"php.i\u2026erpreter.not.configured\")");
                SingletonNotificationManager.notify$default((SingletonNotificationManager)singletonNotificationManager, (String)string, (String)string2, (Project)project, null, null, (int)24, null);
            }
            LOG.warn("cannot find interpreter " + interpreterName);
            return null;
        }
        if (interpreter.isRemote()) {
            SingletonNotificationManager singletonNotificationManager = notification2;
            if (singletonNotificationManager != null) {
                String string = PhpBundle.message("php.interpreter.is.remote.title", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PhpBundle.message(\"php.i\u2026rpreter.is.remote.title\")");
                String string3 = PhpBundle.message("php.interpreter.is.remote.message", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"PhpBundle.message(\"php.i\u2026reter.is.remote.message\")");
                SingletonNotificationManager.notify$default((SingletonNotificationManager)singletonNotificationManager, (String)string, (String)string3, (Project)project, null, null, (int)24, null);
            }
            LOG.warn("built-in web server does not support remote interpreters: " + interpreterName);
            return null;
        }
        String home = interpreter.getPathToPhpExecutable();
        File file = phpCgi = home == null ? null : new File(PathUtil.getParentPath((String)home), PhpProjectConfigurationFacade.PHP_CGI);
        if (phpCgi == null || !phpCgi.exists()) {
            SingletonNotificationManager singletonNotificationManager = notification2;
            if (singletonNotificationManager != null) {
                String string = PhpBundle.message("php.cgi.not.found.title", PhpProjectConfigurationFacade.PHP_CGI);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PhpBundle.message(\"php.c\u2026figurationFacade.PHP_CGI)");
                String string4 = PhpBundle.message("php.cgi.not.found", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"PhpBundle.message(\"php.cgi.not.found\")");
                SingletonNotificationManager.notify$default((SingletonNotificationManager)singletonNotificationManager, (String)string, (String)string4, (Project)project, null, null, (int)24, null);
            }
            LOG.warn("php-cgi not found " + interpreterName);
            return null;
        }
        return phpCgi;
    }

    static {
        Logger logger = Logger.getInstance(PhpCgiService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Nullable
    public static final /* synthetic */ File access$getPhpCgiPath(@NotNull Project project, @Nullable SingletonNotificationManager notification2) {
        return PhpCgiServiceKt.getPhpCgiPath(project, notification2);
    }

    @NotNull
    public static final /* synthetic */ NotificationGroup access$getNOTIFICATION_GROUP$p() {
        return NOTIFICATION_GROUP;
    }
}

