/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.library;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.PhpProjectWorkspaceConfiguration;
import com.jetbrains.php.config.library.PhpAdditionalLibraryManager;
import com.jetbrains.php.config.library.PhpLibraryRoot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="PhpIncludePathManager", storages={@Storage(value="php.xml")})
public class PhpIncludePathManager
extends PhpAdditionalLibraryManager
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(PhpIncludePathManager.class);
    public static final String PHP_LIBRARY_NAME = "PHP";
    private long myLastRootsChangeTimestampMillis;
    @NotNull
    private List<String> myIncludePaths;
    private volatile boolean myMuted;

    public static PhpIncludePathManager getInstance(@NotNull Project project) {
        if (project == null) {
            PhpIncludePathManager.$$$reportNull$$$0(0);
        }
        return (PhpIncludePathManager)project.getComponent(PhpIncludePathManager.class);
    }

    public PhpIncludePathManager(@NotNull Project project) {
        if (project == null) {
            PhpIncludePathManager.$$$reportNull$$$0(1);
        }
        super(project, LOG);
        this.myLastRootsChangeTimestampMillis = System.currentTimeMillis();
        this.myIncludePaths = ContainerUtil.newSmartList();
    }

    @Override
    public void projectOpened() {
        super.projectOpened();
        PhpIncludePathManager.deleteOldStyleLibrary(this.myProject, PHP_LIBRARY_NAME);
        PhpIncludePathManager.deleteOldStyleLibrary(this.myProject, "PHP Runtime");
    }

    @Override
    @NotNull
    protected Collection<VirtualFile> collectRoots() {
        List<VirtualFile> files = Collections.synchronizedList(new ArrayList());
        ApplicationManager.getApplication().invokeAndWait(() -> WriteAction.run(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            VirtualFile baseDir = this.myProject.getBaseDir();
            for (String path : this.getIncludePath()) {
                VirtualFile includeRoot = FileUtil.isAbsolute((String)path) ? LocalFileSystem.getInstance().refreshAndFindFileByPath(path) : baseDir.findFileByRelativePath(path);
                if (includeRoot == null) continue;
                files.add(includeRoot);
            }
        }));
        DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        dumbService.runReadActionInSmartMode(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            Arrays.stream(PhpLibraryRoot.EP_NAME.getExtensions()).map(PhpLibraryRoot::getProvider).filter(provider -> !provider.isRuntime()).flatMap(provider -> provider.getLibraryRoots(this.myProject)).forEach(files::add);
        });
        List<VirtualFile> list = files;
        if (list == null) {
            PhpIncludePathManager.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public String getComponentName() {
        if ("PhpIncludePathManager" == null) {
            PhpIncludePathManager.$$$reportNull$$$0(3);
        }
        return "PhpIncludePathManager";
    }

    @NotNull
    public List<String> getIncludePath() {
        this.ensureOldPathsSynchronized(null);
        ArrayList<String> arrayList = new ArrayList<String>(this.myIncludePaths);
        if (arrayList == null) {
            PhpIncludePathManager.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public void setIncludePath(@NotNull List<String> includePath) {
        if (includePath == null) {
            PhpIncludePathManager.$$$reportNull$$$0(5);
        }
        HashSet initialIncludePaths = new HashSet();
        initialIncludePaths.addAll(this.myIncludePaths);
        SmartList addedOldPaths = new SmartList();
        this.ensureOldPathsSynchronized((List<String>)addedOldPaths);
        this.myIncludePaths = new ArrayList<String>(PhpIncludePathManager.prepareAsIncludePaths(includePath));
        this.myIncludePaths.addAll((Collection<String>)addedOldPaths);
        HashSet newIncludePaths = new HashSet();
        newIncludePaths.addAll(this.myIncludePaths);
        if (newIncludePaths.equals(initialIncludePaths)) {
            return;
        }
        PhpProjectWorkspaceConfiguration.State configuration = PhpProjectConfigurationFacade.getInstance(this.myProject).getProjectConfiguration();
        configuration.setIncludePath(this.myIncludePaths);
        long timestamp = System.currentTimeMillis();
        long delta = timestamp - this.myLastRootsChangeTimestampMillis;
        if (delta < 10000L) {
            LOG.warn("Frequent include path update. Delta " + delta + ", old path: " + initialIncludePaths + "\nnew path: " + this.myIncludePaths);
        }
        this.myLastRootsChangeTimestampMillis = timestamp;
        DumbService.getInstance((Project)this.myProject).runWhenSmart(() -> PhpAdditionalLibraryManager.fireLibraryChanged(this.myProject));
    }

    public void setMutedForTest(boolean muted) {
        this.myMuted = muted;
    }

    @Override
    protected void updateProjectLibrary(@Nullable AtomicBoolean changed) {
        if (this.myMuted) {
            return;
        }
        super.updateProjectLibrary(changed);
    }

    @Override
    protected void modifyLibraries(@Nullable VirtualFile fileToAdd, boolean removeInvalidFiles) {
        if (this.myMuted) {
            return;
        }
        super.modifyLibraries(fileToAdd, removeInvalidFiles);
    }

    @Nullable
    public State getState() {
        State state = new State();
        state.setSerializedIncludePath(this.myIncludePaths);
        return state;
    }

    @NotNull
    private static List<String> prepareAsIncludePaths(List<String> includePaths) {
        List list = ContainerUtil.map(includePaths, path -> FileUtil.toSystemIndependentName((String)path));
        if (list == null) {
            PhpIncludePathManager.$$$reportNull$$$0(6);
        }
        return list;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            PhpIncludePathManager.$$$reportNull$$$0(7);
        }
        this.myIncludePaths = new ArrayList<String>(PhpIncludePathManager.prepareAsIncludePaths(state.getSerializedIncludePath()));
        this.ensureOldPathsSynchronized(null);
    }

    private void ensureOldPathsSynchronized(@Nullable List<String> addedOldPaths) {
        PhpProjectWorkspaceConfiguration.State configuration = PhpProjectConfigurationFacade.getInstance(this.myProject).getProjectConfiguration();
        List<String> oldIncludePath = PhpIncludePathManager.prepareAsIncludePaths(configuration.getIncludePath());
        for (String path : oldIncludePath) {
            if (this.myIncludePaths.contains(path)) continue;
            this.myIncludePaths.add(path);
            if (addedOldPaths == null) continue;
            addedOldPaths.add(path);
        }
        configuration.setIncludePath(this.myIncludePaths);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/library/PhpIncludePathManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/library/PhpIncludePathManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRoots";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludePath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareAsIncludePaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setIncludePath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class State {
        private List<String> myIncludePath = new ArrayList<String>();

        @XCollection(propertyElementName="include_path", elementName="path")
        public List<String> getSerializedIncludePath() {
            return this.myIncludePath;
        }

        public void setSerializedIncludePath(@NotNull List<String> includePaths) {
            if (includePaths == null) {
                State.$$$reportNull$$$0(0);
            }
            this.myIncludePath = includePaths;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "includePaths", "com/jetbrains/php/config/library/PhpIncludePathManager$State", "setSerializedIncludePath"));
        }
    }
}

