/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common.smartStepInto;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.smartStepInto.PhpSmartStepIntoVariant;
import com.jetbrains.php.lang.PhpLangUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSmartStepIntoCaller {
    private static final String ARRAY = "Array";
    private final PhpDebugProcess myProcess;
    private final Project myProject;

    public PhpSmartStepIntoCaller(PhpDebugProcess process, Project project) {
        this.myProcess = process;
        this.myProject = project;
    }

    private static boolean isVariable(@Nullable String functionName) {
        return StringUtil.isNotEmpty((String)functionName) && StringUtil.startsWith((CharSequence)functionName, (CharSequence)"$");
    }

    public void startStepInto(final @NotNull PhpSmartStepIntoVariant variant) {
        if (variant == null) {
            PhpSmartStepIntoCaller.$$$reportNull$$$0(0);
        }
        if (variant instanceof PhpSmartStepIntoVariant.PhpMethodSmartStepIntoVariant) {
            final PhpSmartStepIntoVariant.PhpMethodSmartStepIntoVariant methodVariant = (PhpSmartStepIntoVariant.PhpMethodSmartStepIntoVariant)variant;
            final String classReference = methodVariant.getClassReference();
            if (PhpSmartStepIntoCaller.isVariable(classReference)) {
                String expression = "get_class(" + classReference + ")";
                this.myProcess.evalString(expression, new PhpDebugProcess.StringEvaluateCallback(){

                    @Override
                    public void evaluated(@NotNull String result) {
                        if (result == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (StringUtil.isEmpty((String)result)) {
                            PhpSmartStepIntoCaller.this.myProcess.evalString(classReference, new PhpDebugProcess.StringEvaluateCallback(){

                                @Override
                                public void evaluated(@NotNull String result) {
                                    if (result == null) {
                                        1.$$$reportNull$$$0(0);
                                    }
                                    PhpSmartStepIntoCaller.this.smartStepIntoMethod(methodVariant, result);
                                }

                                @Override
                                public void errorOccurred() {
                                    PhpSmartStepIntoCaller.this.errorInSmartStepInto();
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/php/debug/common/smartStepInto/PhpSmartStepIntoCaller$1$1", "evaluated"));
                                }
                            });
                        } else {
                            PhpSmartStepIntoCaller.this.smartStepIntoMethod(methodVariant, result);
                        }
                    }

                    @Override
                    public void errorOccurred() {
                        PhpSmartStepIntoCaller.this.errorInSmartStepInto();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/php/debug/common/smartStepInto/PhpSmartStepIntoCaller$1", "evaluated"));
                    }
                });
            } else {
                this.smartStepIntoMethod(methodVariant, classReference);
            }
        } else if (variant instanceof PhpSmartStepIntoVariant.PhpFunctionSmartStepIntoVariant) {
            String functionName = ((PhpSmartStepIntoVariant.PhpFunctionSmartStepIntoVariant)variant).getFunctionName();
            if (PhpSmartStepIntoCaller.isVariable(functionName)) {
                this.myProcess.evalString(variant.getVariantName(), new PhpDebugProcess.StringEvaluateCallback(){

                    @Override
                    public void evaluated(@NotNull String result) {
                        if (result == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (StringUtil.equals((CharSequence)result, (CharSequence)PhpSmartStepIntoCaller.ARRAY)) {
                            this.evaluateArrayValue(variant.getVariantName());
                        } else {
                            List methodName = PhpSmartStepIntoCaller.splitFunctionName(result);
                            if (methodName.size() == 2) {
                                PhpSmartStepIntoCaller.this.evalClassNames(variant, ContainerUtil.newArrayList((Object[])new String[]{(String)methodName.get(1)}), (String)methodName.get(0));
                            } else {
                                PhpSmartStepIntoCaller.this.myProcess.startSmartStepInto(variant.getLineStart(), variant.getLineEnd(), null, result);
                            }
                        }
                    }

                    private void evaluateArrayValue(final @NotNull String array) {
                        if (array == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        String expression = "get_class(" + array + "[0])";
                        PhpSmartStepIntoCaller.this.myProcess.evalString(expression, new PhpDebugProcess.StringEvaluateCallback(){

                            @Override
                            public void evaluated(@NotNull String result) {
                                if (result == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (StringUtil.isEmpty((String)result)) {
                                    PhpSmartStepIntoCaller.this.myProcess.evalString(array + "[0]", new PhpDebugProcess.StringEvaluateCallback(){

                                        @Override
                                        public void evaluated(@NotNull String result) {
                                            if (result == null) {
                                                1.$$$reportNull$$$0(0);
                                            }
                                            this.evaluateMethodName(array, result);
                                        }

                                        @Override
                                        public void errorOccurred() {
                                            PhpSmartStepIntoCaller.this.errorInSmartStepInto();
                                        }

                                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/php/debug/common/smartStepInto/PhpSmartStepIntoCaller$2$1$1", "evaluated"));
                                        }
                                    });
                                } else {
                                    this.evaluateMethodName(array, result);
                                }
                            }

                            @Override
                            public void errorOccurred() {
                                PhpSmartStepIntoCaller.this.errorInSmartStepInto();
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/php/debug/common/smartStepInto/PhpSmartStepIntoCaller$2$1", "evaluated"));
                            }
                        });
                    }

                    private void evaluateMethodName(@NotNull String array, final @NotNull String classReference) {
                        if (array == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        if (classReference == null) {
                            2.$$$reportNull$$$0(3);
                        }
                        PhpSmartStepIntoCaller.this.myProcess.evalString(array + "[1]", new PhpDebugProcess.StringEvaluateCallback(){

                            @Override
                            public void evaluated(@NotNull String result) {
                                if (result == null) {
                                    2.$$$reportNull$$$0(0);
                                }
                                PhpSmartStepIntoCaller.this.evalClassNames(variant, ContainerUtil.newArrayList((Object[])new String[]{result}), classReference);
                            }

                            @Override
                            public void errorOccurred() {
                                PhpSmartStepIntoCaller.this.errorInSmartStepInto();
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/php/debug/common/smartStepInto/PhpSmartStepIntoCaller$2$2", "evaluated"));
                            }
                        });
                    }

                    @Override
                    public void errorOccurred() {
                        PhpSmartStepIntoCaller.this.errorInSmartStepInto();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "result";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "array";
                                break;
                            }
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "classReference";
                                break;
                            }
                        }
                        objectArray2[1] = "com/jetbrains/php/debug/common/smartStepInto/PhpSmartStepIntoCaller$2";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "evaluated";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "evaluateArrayValue";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "evaluateMethodName";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            } else {
                this.myProcess.startSmartStepInto(variant.getLineStart(), variant.getLineEnd(), null, variant.getVariantName());
            }
        }
    }

    @NotNull
    private static List<String> splitFunctionName(@NotNull String name) {
        List split;
        if (name == null) {
            PhpSmartStepIntoCaller.$$$reportNull$$$0(1);
        }
        List list = (split = StringUtil.split((String)name, (String)"::")).size() > 1 ? split : StringUtil.split((String)name, (String)"->");
        if (list == null) {
            PhpSmartStepIntoCaller.$$$reportNull$$$0(2);
        }
        return list;
    }

    private void smartStepIntoMethod(final @NotNull PhpSmartStepIntoVariant.PhpMethodSmartStepIntoVariant variant, final @Nullable String clazz) {
        if (variant == null) {
            PhpSmartStepIntoCaller.$$$reportNull$$$0(3);
        }
        final List<String> stackTrace = variant.getStackTrace();
        String functionName = variant.getFunctionName();
        if (PhpSmartStepIntoCaller.isVariable(functionName)) {
            this.myProcess.evalString(functionName, new PhpDebugProcess.StringEvaluateCallback(){

                @Override
                public void evaluated(@NotNull String result) {
                    if (result == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    PhpSmartStepIntoCaller.this.evalStackTrace(stackTrace, variant, clazz, result);
                }

                @Override
                public void errorOccurred() {
                    PhpSmartStepIntoCaller.this.errorInSmartStepInto();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/php/debug/common/smartStepInto/PhpSmartStepIntoCaller$3", "evaluated"));
                }
            });
        } else {
            this.evalStackTrace(stackTrace, variant, clazz, functionName);
        }
    }

    private void evalStackTrace(@Nullable List<String> stackTrace, @NotNull PhpSmartStepIntoVariant.PhpMethodSmartStepIntoVariant variant, @Nullable String clazz, @NotNull String functionName) {
        if (variant == null) {
            PhpSmartStepIntoCaller.$$$reportNull$$$0(4);
        }
        if (functionName == null) {
            PhpSmartStepIntoCaller.$$$reportNull$$$0(5);
        }
        if (stackTrace == null || stackTrace.isEmpty()) {
            this.evalClassNames(variant, ContainerUtil.newArrayList((Object[])new String[]{functionName}), clazz);
        } else {
            variant.setFunctionName(functionName);
            this.evalStackTrace(variant, clazz, stackTrace, 0);
        }
    }

    private void evalStackTrace(final @NotNull PhpSmartStepIntoVariant.PhpMethodSmartStepIntoVariant variant, final @Nullable String clazz, final @NotNull List<String> stackTrace, final int index) {
        String classReference;
        if (variant == null) {
            PhpSmartStepIntoCaller.$$$reportNull$$$0(6);
        }
        if (stackTrace == null) {
            PhpSmartStepIntoCaller.$$$reportNull$$$0(7);
        }
        if (PhpSmartStepIntoCaller.isVariable(classReference = stackTrace.get(index))) {
            this.myProcess.evalString(classReference, new PhpDebugProcess.StringEvaluateCallback(){

                @Override
                public void evaluated(@NotNull String result) {
                    if (result == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    stackTrace.set(index, result);
                    if (index == stackTrace.size() - 1) {
                        stackTrace.add(variant.getFunctionName());
                        PhpSmartStepIntoCaller.this.evalClassNames(variant, stackTrace, clazz);
                    } else {
                        PhpSmartStepIntoCaller.this.evalStackTrace(variant, clazz, stackTrace, index + 1);
                    }
                }

                @Override
                public void errorOccurred() {
                    PhpSmartStepIntoCaller.this.errorInSmartStepInto();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/php/debug/common/smartStepInto/PhpSmartStepIntoCaller$4", "evaluated"));
                }
            });
        } else if (index == stackTrace.size() - 1) {
            stackTrace.add(variant.getFunctionName());
            this.evalClassNames(variant, stackTrace, clazz);
        } else {
            this.evalStackTrace(variant, clazz, stackTrace, index + 1);
        }
    }

    private void evalClassNames(final @NotNull PhpSmartStepIntoVariant variant, final @NotNull List<String> stackTrace, final @Nullable String clazz) {
        if (variant == null) {
            PhpSmartStepIntoCaller.$$$reportNull$$$0(8);
        }
        if (stackTrace == null) {
            PhpSmartStepIntoCaller.$$$reportNull$$$0(9);
        }
        if (PhpLangUtil.isClassNameSpecial(clazz)) {
            this.myProcess.evalString("get_class($this)", new PhpDebugProcess.StringEvaluateCallback(){

                @Override
                public void evaluated(@NotNull String result) {
                    if (result == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (StringUtil.isNotEmpty((String)result)) {
                        if ("parent".equalsIgnoreCase(clazz)) {
                            PhpSmartStepIntoCaller.this.evalClassNames(variant, stackTrace, ContainerUtil.newHashSet(), result);
                        } else {
                            HashSet classes = ContainerUtil.newHashSet();
                            classes.add(StringUtil.toLowerCase((String)result));
                            PhpSmartStepIntoCaller.this.evalClassNames(variant, stackTrace, classes, result);
                        }
                    } else {
                        PhpSmartStepIntoCaller.this.myProcess.startSmartStepInto(variant.getLineStart(), variant.getLineEnd(), null, ArrayUtil.toStringArray((Collection)stackTrace));
                    }
                }

                @Override
                public void errorOccurred() {
                    PhpSmartStepIntoCaller.this.errorInSmartStepInto();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/php/debug/common/smartStepInto/PhpSmartStepIntoCaller$5", "evaluated"));
                }
            });
        } else if (StringUtil.isNotEmpty((String)clazz)) {
            HashSet classes = ContainerUtil.newHashSet();
            classes.add(StringUtil.toLowerCase((String)clazz));
            this.evalClassNames(variant, stackTrace, classes, clazz);
        } else {
            this.myProcess.startSmartStepInto(variant.getLineStart(), variant.getLineEnd(), null, ArrayUtil.toStringArray(stackTrace));
        }
    }

    private void evalClassNames(final @NotNull PhpSmartStepIntoVariant variant, final @NotNull List<String> stackTrace, final @NotNull Set<String> classes, @NotNull String clazz) {
        if (variant == null) {
            PhpSmartStepIntoCaller.$$$reportNull$$$0(10);
        }
        if (stackTrace == null) {
            PhpSmartStepIntoCaller.$$$reportNull$$$0(11);
        }
        if (classes == null) {
            PhpSmartStepIntoCaller.$$$reportNull$$$0(12);
        }
        if (clazz == null) {
            PhpSmartStepIntoCaller.$$$reportNull$$$0(13);
        }
        this.myProcess.evalString("get_parent_class('" + clazz + "')", new PhpDebugProcess.StringEvaluateCallback(){

            @Override
            public void evaluated(@NotNull String result) {
                if (result == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (StringUtil.isNotEmpty((String)result) && !classes.contains(result)) {
                    classes.add(StringUtil.toLowerCase((String)result));
                    PhpSmartStepIntoCaller.this.evalClassNames(variant, stackTrace, classes, result);
                } else {
                    PhpSmartStepIntoCaller.this.myProcess.startSmartStepInto(variant.getLineStart(), variant.getLineEnd(), classes, ArrayUtil.toStringArray((Collection)stackTrace));
                }
            }

            @Override
            public void errorOccurred() {
                PhpSmartStepIntoCaller.this.errorInSmartStepInto();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/php/debug/common/smartStepInto/PhpSmartStepIntoCaller$6", "evaluated"));
            }
        });
    }

    private void errorInSmartStepInto() {
        PhpDebugUtil.NOTIFICATION_GROUP.createNotification(PhpBundle.message("debug.process.smart.step.into.function.evaluation.error", new Object[0]), MessageType.ERROR).notify(this.myProject);
        this.myProcess.getSession().stepInto();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/common/smartStepInto/PhpSmartStepIntoCaller";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTrace";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/common/smartStepInto/PhpSmartStepIntoCaller";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "splitFunctionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startStepInto";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "splitFunctionName";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "smartStepIntoMethod";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "evalStackTrace";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "evalClassNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

