/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.findUsages;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.findUsages.PhpFindUsagesHandler;
import com.jetbrains.php.lang.findUsages.PhpFindUsagesOptions;
import com.jetbrains.php.lang.findUsages.PhpFindUsagesProvider;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PhpFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    private static final String FIND_USAGES = "Find Usages";
    private final PhpFindUsagesOptions myFindMethodOptions;

    public PhpFindUsagesHandlerFactory(Project project) {
        this.myFindMethodOptions = new PhpFindUsagesOptions(project);
    }

    public boolean canFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(0);
        }
        return element.isValid() && new PhpFindUsagesProvider().canFindUsagesFor(element);
    }

    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        if (element == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(1);
        }
        if (element instanceof Method && !forHighlightUsages) {
            Method[] methods = this.checkSuperMethods((Method)element, FIND_USAGES);
            if (methods.length > 1) {
                return new PhpFindUsagesHandler(element, (PsiElement[])methods, this);
            }
            if (methods.length == 1) {
                return new PhpFindUsagesHandler((PsiElement)methods[0], this);
            }
            return FindUsagesHandler.NULL_HANDLER;
        }
        return new PhpFindUsagesHandler(element, this);
    }

    @NotNull
    private Method[] checkSuperMethods(Method method, String actionString) {
        PhpClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            Method[] methodArray = new Method[]{method};
            if (methodArray == null) {
                PhpFindUsagesHandlerFactory.$$$reportNull$$$0(2);
            }
            return methodArray;
        }
        ArrayList<Method> superMethods = new ArrayList<Method>();
        PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)method, (method1, subClass, baseClass) -> {
            if (subClass != null && PhpLangUtil.isObject(subClass)) {
                return false;
            }
            superMethods.add((Method)method1);
            return true;
        });
        ArrayList allMethods = new ArrayList(superMethods);
        if (allMethods.isEmpty()) {
            Method[] methodArray = new Method[]{method};
            if (methodArray == null) {
                PhpFindUsagesHandlerFactory.$$$reportNull$$$0(3);
            }
            return methodArray;
        }
        Set<String> superClasses = PhpFindUsagesHandlerFactory.getSuperClasses(superMethods);
        StringBuilder messageBuilder = PhpFindUsagesHandlerFactory.createWindowMessage(method, containingClass, superClasses);
        if (this.isFindUsagesOfBaseMethod(method.getProject(), messageBuilder.toString(), actionString)) {
            Method[] methodArray = allMethods.toArray(Method.EMPTY);
            if (methodArray == null) {
                PhpFindUsagesHandlerFactory.$$$reportNull$$$0(4);
            }
            return methodArray;
        }
        Method[] methodArray = new Method[]{method};
        if (methodArray == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(5);
        }
        return methodArray;
    }

    protected boolean isFindUsagesOfBaseMethod(@NotNull Project project, @NotNull String message, @NotNull String title) {
        int result;
        if (project == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(6);
        }
        if (message == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(7);
        }
        if (title == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(8);
        }
        return (result = Messages.showYesNoCancelDialog((Project)project, (String)message, (String)title, (Icon)Messages.getQuestionIcon())) == 0;
    }

    public PhpFindUsagesOptions getFindMethodOptions() {
        return this.myFindMethodOptions;
    }

    @NotNull
    public static Set<Method> checkImplementedMethods(@NotNull PsiElement element) {
        if (element == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(9);
        }
        THashSet methodSet = new THashSet();
        Method method = (Method)element;
        THashSet implementedMethods = new THashSet();
        DumbService dumbService = DumbService.getInstance((Project)method.getProject());
        dumbService.runReadActionInSmartMode(() -> PhpFindUsagesHandlerFactory.lambda$checkImplementedMethods$2(method, (Set)implementedMethods));
        implementedMethods.add(method);
        if (implementedMethods.isEmpty()) {
            methodSet.add(method);
            THashSet tHashSet = methodSet;
            if (tHashSet == null) {
                PhpFindUsagesHandlerFactory.$$$reportNull$$$0(10);
            }
            return tHashSet;
        }
        THashSet tHashSet = implementedMethods;
        if (tHashSet == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(11);
        }
        return tHashSet;
    }

    private static StringBuilder createWindowMessage(@NotNull Method method, @NotNull PhpClass containingClass, @NotNull Set<String> superClasses) {
        if (method == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(12);
        }
        if (containingClass == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(13);
        }
        if (superClasses == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(14);
        }
        StringBuilder messageBuilder = new StringBuilder().append("Method ").append(method.getName()).append("() of class ").append(containingClass.getFQN());
        messageBuilder.append("\noverrides/implements method").append(superClasses.size() > 1 ? "s" : "").append(" in");
        for (String superClass : superClasses) {
            messageBuilder.append(superClasses.size() > 1 ? "\n\t" : " ").append(superClass);
        }
        messageBuilder.append("\nDo you want to find usages of base method").append(superClasses.size() > 1 ? "s" : "").append("?");
        return messageBuilder;
    }

    @NotNull
    private static Set<String> getSuperClasses(Collection<Method> superMethods) {
        THashSet superClasses = new THashSet();
        for (Method superMethod : superMethods) {
            PhpClass containingSuperClass = superMethod.getContainingClass();
            assert (containingSuperClass != null);
            superClasses.add(containingSuperClass.getFQN());
        }
        THashSet tHashSet = superClasses;
        if (tHashSet == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(15);
        }
        return tHashSet;
    }

    private static /* synthetic */ void lambda$checkImplementedMethods$2(Method method, Set implementedMethods) {
        PhpIndex phpIndex = PhpIndex.getInstance((Project)method.getProject());
        PhpClassHierarchyUtils.processOverridingMembers((PhpClassMember)method, (PhpIndex)phpIndex, (method1, subClass, baseClass) -> {
            implementedMethods.add((Method)method1);
            return true;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/findUsages/PhpFindUsagesHandlerFactory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/findUsages/PhpFindUsagesHandlerFactory";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "checkSuperMethods";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "checkImplementedMethods";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canFindUsages";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createFindUsagesHandler";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 15: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isFindUsagesOfBaseMethod";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkImplementedMethods";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createWindowMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

