/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter.ui;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.codeStyle.CommenterForm;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.refactoring.PhpNameStyle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class PhpGenerationCodeStylePanel
extends CodeStyleAbstractPanel {
    private JPanel myMainPanel;
    private JPanel myVariableNamingStylePanel;
    private JRadioButton myMixedRadioButton;
    private JRadioButton myCamelCaseRadioButton;
    private JRadioButton mySnakeCaseRadioButton;
    private JBScrollPane myScrollPane;
    private JPanel myOptionsPanel;
    private JPanel myDefaultFieldsVisibilityPanel;
    private JRadioButton myPrivateVisibilityRadioButton;
    private JRadioButton myProtectedVisibilityRadioButton;
    private JRadioButton myPublicVisibilityRadioButton;
    private JPanel myCodeCommentingPanel;
    private CommenterForm myCommenterForm;

    protected PhpGenerationCodeStylePanel(CodeStyleSettings settings) {
        super(settings);
        this.$$$setupUI$$$();
        ButtonGroup variableNamingStyleButtonGroup = new ButtonGroup();
        variableNamingStyleButtonGroup.add(this.myMixedRadioButton);
        variableNamingStyleButtonGroup.add(this.myCamelCaseRadioButton);
        variableNamingStyleButtonGroup.add(this.mySnakeCaseRadioButton);
        this.myVariableNamingStylePanel.setBorder(IdeBorderFactory.createTitledBorder((String)PhpBundle.message("variable.naming.style.panel", new Object[0])));
        ButtonGroup defaultFieldsVisibilityButtonGroup = new ButtonGroup();
        defaultFieldsVisibilityButtonGroup.add(this.myPrivateVisibilityRadioButton);
        defaultFieldsVisibilityButtonGroup.add(this.myProtectedVisibilityRadioButton);
        defaultFieldsVisibilityButtonGroup.add(this.myPublicVisibilityRadioButton);
        this.myDefaultFieldsVisibilityPanel.setBorder(IdeBorderFactory.createTitledBorder((String)PhpBundle.message("fields.default.visibility.panel", new Object[0])));
        this.myScrollPane.setMinimumSize(new Dimension(this.myOptionsPanel.getPreferredSize().width + this.myScrollPane.getVerticalScrollBar().getPreferredSize().width + 5, -1));
        this.myScrollPane.setPreferredSize(this.myScrollPane.getMinimumSize());
    }

    protected int getRightMargin() {
        return 80;
    }

    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        return EditorHighlighterFactory.getInstance().createEditorHighlighter((VirtualFile)new LightVirtualFile("a.php"), scheme, null);
    }

    @NotNull
    protected FileType getFileType() {
        PhpFileType phpFileType = PhpFileType.INSTANCE;
        if (phpFileType == null) {
            PhpGenerationCodeStylePanel.$$$reportNull$$$0(0);
        }
        return phpFileType;
    }

    protected String getPreviewText() {
        return "";
    }

    public void apply(CodeStyleSettings settings) {
        PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        phpCodeStyleSettings.VARIABLE_NAMING_STYLE = this.getVariableNamingStyle();
        phpCodeStyleSettings.FIELDS_DEFAULT_VISIBILITY = this.getFieldsDefaultVisibility();
        this.myCommenterForm.apply(settings);
    }

    public boolean isModified(CodeStyleSettings settings) {
        PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        return phpCodeStyleSettings.VARIABLE_NAMING_STYLE != this.getVariableNamingStyle() || phpCodeStyleSettings.FIELDS_DEFAULT_VISIBILITY != this.getFieldsDefaultVisibility() || this.myCommenterForm.isModified(settings);
    }

    @NotNull
    private PhpNameStyle.Style getVariableNamingStyle() {
        PhpNameStyle.Style style = this.myCamelCaseRadioButton.isSelected() ? PhpNameStyle.Style.CAMEL_CASE : (this.mySnakeCaseRadioButton.isSelected() ? PhpNameStyle.Style.SNAKE_CASE : PhpNameStyle.Style.MIXED);
        if (style == null) {
            PhpGenerationCodeStylePanel.$$$reportNull$$$0(1);
        }
        return style;
    }

    @NotNull
    private PhpModifier.Access getFieldsDefaultVisibility() {
        if (this.myPrivateVisibilityRadioButton.isSelected()) {
            PhpModifier.Access access = PhpModifier.Access.PRIVATE;
            if (access == null) {
                PhpGenerationCodeStylePanel.$$$reportNull$$$0(2);
            }
            return access;
        }
        if (this.myProtectedVisibilityRadioButton.isSelected()) {
            PhpModifier.Access access = PhpModifier.Access.PROTECTED;
            if (access == null) {
                PhpGenerationCodeStylePanel.$$$reportNull$$$0(3);
            }
            return access;
        }
        PhpModifier.Access access = PhpModifier.Access.PUBLIC;
        if (access == null) {
            PhpGenerationCodeStylePanel.$$$reportNull$$$0(4);
        }
        return access;
    }

    public JComponent getPanel() {
        return this.myMainPanel;
    }

    protected void resetImpl(CodeStyleSettings settings) {
        PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        this.myMixedRadioButton.setSelected(phpCodeStyleSettings.VARIABLE_NAMING_STYLE == PhpNameStyle.Style.MIXED);
        this.myCamelCaseRadioButton.setSelected(phpCodeStyleSettings.VARIABLE_NAMING_STYLE == PhpNameStyle.Style.CAMEL_CASE);
        this.mySnakeCaseRadioButton.setSelected(phpCodeStyleSettings.VARIABLE_NAMING_STYLE == PhpNameStyle.Style.SNAKE_CASE);
        this.myPrivateVisibilityRadioButton.setSelected(phpCodeStyleSettings.FIELDS_DEFAULT_VISIBILITY == PhpModifier.Access.PRIVATE);
        this.myProtectedVisibilityRadioButton.setSelected(phpCodeStyleSettings.FIELDS_DEFAULT_VISIBILITY == PhpModifier.Access.PROTECTED);
        this.myPublicVisibilityRadioButton.setSelected(phpCodeStyleSettings.FIELDS_DEFAULT_VISIBILITY == PhpModifier.Access.PUBLIC);
        this.myCommenterForm.reset(settings);
    }

    public Language getDefaultLanguage() {
        return PhpLanguage.INSTANCE;
    }

    private void createUIComponents() {
        this.myCommenterForm = new CommenterForm((Language)PhpLanguage.INSTANCE);
        this.myCodeCommentingPanel = this.myCommenterForm.getCommenterPanel();
    }

    protected String getTabTitle() {
        return PhpBundle.message("php.generation.code.style.title", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/lang/formatter/ui/PhpGenerationCodeStylePanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableNamingStyle";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsDefaultVisibility";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JRadioButton jRadioButton6;
        JPanel jPanel2;
        JPanel jPanel3;
        JBScrollPane jBScrollPane;
        JPanel jPanel4;
        this.createUIComponents();
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jPanel4.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myOptionsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel3);
        this.myVariableNamingStylePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("messages/PhpBundle").getString("variable.naming.style.panel"), 0, 0, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySnakeCaseRadioButton = jRadioButton6 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton6, ResourceBundle.getBundle("messages/PhpBundle").getString("variable.naming.style.snake.case"));
        jPanel5.add((Component)jRadioButton6, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCamelCaseRadioButton = jRadioButton5 = new JRadioButton();
        jRadioButton5.setSelected(false);
        this.$$$loadButtonText$$$(jRadioButton5, ResourceBundle.getBundle("messages/PhpBundle").getString("variable.naming.style.camel.case"));
        jPanel5.add((Component)jRadioButton5, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myMixedRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("messages/PhpBundle").getString("variable.naming.style.mixed"));
        jPanel5.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDefaultFieldsVisibilityPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("messages/PhpBundle").getString("fields.default.visibility.panel"), 0, 0, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPrivateVisibilityRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/PhpBundle").getString("fields.default.visibility.private"));
        jPanel6.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myProtectedVisibilityRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/PhpBundle").getString("fields.default.visibility.protected"));
        jPanel6.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPublicVisibilityRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/PhpBundle").getString("fields.default.visibility.public"));
        jPanel6.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel7 = this.myCodeCommentingPanel;
        jPanel3.add((Component)jPanel7, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

