/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpShortOpenTagInspection
extends PhpInspection {
    private static final LocalQuickFix QUICK_FIX = new PhpReplaceShortTagWithPhpTagQuickFix();

    @NotNull
    private static Collection<PsiElement> collectShortOpenTags(@Nullable GroupStatement groupStatement) {
        if (groupStatement == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                PhpShortOpenTagInspection.$$$reportNull$$$0(0);
            }
            return list;
        }
        List result = ContainerUtil.newSmartList();
        for (PsiElement child = groupStatement.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!PhpPsiUtil.isOfType(child, PhpTokenTypes.PHP_OPENING_TAG) || !child.textMatches((CharSequence)"<?")) continue;
            result.add(child);
        }
        List list = result;
        if (list == null) {
            PhpShortOpenTagInspection.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpShortOpenTagInspection.$$$reportNull$$$0(2);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpFile(PhpFile PhpFile2) {
                PhpShortOpenTagInspection.collectShortOpenTags((GroupStatement)ObjectUtils.tryCast((Object)PhpFile2.getFirstChild(), GroupStatement.class)).forEach(tag -> {
                    if (holder == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    holder.registerProblem(tag, "Short tag usage", new LocalQuickFix[]{QUICK_FIX});
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpShortOpenTagInspection$1", "lambda$visitPhpFile$0"));
            }
        };
        if (phpElementVisitor == null) {
            PhpShortOpenTagInspection.$$$reportNull$$$0(3);
        }
        return phpElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpShortOpenTagInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectShortOpenTags";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpShortOpenTagInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpReplaceShortTagWithPhpTagQuickFix
    implements LocalQuickFix {
        private static final String NAME = "Replace all occurrences with '<?php'";

        private PhpReplaceShortTagWithPhpTagQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if (NAME == null) {
                PhpReplaceShortTagWithPhpTagQuickFix.$$$reportNull$$$0(0);
            }
            return NAME;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Collection openTagsMarkers;
            if (project == null) {
                PhpReplaceShortTagWithPhpTagQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpReplaceShortTagWithPhpTagQuickFix.$$$reportNull$$$0(2);
            }
            PsiElement startElement = descriptor.getStartElement();
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(startElement.getContainingFile());
            if (document != null && !(openTagsMarkers = (Collection)PhpShortOpenTagInspection.collectShortOpenTags((GroupStatement)PsiTreeUtil.getParentOfType((PsiElement)startElement, GroupStatement.class)).stream().map(openTag -> document.createRangeMarker(openTag.getTextRange())).collect(Collectors.toList())).isEmpty()) {
                for (RangeMarker marker : openTagsMarkers) {
                    document.replaceString(marker.getStartOffset(), marker.getEndOffset(), (CharSequence)"<?php");
                }
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpShortOpenTagInspection$PhpReplaceShortTagWithPhpTagQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpShortOpenTagInspection$PhpReplaceShortTagWithPhpTagQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

