/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpAssignmentInConditionInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpAssignmentInConditionInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpIf(If ifStatement) {
                PhpAssignmentInConditionInspection.checkCondition(holder, (PsiElement)ifStatement.getCondition());
            }

            public void visitPhpElseIf(ElseIf elseIfStatement) {
                PhpAssignmentInConditionInspection.checkCondition(holder, (PsiElement)elseIfStatement.getCondition());
            }

            public void visitPhpTernaryExpression(TernaryExpression ternaryExpression) {
                PhpAssignmentInConditionInspection.checkCondition(holder, (PsiElement)ternaryExpression.getCondition());
            }

            public void visitPhpDoWhile(DoWhile doWhileStatement) {
                PhpAssignmentInConditionInspection.checkCondition(holder, (PsiElement)doWhileStatement.getCondition());
            }

            public void visitPhpWhile(While whileStatement) {
                PhpAssignmentInConditionInspection.checkCondition(holder, (PsiElement)whileStatement.getCondition());
            }

            public void visitPhpFor(For forStatement) {
                for (PhpPsiElement condition : forStatement.getConditionalExpressions()) {
                    PhpAssignmentInConditionInspection.checkCondition(holder, (PsiElement)condition);
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpAssignmentInConditionInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static void checkCondition(@NotNull ProblemsHolder holder, @Nullable PsiElement condition) {
        if (holder == null) {
            PhpAssignmentInConditionInspection.$$$reportNull$$$0(2);
        }
        if (condition instanceof AssignmentExpression) {
            holder.registerProblem(condition, PhpBundle.message("inspection.assignment.in.condition", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpAssignmentInConditionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpAssignmentInConditionInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkCondition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

