/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersStateListener;
import com.jetbrains.php.phpunit.PhpUnitBaseSettingsManager;
import com.jetbrains.php.phpunit.PhpUnitFrameworkType;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfigurationFactory;
import com.jetbrains.php.testFramework.PhpTestFrameworkStateListener;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitSettingsManager
implements PhpInterpretersStateListener {
    private final PhpUnitProjectSettingsManager myProjectManager;
    private final PhpUnitApplicationSettingsManager myApplicationManager = (PhpUnitApplicationSettingsManager)ServiceManager.getService(PhpUnitApplicationSettingsManager.class);

    public static PhpUnitSettingsManager getInstance(@Nullable Project project) {
        Project targetProject = project == null ? ProjectManager.getInstance().getDefaultProject() : project;
        return (PhpUnitSettingsManager)ServiceManager.getService((Project)targetProject, PhpUnitSettingsManager.class);
    }

    public PhpUnitSettingsManager(final @Nullable Project project) {
        if (project != null && !project.isDefault()) {
            this.myProjectManager = (PhpUnitProjectSettingsManager)ServiceManager.getService((Project)project, PhpUnitProjectSettingsManager.class);
            PhpTestFrameworkStateListener listener = new PhpTestFrameworkStateListener(){

                @Override
                public void onSettingsUpdate() {
                    PhpUnitSettingsManager.this.resolvePossibleCollisions(project);
                }
            };
            this.myProjectManager.addListener(project, listener);
            this.myApplicationManager.addListener(project, listener);
            this.resolvePossibleCollisions(project);
        } else {
            this.myProjectManager = null;
        }
    }

    private void resolvePossibleCollisions(@NotNull Project project) {
        if (project == null) {
            PhpUnitSettingsManager.$$$reportNull$$$0(0);
        }
        if (this.myProjectManager == null) {
            return;
        }
        boolean hasApplicationLevel = this.myProjectManager.getAllSettings().stream().anyMatch(settings -> !settings.isProjectLevel());
        if (!hasApplicationLevel) {
            boolean hasProjectLevel = this.myApplicationManager.getAllSettings().stream().anyMatch(PhpUnitSettings::isProjectLevel);
            if (hasProjectLevel) {
                this.setSettings(this.getAllSettings());
            }
            return;
        }
        SmartList newSettings = new SmartList();
        ArrayList<PhpUnitSettings> projectLevel = new ArrayList<PhpUnitSettings>();
        ArrayList<PhpUnitSettings> applicationLevel = new ArrayList<PhpUnitSettings>();
        for (PhpUnitSettings settings2 : this.myApplicationManager.getAllSettings()) {
            if (settings2.isProjectLevel()) {
                projectLevel.add(settings2);
                continue;
            }
            applicationLevel.add(settings2);
        }
        for (PhpUnitSettings settings2 : this.myProjectManager.getAllSettings()) {
            if (!settings2.isProjectLevel()) {
                PhpUnitSettings existingSetting = this.myApplicationManager.getSettingsByName(settings2.getPresentableName(project));
                if (existingSetting != null) {
                    PhpUnitSettings copySettings;
                    if (existingSetting.equals(settings2) || (copySettings = settings2.copyWithSettingsSource(project)) == null) continue;
                    newSettings.add(existingSetting.getPresentableName(project));
                    projectLevel.add(copySettings);
                    continue;
                }
                applicationLevel.add(settings2);
                continue;
            }
            projectLevel.add(settings2);
        }
        this.myApplicationManager.setSettings(applicationLevel);
        this.myProjectManager.setSettings(projectLevel);
        if (!newSettings.isEmpty()) {
            PhpUnitSettingsManager.showWarning(project, (List<String>)newSettings);
        }
    }

    @Override
    public void onInterpretersUpdate() {
        if (this.myProjectManager == null) {
            return;
        }
        this.resolvePossibleCollisions(this.myProjectManager.myProject);
    }

    private static void showWarning(@NotNull Project project, @NotNull List<String> newSettings) {
        if (project == null) {
            PhpUnitSettingsManager.$$$reportNull$$$0(1);
        }
        if (newSettings == null) {
            PhpUnitSettingsManager.$$$reportNull$$$0(2);
        }
        StringBuilder builder = new StringBuilder(PhpBundle.message("PhpUnitConfiguration.interpreter.conflict", new Object[0]));
        for (String name : newSettings) {
            builder.append("<br/><b>'").append(name).append("'</b>");
        }
        String title = PhpBundle.message("PhpUnitConfiguration.interpreter.conflict.title", new Object[0]);
        PhpUnitUtil.showWarningBalloon(project, title, builder.toString(), null);
    }

    @NotNull
    public List<PhpUnitSettings> getAllSettings() {
        ArrayList<PhpUnitSettings> result = new ArrayList<PhpUnitSettings>();
        if (this.myProjectManager != null) {
            result.addAll(this.myProjectManager.getAllSettings());
        }
        result.addAll(this.myApplicationManager.getAllSettings());
        ArrayList<PhpUnitSettings> arrayList = result;
        if (arrayList == null) {
            PhpUnitSettingsManager.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public void setSettings(@NotNull List<PhpUnitSettings> settings) {
        if (settings == null) {
            PhpUnitSettingsManager.$$$reportNull$$$0(4);
        }
        if (this.myProjectManager == null) {
            this.myApplicationManager.setSettings(settings);
            return;
        }
        ArrayList<PhpUnitSettings> applicationLevel = new ArrayList<PhpUnitSettings>();
        ArrayList<PhpUnitSettings> projectLevel = new ArrayList<PhpUnitSettings>();
        for (PhpUnitSettings phpunit : settings) {
            if (phpunit.isProjectLevel()) {
                projectLevel.add(phpunit);
                continue;
            }
            applicationLevel.add(phpunit);
        }
        this.myApplicationManager.setSettings(applicationLevel);
        this.myProjectManager.setSettings(projectLevel);
    }

    @Nullable
    public PhpUnitSettings getLocalSettings() {
        if (this.myProjectManager != null) {
            return this.myProjectManager.getLocalSettings();
        }
        return null;
    }

    @NotNull
    public PhpUnitSettings getOrCreateByInterpreter(@Nullable PhpInterpreter interpreter) {
        PhpUnitSettings settings = this.getSettingsByInterpreter(interpreter);
        if (settings != null) {
            PhpUnitSettings phpUnitSettings = settings;
            if (phpUnitSettings == null) {
                PhpUnitSettingsManager.$$$reportNull$$$0(5);
            }
            return phpUnitSettings;
        }
        List<PhpTestFrameworkConfigurationFactory> factories = PhpUnitFrameworkType.getInstance().getFactories();
        for (PhpTestFrameworkConfigurationFactory factory : factories) {
            Object config = factory.createByInterpreter(interpreter);
            if (!(config instanceof PhpUnitSettings)) continue;
            PhpUnitSettings newSettings = (PhpUnitSettings)config;
            List<PhpUnitSettings> allSettings = this.getAllSettings();
            allSettings.add(newSettings);
            this.setSettings(allSettings);
            PhpUnitSettings phpUnitSettings = newSettings;
            if (phpUnitSettings == null) {
                PhpUnitSettingsManager.$$$reportNull$$$0(6);
            }
            return phpUnitSettings;
        }
        assert (false);
        if (null == null) {
            PhpUnitSettingsManager.$$$reportNull$$$0(7);
        }
        return null;
    }

    @Nullable
    public PhpUnitSettings getSettingsByInterpreter(@Nullable PhpInterpreter interpreter) {
        if (interpreter == null || !interpreter.isRemote()) {
            return this.getLocalSettings();
        }
        return this.getSettingsByName("Interpreter: " + interpreter.getName());
    }

    @Nullable
    public PhpUnitSettings getSettingsByName(@Nullable String name) {
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        PhpUnitSettings phpunit = this.myApplicationManager.getSettingsByName(name);
        if (phpunit == null && this.myProjectManager != null) {
            phpunit = this.myProjectManager.getSettingsByName(name);
        }
        return phpunit;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSettings";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitSettingsManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitSettingsManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSettings";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateByInterpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolvePossibleCollisions";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showWarning";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @State(name="PhpUnit", storages={@Storage(value="php.xml")})
    private static class PhpUnitProjectSettingsManager
    extends PhpUnitBaseSettingsManager {
        public static PhpUnitProjectSettingsManager getInstance(@NotNull Project project) {
            if (project == null) {
                PhpUnitProjectSettingsManager.$$$reportNull$$$0(0);
            }
            return (PhpUnitProjectSettingsManager)ServiceManager.getService((Project)project, PhpUnitProjectSettingsManager.class);
        }

        PhpUnitProjectSettingsManager(@NotNull Project project) {
            if (project == null) {
                PhpUnitProjectSettingsManager.$$$reportNull$$$0(1);
            }
            super(project);
        }

        @Nullable
        public PhpUnitSettings getLocalSettings() {
            for (PhpUnitSettings setting : this.mySettings) {
                if (!setting.isLocal()) continue;
                return setting;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitSettingsManager$PhpUnitProjectSettingsManager";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getInstance";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @State(name="PhpUnit", storages={@Storage(value="php.xml")})
    public static class PhpUnitApplicationSettingsManager
    extends PhpUnitBaseSettingsManager {
        public static PhpUnitApplicationSettingsManager getInstance() {
            return (PhpUnitApplicationSettingsManager)ServiceManager.getService(PhpUnitApplicationSettingsManager.class);
        }
    }
}

