/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.namespace;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.refactoring.PhpBaseRefactoringProcessor;
import com.jetbrains.php.refactoring.PhpFileCreationInfo;
import com.jetbrains.php.refactoring.move.namespace.PhpMoveNamespaceDelegate;
import com.jetbrains.php.refactoring.move.namespace.PhpMoveNamespaceUsage;
import com.jetbrains.php.refactoring.move.namespace.PhpMoveNamespaceUsageSearcher;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMoveNamespaceProcessor
extends PhpBaseRefactoringProcessor {
    private final String myNewNamespaceName;
    private final Collection<PhpNamespace> myNamespaces;
    private final Map<String, PhpFileCreationInfo> myOldPathToNew;
    private final boolean mySearchInStringsAndComments;
    private final boolean mySearchForTextOccurrences;

    protected PhpMoveNamespaceProcessor(@NotNull Project project, @NotNull Collection<PhpNamespace> namespace, @NotNull String newNamespaceName, @NotNull Map<String, PhpFileCreationInfo> oldRelativePathToNew, boolean searchInStringsAndComments, boolean searchForTextOccurrences) {
        if (project == null) {
            PhpMoveNamespaceProcessor.$$$reportNull$$$0(0);
        }
        if (namespace == null) {
            PhpMoveNamespaceProcessor.$$$reportNull$$$0(1);
        }
        if (newNamespaceName == null) {
            PhpMoveNamespaceProcessor.$$$reportNull$$$0(2);
        }
        if (oldRelativePathToNew == null) {
            PhpMoveNamespaceProcessor.$$$reportNull$$$0(3);
        }
        super(project);
        this.myNamespaces = namespace;
        this.myNewNamespaceName = newNamespaceName;
        this.myOldPathToNew = oldRelativePathToNew;
        this.mySearchInStringsAndComments = searchInStringsAndComments;
        this.mySearchForTextOccurrences = searchForTextOccurrences;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            PhpMoveNamespaceProcessor.$$$reportNull$$$0(4);
        }
        UsageViewDescriptor usageViewDescriptor = new UsageViewDescriptor(){

            @NotNull
            public PsiElement[] getElements() {
                if (PsiElement.EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(0);
                }
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                return PhpBundle.message("refactoring.move.namespace.header.message", new Object[0]);
            }

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return PhpBundle.message("refactoring.move.namespace.message", new Object[0]);
            }

            @Nullable
            public String getCommentReferencesText(int usagesCount, int filesCount) {
                return PhpBundle.message("refactoring.move.namespace.in.non.code.message", new Object[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/refactoring/move/namespace/PhpMoveNamespaceProcessor$1", "getElements"));
            }
        };
        if (usageViewDescriptor == null) {
            PhpMoveNamespaceProcessor.$$$reportNull$$$0(5);
        }
        return usageViewDescriptor;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        UsageInfo[] usageInfoArray = PhpMoveNamespaceUsageSearcher.getInstance(this.myProject).findUsages(this.myNamespaces, this.myNewNamespaceName, this.myOldPathToNew, this.mySearchInStringsAndComments, this.mySearchForTextOccurrences);
        if (usageInfoArray == null) {
            PhpMoveNamespaceProcessor.$$$reportNull$$$0(6);
        }
        return usageInfoArray;
    }

    @Override
    protected void performMainRefactoring(UsageInfo[] usages) {
        THashSet affectedFiles = new THashSet();
        for (UsageInfo usage : usages) {
            if (usage instanceof PhpMoveNamespaceUsage) {
                ((PhpMoveNamespaceUsage)usage).performRefactoring();
                PsiFile file = usage.getFile();
                if (file == null || !file.isValid()) continue;
                affectedFiles.add(SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)file));
                continue;
            }
            if (!(usage instanceof NonCodeUsageInfo)) continue;
            this.myNonCodeUsageInfos.add((NonCodeUsageInfo)usage);
        }
        DumbService.getInstance((Project)this.myProject).completeJustSubmittedTasks();
        this.optimizeImports(ContainerUtil.mapNotNull((Collection)affectedFiles, p -> (PsiFile)p.getElement()));
    }

    @NotNull
    protected String getCommandName() {
        String string = PhpMoveNamespaceDelegate.REFACTORING_NAME;
        if (string == null) {
            PhpMoveNamespaceProcessor.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNamespaceName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRelativePathToNew";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/move/namespace/PhpMoveNamespaceProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/move/namespace/PhpMoveNamespaceProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

