/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.uml;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUmlUtil {
    private PhpUmlUtil() {
    }

    @Nullable
    public static String createInheritanceBetween(PhpClass child, PhpClass parent) throws IncorrectOperationException {
        if (PhpUmlUtil.isInheritor(parent, child) || PhpUmlUtil.isInheritor(child, parent)) {
            return PhpBundle.message("relationship.already.exists", child.getName(), parent.getName());
        }
        if (child.isFinal()) {
            return PhpBundle.message("final.class.cant.be.inherited", parent.getName());
        }
        ClassReference ref = PhpPsiElementFactory.createClassReference(child.getProject(), parent.getName());
        if (parent.isInterface()) {
            if (child.isInterface()) {
                ExtendsList list = child.getExtendsList();
                list.add((PsiElement)ref);
            } else {
                ImplementsList list = child.getImplementsList();
                list.add((PsiElement)ref);
            }
        } else {
            if (child.isInterface()) {
                return PhpBundle.message("node.is.interface", new Object[0]);
            }
            PhpClass superClass = child.getSuperClass();
            if (superClass != null) {
                ExtendsList extendsList = child.getExtendsList();
                List elements = extendsList.getReferenceElements();
                if (elements.size() >= 1) {
                    ((ClassReference)elements.get(0)).replace((PsiElement)ref);
                } else {
                    extendsList.replace(PhpPsiElementFactory.createExtendsList(child.getProject(), parent.getFQN()));
                }
            }
        }
        return null;
    }

    private static boolean isInheritor(PhpClass parent, PhpClass child) {
        if (parent == child) {
            return false;
        }
        Ref result = new Ref((Object)false);
        PhpClassHierarchyUtils.processSuperClasses((PhpClass)child, (boolean)false, (boolean)true, aClass -> {
            if (aClass.isEquivalentTo((PsiElement)parent)) {
                result.set((Object)true);
                return false;
            }
            return true;
        });
        return (Boolean)result.get();
    }

    @Nullable
    public static String getFQN(@NotNull PsiElement element) {
        if (element == null) {
            PhpUmlUtil.$$$reportNull$$$0(0);
        }
        if (element instanceof PhpClass) {
            return ((PhpClass)element).getFQN();
        }
        if (element instanceof PsiDirectory) {
            return ((PsiDirectory)element).getVirtualFile().getPath();
        }
        return null;
    }

    public static PsiDirectory getDirectory(PsiElement element) {
        return element.getContainingFile().getParent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/uml/PhpUmlUtil", "getFQN"));
    }
}

