/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Trinity;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;

public class SyncLoadComponent {
    @NotNull
    private final Project myProject;
    private final PublishConfig myPublishConfig;
    private final Deployable myServer;
    private final LinkedList<Trinity<TransferOperation, Boolean, String>> myToServerQueue;
    private ProgressIndicator myToServerProgressIndicator;

    public SyncLoadComponent(@NotNull Project project, PublishConfig publishConfig, Deployable server) {
        if (project == null) {
            SyncLoadComponent.$$$reportNull$$$0(0);
        }
        this.myToServerQueue = new LinkedList();
        this.myPublishConfig = publishConfig;
        this.myServer = server;
        this.myProject = project;
    }

    public synchronized void offerTransferOperation(TransferOperation e, boolean onServer) {
        this.myToServerQueue.offer((Trinity<TransferOperation, Boolean, String>)new Trinity((Object)e, (Object)onServer, null));
        this.ensureTaskRunning();
    }

    public synchronized void reportSkipping(@NotNull String message) {
        if (message == null) {
            SyncLoadComponent.$$$reportNull$$$0(1);
        }
        this.myToServerQueue.offer((Trinity<TransferOperation, Boolean, String>)new Trinity(null, null, (Object)message));
        this.ensureTaskRunning();
    }

    private void ensureTaskRunning() {
        if (!this.myToServerQueue.isEmpty() && this.myToServerProgressIndicator == null) {
            String title = WDBundle.message("synchronization.task.title", new Object[0]);
            FileTransferToolWindow.printWithTimestamp(this.myProject, this.myServer, title, ConsoleViewContentType.SYSTEM_OUTPUT, this.myPublishConfig.getTraceLevel());
            new TransferTask(this.myProject, ConnectionOwnerFactory.createConnectionOwner(this.myProject), false, this.myPublishConfig, this.myServer, title, false, true, true, ProjectDeploymentRevisionTracker.getInstance(this.myProject)){
                private int myProcessed;
                private boolean myCurrentIsServerSideModification;
                {
                    this.myProcessed = 0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected boolean isServerSideModification() {
                    SyncLoadComponent syncLoadComponent = SyncLoadComponent.this;
                    synchronized (syncLoadComponent) {
                        return this.myCurrentIsServerSideModification;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run(@NotNull ProgressIndicator pi) {
                    ArrayList operations;
                    if (pi == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    SyncLoadComponent syncLoadComponent = SyncLoadComponent.this;
                    synchronized (syncLoadComponent) {
                        if (SyncLoadComponent.this.myToServerProgressIndicator != null) {
                            return;
                        }
                        SyncLoadComponent.this.myToServerProgressIndicator = pi;
                        operations = new ArrayList(SyncLoadComponent.this.myToServerQueue);
                    }
                    try {
                        this.doRun(pi);
                    }
                    finally {
                        syncLoadComponent = SyncLoadComponent.this;
                        synchronized (syncLoadComponent) {
                            SyncLoadComponent.this.myToServerQueue.removeAll(operations);
                            SyncLoadComponent.this.myToServerProgressIndicator = null;
                        }
                    }
                }

                @Override
                protected boolean isMultipleOperations() {
                    return true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected boolean prepareOperations(ExecutionContext context) throws FileSystemException {
                    SyncLoadComponent syncLoadComponent = SyncLoadComponent.this;
                    synchronized (syncLoadComponent) {
                        for (Trinity pair : SyncLoadComponent.this.myToServerQueue) {
                            if (pair.getThird() == null) continue;
                            context.incCounter("transfer.details.excluded");
                        }
                    }
                    return true;
                }

                @Override
                protected TransferOperation getNextOperation() {
                    SyncLoadComponent syncLoadComponent = SyncLoadComponent.this;
                    synchronized (syncLoadComponent) {
                        Trinity info;
                        while (true) {
                            if ((info = (Trinity)SyncLoadComponent.this.myToServerQueue.poll()) == null) {
                                return null;
                            }
                            if (info.getFirst() != null) break;
                            this.print((String)info.getThird(), ConsoleViewContentType.NORMAL_OUTPUT);
                        }
                        ++this.myProcessed;
                        this.myCurrentIsServerSideModification = (Boolean)info.getSecond();
                        return (TransferOperation)info.getFirst();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected int getDoneStepsNumber() {
                    SyncLoadComponent syncLoadComponent = SyncLoadComponent.this;
                    synchronized (syncLoadComponent) {
                        return this.myProcessed - 1;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected int getTotalStepsNumber() {
                    SyncLoadComponent syncLoadComponent = SyncLoadComponent.this;
                    synchronized (syncLoadComponent) {
                        return this.myProcessed + SyncLoadComponent.this.myToServerQueue.size();
                    }
                }

                @Override
                protected void assertAllExecuted(int totalProcessed, int failed) {
                }

                @Override
                protected void showBalloon(MessageType type, String text, boolean isSummary) {
                    if (isSummary ? type != MessageType.INFO : type == MessageType.ERROR) {
                        super.showBalloon(type, text, isSummary);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/webDeployment/ui/SyncLoadComponent$1", "run"));
                }
            }.queue();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/SyncLoadComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "reportSkipping";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

