/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentStatus;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerUtil;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.registry.DockerAgentRepositoryConfigImpl;
import com.intellij.docker.registry.DockerRepositoryModel;
import com.intellij.docker.registry.RegistryRuntimeTask;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.DockerParentRuntime;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentImpl;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.Consumer;
import com.intellij.util.ParameterizedRunnable;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.execution.ParametersListUtil;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerApplicationRuntime
extends CloudApplicationRuntime {
    private static final Logger LOG = Logger.getInstance(DockerApplicationRuntime.class);
    private final DockerRuntimeContext myContext;
    private final AtomicBoolean myStatusChangedInternally;
    private DockerParentRuntime myParent;
    private DockerAgentApplication myAgentApplication;
    private String[] myContainerNames;
    private String myImageId;
    private DockerDeploymentStatus myStatusWithCustomText;
    private Set<String> myImageRepoTags;
    private String myImageParentId;
    private String myContainerId;

    public DockerApplicationRuntime(@NotNull DockerRuntimeContext context, @NotNull String uniqueName, @Nullable DockerParentRuntime parent) {
        if (context == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(0);
        }
        if (uniqueName == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(1);
        }
        super(uniqueName);
        this.myStatusChangedInternally = new AtomicBoolean();
        this.myContext = context;
        this.setParent(parent);
    }

    public DockerAgent getAgent() {
        return this.getRuntimeContext().getAgent();
    }

    @NotNull
    final DockerRuntimeContext getRuntimeContext() {
        DockerRuntimeContext dockerRuntimeContext = this.myContext;
        if (dockerRuntimeContext == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(2);
        }
        return dockerRuntimeContext;
    }

    @NotNull
    protected DockerCloudConfiguration getServerConfiguration() {
        DockerCloudConfiguration dockerCloudConfiguration = this.myContext.getServerConfiguration();
        if (dockerCloudConfiguration == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(3);
        }
        return dockerCloudConfiguration;
    }

    protected ServerTaskExecutor getTaskExecutor() {
        return this.myContext.getServerExecutor();
    }

    protected AgentTaskExecutor getAgentTaskExecutor() {
        return this.myContext.getAgentExecutor();
    }

    @Nullable
    public DeploymentLogManager getDeploymentLogManager(@NotNull Project project) {
        Deployment deployment;
        if (project == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(4);
        }
        return (deployment = this.getDeploymentModel()) == null ? null : deployment.getOrCreateLogManager(project);
    }

    protected ServerType<?> getCloudType() {
        return DockerCloudType.getInstance();
    }

    void setApplication(DockerAgentApplication agentApplication) {
        this.myAgentApplication = agentApplication;
        this.myContainerId = agentApplication.getContainerId();
        this.myContainerNames = agentApplication.getContainerNames();
        this.myImageId = agentApplication.getImageId();
        this.myImageParentId = agentApplication.getImageParentId();
        if (this.myContainerId != null) {
            String statusText = agentApplication.getContainerStatus();
            this.myStatusWithCustomText = DockerDeploymentStatus.newContainerStatus(statusText);
        } else {
            this.myStatusWithCustomText = DockerDeploymentStatus.newImageStatus();
            this.myImageRepoTags = new HashSet();
            this.myImageRepoTags.addAll(Arrays.asList(agentApplication.getImageRepoTags()));
        }
        this.checkAndClearInternalChangeStatus();
        this.setupDeploymentPresentableName();
    }

    public String getContainerId() {
        return this.myAgentApplication != null ? this.myContainerId : null;
    }

    @Nullable
    public String[] getContainerNames() {
        return this.myContainerNames;
    }

    public String getContainerName() {
        return this.myContainerNames == null || this.myContainerNames.length == 0 ? null : new TreeSet<String>(Arrays.asList(this.myContainerNames)).first();
    }

    public void setDeploymentModel(@NotNull Deployment deployment) {
        if (deployment == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(5);
        }
        super.setDeploymentModel(deployment);
        this.setupDeploymentPresentableName();
    }

    protected void setupDeploymentPresentableName() {
        if (this.myAgentApplication == null) {
            return;
        }
        Deployment deployment = this.getDeploymentModel();
        if (deployment instanceof DeploymentImpl) {
            ((DeploymentImpl)deployment).setPresentableName(this.myAgentApplication.getPresentableName());
        }
    }

    public String getImageId() {
        return this.myImageId;
    }

    public Set<String> getImageRepoTags() {
        return this.myImageRepoTags;
    }

    public String getImageParentId() {
        return this.myImageParentId;
    }

    @Nullable
    public DeploymentStatus getStatus() {
        return this.myStatusWithCustomText == null ? null : this.myStatusWithCustomText.getStatus();
    }

    boolean checkAndClearInternalChangeStatus() {
        return this.myStatusChangedInternally.getAndSet(false);
    }

    private void internalChangeStatus(@Nullable DockerDeploymentStatus newStatus) {
        if (newStatus != null) {
            this.myStatusWithCustomText = newStatus;
            this.myStatusChangedInternally.set(true);
        }
        this.myStatusWithCustomText.apply(this.getDeploymentModel());
    }

    @Nullable
    public String getStatusText() {
        return this.myStatusWithCustomText == null ? null : this.myStatusWithCustomText.getCustomText();
    }

    @Nullable
    public CloudApplicationRuntime getParent() {
        return this.myParent == null ? null : this.myParent.asDockerRuntime();
    }

    @Nullable
    public Navigatable computeNavigatable(@NotNull Project project) {
        if (project == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(6);
        }
        if (this.getContainerId() != null && this.getParent() instanceof ComposeServiceRuntime) {
            return ((ComposeServiceRuntime)this.getParent()).computeNavigatable(project);
        }
        return null;
    }

    public void setParent(@Nullable DockerParentRuntime parent) {
        if (this.myParent != null) {
            this.myParent.childRemoved(this);
        }
        this.myParent = parent;
        if (this.myParent != null) {
            this.myParent.childAdded(this);
        }
    }

    public void startContainer() {
        new StatusChangingTask(){

            @Override
            protected void doAgentTask() {
                DockerApplicationRuntime.this.myAgentApplication.startContainer();
            }
        }.run(DockerDeploymentStatus.STARTING, DockerDeploymentStatus.STARTED);
    }

    public void stopContainer() {
        new StatusChangingTask(){

            @Override
            protected void doAgentTask() {
                DockerApplicationRuntime.this.myAgentApplication.stopContainer();
            }
        }.run(DockerDeploymentStatus.STOPPING, DockerDeploymentStatus.STOPPED);
    }

    public void deleteContainer() {
        StatusChangingTask deleteTask = new StatusChangingTask(){

            @Override
            protected void doAgentTask() {
                DockerApplicationRuntime.this.myAgentApplication.deleteContainer();
            }
        };
        deleteTask.run(DockerDeploymentStatus.DELETING, DockerDeploymentStatus.DELETED).thenRun(() -> ((DeploymentImpl)this.getDeploymentModel()).disposeAllLogs());
    }

    public void showLog(Project project, Runnable onDone) {
        new CloudApplicationRuntime.LoggingTask(){

            protected void run(CloudAgentLoggingHandler loggingHandler) {
                DockerApplicationRuntime.this.myAgentApplication.showLog(loggingHandler);
            }
        }.perform(project, onDone);
    }

    public CompletableFuture<String> promiseInspectJson() {
        return this.makeAgentPromise(() -> ((DockerAgentApplication)this.myAgentApplication).computeInspectJson());
    }

    public CompletableFuture<String> promiseProcessesJson() {
        return this.makeAgentPromise(() -> ((DockerAgentApplication)this.myAgentApplication).computeProcessesJson());
    }

    private <T> CompletableFuture<T> makeAgentPromise(@NotNull Computable<T> agentComputable) {
        if (agentComputable == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(7);
        }
        CompletableFuture result = new CompletableFuture();
        this.getTaskExecutor().submit(() -> {
            if (agentComputable == null) {
                DockerApplicationRuntime.$$$reportNull$$$0(9);
            }
            try {
                Object agentResult = this.getAgentTaskExecutor().execute(agentComputable);
                result.complete(agentResult);
            }
            catch (ServerRuntimeException e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    public void inspect(ParameterizedRunnable<DockerAgentContainerConfig> onInspected) {
        this.getTaskExecutor().submit(() -> {
            try {
                DockerAgentContainerConfig config = (DockerAgentContainerConfig)this.getAgentTaskExecutor().execute(() -> this.myAgentApplication.inspect());
                onInspected.run((Object)config);
            }
            catch (ServerRuntimeException e) {
                this.getCloudNotifier().showMessage(e.getMessage(), MessageType.ERROR);
            }
        });
    }

    public void attach(Project project, Runnable onDone) {
        new CloudApplicationRuntime.LoggingTask(){

            protected void run(CloudAgentLoggingHandler loggingHandler) {
                DockerApplicationRuntime.this.myAgentApplication.attach(loggingHandler);
            }
        }.perform(project, onDone);
    }

    public void exec(Project project, final String command, final String logName, Runnable onDone) {
        new CloudApplicationRuntime.LoggingTask(){

            protected void run(CloudAgentLoggingHandler loggingHandler) {
                DockerApplicationRuntime.this.myAgentApplication.exec(loggingHandler, ParametersListUtil.parseToArray((String)command), logName);
            }
        }.perform(project, onDone);
    }

    public void deleteImage() {
        new StatusChangingTask(){

            @Override
            protected void doAgentTask() {
                DockerApplicationRuntime.this.myAgentApplication.deleteImage();
            }
        }.run(DockerDeploymentStatus.DELETING, DockerDeploymentStatus.DELETED);
    }

    public void createContainer(Consumer<String> containerIdConsumer) {
        this.getTaskExecutor().submit(() -> {
            try {
                String containerId = (String)this.getAgentTaskExecutor().execute(() -> this.myAgentApplication.createContainer());
                containerIdConsumer.consume((Object)containerId);
            }
            catch (ServerRuntimeException e) {
                this.getCloudNotifier().showMessage(e.getMessage(), MessageType.ERROR);
            }
        });
    }

    public boolean isUndeploySupported() {
        return false;
    }

    public void undeploy(@NotNull DeploymentRuntime.UndeploymentTaskCallback callback) {
        if (callback == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(8);
        }
        throw new UnsupportedOperationException();
    }

    public void pushImage(Project project, DockerRepositoryModel repositoryModel) {
        final DockerAgentRepositoryConfigImpl repositoryConfig = new DockerAgentRepositoryConfigImpl(repositoryModel);
        String qualifiedReference = repositoryConfig.getQualifiedTag();
        new RegistryRuntimeTask(){

            @Override
            protected OngoingProcess doPerform(DockerAgentProgressCallback progressCallback) {
                return DockerApplicationRuntime.this.myAgentApplication.pushImage(repositoryConfig, progressCallback);
            }
        }.performAsyncWithNotification(project, this.getTaskExecutor(), this.getAgentTaskExecutor(), "Pushing " + qualifiedReference, qualifiedReference + " pushed successfully");
    }

    public void updateContainer(DockerAgentContainerConfig config, Runnable onDone) {
        this.getTaskExecutor().submit(() -> {
            try {
                DockerAgentApplication.ContainerUpdateResult updateResult = (DockerAgentApplication.ContainerUpdateResult)this.getAgentTaskExecutor().execute(() -> this.myAgentApplication.updateContainer(config));
                this.handleContainerUpdateResult(updateResult);
                onDone.run();
            }
            catch (ServerRuntimeException e) {
                this.getCloudNotifier().showMessage(e.getMessage(), MessageType.ERROR);
            }
        });
    }

    protected final void handleContainerUpdateResult(@Nullable DockerAgentApplication.ContainerUpdateResult updateResult) {
        if (updateResult == null) {
            return;
        }
        String oldId = updateResult.getRemovedContainerId();
        String newId = updateResult.getCreatedContainerId();
        if (!StringUtil.equals((CharSequence)oldId, (CharSequence)this.getContainerId())) {
            return;
        }
        DockerAgentApplication newAgentApp = updateResult.getCreatedAgentApplication();
        if (newAgentApp != null && oldId != null && newId != null && !newId.equals(oldId)) {
            this.setApplication(newAgentApp);
        }
    }

    public String toString() {
        String hash = Optional.ofNullable(this.getApplicationName()).map(DockerUtil::shortedId).orElse(null);
        return "@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + " id: " + hash + ", " + (this.myContainerId == null ? "[IMG]: " + this.getImageRepoTags() : "[CNT]: " + Arrays.toString(this.getContainerNames()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uniqueName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/runtimes/DockerApplicationRuntime";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployment";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentComputable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/runtimes/DockerApplicationRuntime";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDeploymentLogManager";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setDeploymentModel";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeNavigatable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "makeAgentPromise";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "undeploy";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$makeAgentPromise$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private abstract class StatusChangingTask
    extends StatusChangingAgentComputable<Void> {
        private StatusChangingTask() {
        }

        @Override
        public CompletableFuture<Void> run(DockerDeploymentStatus transitionStatus, DockerDeploymentStatus targetStatus) {
            CompletableFuture mayFail = super.run(transitionStatus, targetStatus);
            return mayFail.exceptionally(e -> {
                DockerApplicationRuntime.this.getCloudNotifier().showMessage(e.getMessage(), MessageType.ERROR);
                return null;
            });
        }

        @Override
        protected Void computeOnAgent() {
            this.doAgentTask();
            return null;
        }

        protected abstract void doAgentTask();
    }

    private abstract class StatusChangingAgentComputable<T> {
        private StatusChangingAgentComputable() {
        }

        public CompletableFuture<T> run(DockerDeploymentStatus transitionStatus, DockerDeploymentStatus targetStatus) {
            transitionStatus.apply(DockerApplicationRuntime.this.getDeploymentModel());
            CompletableFuture result = DockerApplicationRuntime.this.makeAgentPromise(this::computeOnAgent);
            return result.whenComplete((agentResult, failure) -> DockerApplicationRuntime.this.internalChangeStatus(targetStatus));
        }

        protected abstract T computeOnAgent();
    }
}

