/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.settings;

import com.intellij.docker.agent.settings.DockerLinkImpl;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerLinkConfigurable
implements Configurable {
    private JPanel myMainPanel;
    private JComboBox myNameComboBox;
    private JTextField myAliasTextField;
    private JBLabel myLoadStatusLabel;
    private final DockerLinkImpl myLink;
    private final RemoteServer myServer;
    private final SortedComboBoxModel<String> myNameComboBoxModel;
    private boolean myDisposed = false;

    public DockerLinkConfigurable(DockerLinkImpl link, RemoteServer server) {
        this.myLink = link;
        this.myServer = server;
        this.$$$setupUI$$$();
        this.myNameComboBoxModel = new SortedComboBoxModel(String.CASE_INSENSITIVE_ORDER);
        this.myNameComboBox.setModel(this.myNameComboBoxModel);
    }

    @Nls
    public String getDisplayName() {
        return "Links";
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        return true;
    }

    public void apply() throws ConfigurationException {
        String name = this.myNameComboBox.getSelectedItem().toString();
        if (StringUtil.isEmpty((String)name)) {
            throw new ConfigurationException("Name required");
        }
        this.myLink.setName(name);
        this.myLink.setAlias(StringUtil.nullize((String)this.myAliasTextField.getText()));
    }

    public void reset() {
        this.myNameComboBox.setSelectedItem(this.myLink.getName());
        this.myAliasTextField.setText(this.myLink.getAlias());
        new ContainerNamesLoader().run();
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.docker.deploy.links";
    }

    public void disposeUIResources() {
        this.myDisposed = true;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JTextField jTextField;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Name:");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myNameComboBox = jComboBox = new JComboBox();
        jComboBox.setEditable(true);
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Alias:");
        jPanel.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAliasTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myLoadStatusLabel = jBLabel = new JBLabel();
        jBLabel.setText("");
        jPanel.add((Component)jBLabel, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        jBLabel2.setLabelFor(jComboBox);
        jBLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private class ContainerNamesLoader {
        private ContainerNamesLoader() {
        }

        public void run() {
            if (DockerLinkConfigurable.this.myServer == null) {
                return;
            }
            this.setStatus("Loading container names...");
            final ServerConnection connection = ServerConnectionManager.getInstance().createTemporaryConnection(DockerLinkConfigurable.this.myServer);
            final AtomicReference<Object> deploymentsRef = new AtomicReference<Object>(null);
            final Semaphore semaphore = new Semaphore();
            semaphore.down();
            connection.connectIfNeeded(new ServerConnector.ConnectionCallback(){

                public void connected(@NotNull ServerRuntimeInstance serverRuntimeInstance) {
                    if (serverRuntimeInstance == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    connection.computeDeployments(() -> {
                        deploymentsRef.set(connection.getDeployments());
                        semaphore.up();
                        connection.disconnect();
                    });
                }

                public void errorOccurred(@NotNull String errorMessage) {
                    if (errorMessage == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    semaphore.up();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "serverRuntimeInstance";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorMessage";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/docker/settings/DockerLinkConfigurable$ContainerNamesLoader$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "connected";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "errorOccurred";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            new Task.Backgroundable(null, "Loading container names...", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    indicator.setIndeterminate(true);
                    while (!indicator.isCanceled() && !semaphore.waitFor(500L)) {
                    }
                    UIUtil.invokeLaterIfNeeded(() -> ContainerNamesLoader.this.finished((Collection)deploymentsRef.get()));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/docker/settings/DockerLinkConfigurable$ContainerNamesLoader$2", "run"));
                }
            }.queue();
        }

        private void finished(Collection<Deployment> deployments) {
            if (DockerLinkConfigurable.this.myDisposed) {
                return;
            }
            this.setStatus("");
            if (deployments == null) {
                return;
            }
            String selectedItem = (String)DockerLinkConfigurable.this.myNameComboBoxModel.getSelectedItem();
            DockerLinkConfigurable.this.myNameComboBoxModel.clear();
            for (Deployment deployment : deployments) {
                String name;
                DockerApplicationRuntime deploymentRuntime = (DockerApplicationRuntime)((Object)ObjectUtils.tryCast((Object)deployment.getRuntime(), DockerApplicationRuntime.class));
                if (deploymentRuntime == null || (name = deploymentRuntime.getContainerName()) == null) continue;
                DockerLinkConfigurable.this.myNameComboBoxModel.add(ContainerUtil.getLastItem((List)StringUtil.split((String)name, (String)"/")));
            }
            if (!StringUtil.isEmpty((String)selectedItem)) {
                DockerLinkConfigurable.this.myNameComboBoxModel.setSelectedItem((Object)selectedItem);
            }
        }

        private void setStatus(String status) {
            DockerLinkConfigurable.this.myLoadStatusLabel.setText(status);
        }
    }
}

