/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.ProjectEntityContainer;
import net.sf.mpxj.ProjectEntityWithID;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.common.NumberHelper;

public abstract class ProjectEntityWithIDContainer<T extends ProjectEntityWithID & Comparable<T>>
extends ProjectEntityContainer<T> {
    protected Map<Integer, T> m_idMap = new HashMap<Integer, T>();

    public ProjectEntityWithIDContainer(ProjectFile projectFile) {
        super(projectFile);
    }

    public void renumberIDs() {
        if (!this.isEmpty()) {
            Collections.sort(this);
            ProjectEntityWithID projectEntityWithID = (ProjectEntityWithID)this.get(0);
            int n = NumberHelper.getInt(projectEntityWithID.getID());
            if (n != 0) {
                n = 1;
            }
            for (ProjectEntityWithID projectEntityWithID2 : this) {
                projectEntityWithID2.setID(n++);
            }
        }
    }

    public T getByID(Integer n) {
        return (T)((ProjectEntityWithID)this.m_idMap.get(n));
    }

    public void unmapID(Integer n) {
        this.m_idMap.remove(n);
    }

    public void mapID(Integer n, T t) {
        this.m_idMap.put(n, t);
    }
}

