/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqbody;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.wiztools.commons.Charsets;
import org.wiztools.commons.FileUtil;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.bean.ReqEntity;
import org.wiztools.restclient.bean.ReqEntityString;
import org.wiztools.restclient.bean.ReqEntityStringBean;
import org.wiztools.restclient.ui.FileChooserType;
import org.wiztools.restclient.ui.FontableEditor;
import org.wiztools.restclient.ui.RESTUserInterface;
import org.wiztools.restclient.ui.RESTView;
import org.wiztools.restclient.ui.ScriptEditor;
import org.wiztools.restclient.ui.ScriptEditorFactory;
import org.wiztools.restclient.ui.UIUtil;
import org.wiztools.restclient.ui.component.BodyPopupMenu;
import org.wiztools.restclient.ui.component.BodyPopupMenuListener;
import org.wiztools.restclient.ui.dnd.FileDropTargetListener;
import org.wiztools.restclient.ui.reqbody.BodyContentTypeDialog;
import org.wiztools.restclient.ui.reqbody.ContentTypeCharsetComponent;
import org.wiztools.restclient.ui.reqbody.ParameterDialog;
import org.wiztools.restclient.ui.reqbody.ReqBodyPanel;
import org.wiztools.restclient.util.HttpUtil;

class ReqBodyPanelString
extends JPanel
implements ReqBodyPanel,
FontableEditor {
    @Inject
    RESTView view;
    @Inject
    RESTUserInterface rest_ui;
    @Inject
    private ContentTypeCharsetComponent jp_content_type_charset;
    @Inject
    private ParameterDialog jd_req_paramDialog;
    private final ScriptEditor se_req_body = ScriptEditorFactory.getXMLScriptEditor();
    private final JButton jb_body_file = new JButton(UIUtil.getIconFromClasspath("org/wiztools/restclient/load_from_file.png"));
    private final JButton jb_body_params = new JButton(UIUtil.getIconFromClasspath("org/wiztools/restclient/insert_parameters.png"));

    ReqBodyPanelString() {
    }

    @PostConstruct
    protected void init() {
        this.jd_req_paramDialog.addParameterGenerationListener(params -> this.se_req_body.setText(params));
        this.setLayout(new BorderLayout());
        JPanel jp_north = new JPanel(new FlowLayout(0));
        jp_north.add(this.jp_content_type_charset.getComponent());
        this.jb_body_file.setToolTipText("Load from file");
        this.jb_body_file.addActionListener(ae -> this.loadFile());
        jp_north.add(this.jb_body_file);
        this.jb_body_params.setToolTipText("Insert parameters");
        this.jb_body_params.addActionListener(ae -> {
            FormEnc openFrmEncDialg = this.openFrmEncDialg();
            switch (openFrmEncDialg) {
                case OPEN_EMPTY: 
                case ERASE: 
                case LOAD: {
                    this.checkAndSetParameterContentType();
                    break;
                }
                case CANCEL: {
                    return;
                }
            }
            switch (openFrmEncDialg) {
                case LOAD: {
                    this.jd_req_paramDialog.setData(HttpUtil.getXWwwFormUrlEncoded2Map(this.se_req_body.getText()));
                }
            }
            this.jd_req_paramDialog.setLocationRelativeTo(this.rest_ui.getFrame());
            this.jd_req_paramDialog.setVisible(true);
        });
        jp_north.add(this.jb_body_params);
        this.add((Component)jp_north, "North");
        BodyPopupMenuListener listener = new BodyPopupMenuListener(){

            @Override
            public void onSuccess(String msg) {
                ReqBodyPanelString.this.view.setStatusMessage(msg);
            }

            @Override
            public void onFailure(String msg) {
                ReqBodyPanelString.this.view.setStatusMessage(msg);
            }

            @Override
            public void onMessage(String msg) {
                ReqBodyPanelString.this.view.setStatusMessage(msg);
            }
        };
        final BodyPopupMenu bpm = new BodyPopupMenu(this.se_req_body, listener, false);
        this.se_req_body.setPopupMenu(bpm);
        this.se_req_body.getEditorComponent().addMouseListener(new MouseAdapter(){

            private void eEnable() {
                if (ReqBodyPanelString.this.se_req_body.getEditorComponent().isEnabled()) {
                    Component[] components;
                    for (Component c : components = bpm.getComponents()) {
                        if (c.isEnabled()) continue;
                        c.setEnabled(true);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.eEnable();
            }
        });
        this.add((Component)this.se_req_body.getEditorView(), "Center");
        FileDropTargetListener l = new FileDropTargetListener();
        l.addDndAction(files -> this.loadFile((File)files.get(0)));
        new DropTarget(this.jb_body_file, l);
        new DropTarget(this.se_req_body.getEditorView(), l);
    }

    private void loadFile() {
        File f = this.rest_ui.getOpenFile(FileChooserType.OPEN_REQUEST_BODY);
        this.loadFile(f);
    }

    private void loadFile(File f) {
        if (f == null) {
            return;
        }
        if (!f.canRead()) {
            JOptionPane.showMessageDialog(this.rest_ui.getFrame(), "File not readable: " + f.getAbsolutePath(), "IO Error", 0);
            return;
        }
        try {
            String body = FileUtil.getContentAsString(f, Charsets.UTF_8);
            this.se_req_body.setText(body);
            this.se_req_body.setCaretPosition(0);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.rest_ui.getFrame(), "IO Error: " + ex.getMessage(), "IO Error", 0);
        }
    }

    private FormEnc openFrmEncDialg() {
        if (StringUtil.isEmpty(this.se_req_body.getText())) {
            return FormEnc.OPEN_EMPTY;
        }
        int response = JOptionPane.showConfirmDialog(this.rest_ui.getFrame(), "<html>Body text exists. Load for editing?<ol><li><b>Yes</b>: load, but silent on failures.</li><li><b>No</b>: start empty, existing boby will be erased.</li><li><b>Cancel</b>: cancel.</li></html>", "Load for editing?", 1);
        if (response == 0) {
            return FormEnc.LOAD;
        }
        if (response == 1) {
            return FormEnc.ERASE;
        }
        return FormEnc.CANCEL;
    }

    private void checkAndSetParameterContentType() {
        int status;
        if (!BodyContentTypeDialog.PARAM_CONTENT_TYPE.equals(this.jp_content_type_charset.getContentType()) && (status = JOptionPane.showConfirmDialog(this.rest_ui.getFrame(), "<html>For parameter the Content-type and Charset needs <br>to be `" + BodyContentTypeDialog.PARAM_CONTENT_TYPE + "' and `" + BodyContentTypeDialog.PARAM_CHARSET + "' respectively.<br>Do you want to set this option?</html>", "Parameter Content-type and Charset", 0)) == 0) {
            this.jp_content_type_charset.setContentTypeCharset(BodyContentTypeDialog.PARAM_CONTENT_TYPE);
        }
    }

    @Override
    public void enableBody() {
        this.jp_content_type_charset.enableComponent();
        this.jb_body_file.setEnabled(true);
        this.jb_body_params.setEnabled(true);
        this.se_req_body.setEnabled(true);
    }

    @Override
    public void disableBody() {
        this.jp_content_type_charset.disableComponent();
        this.jb_body_file.setEnabled(false);
        this.jb_body_params.setEnabled(false);
        this.se_req_body.setEnabled(false);
    }

    @Override
    public void clear() {
        this.jp_content_type_charset.clear();
    }

    @Override
    public void setEntity(ReqEntity entity) {
        if (entity instanceof ReqEntityString) {
            ReqEntityString bean = (ReqEntityString)entity;
            this.jp_content_type_charset.setContentTypeCharset(bean.getContentType());
            this.se_req_body.setText(bean.getBody());
        }
    }

    @Override
    public ReqEntity getEntity() {
        String body = this.se_req_body.getText();
        ReqEntityStringBean entity = new ReqEntityStringBean(body, this.jp_content_type_charset.getContentType());
        return entity;
    }

    @Override
    public void requestFocus() {
        this.se_req_body.getEditorComponent().requestFocus();
    }

    @Override
    public void setEditorFont(Font font) {
        this.se_req_body.getEditorComponent().setFont(font);
    }

    @Override
    public Font getEditorFont() {
        return this.se_req_body.getEditorComponent().getFont();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    private static enum FormEnc {
        ERASE,
        LOAD,
        OPEN_EMPTY,
        CANCEL;

    }
}

