/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.login;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AppConfigurationEntry {
    private final String loginModuleName;
    private final LoginModuleControlFlag controlFlag;
    private final Map options;

    public LoginModuleControlFlag getControlFlag() {
        return this.controlFlag;
    }

    public String getLoginModuleName() {
        return this.loginModuleName;
    }

    public Map getOptions() {
        return this.options;
    }

    public AppConfigurationEntry(String loginModuleName, LoginModuleControlFlag controlFlag, Map options) {
        if (loginModuleName == null || loginModuleName.length() == 0) {
            throw new IllegalArgumentException("module name cannot be null nor empty");
        }
        if (LoginModuleControlFlag.OPTIONAL != controlFlag && LoginModuleControlFlag.REQUIRED != controlFlag && LoginModuleControlFlag.REQUISITE != controlFlag && LoginModuleControlFlag.SUFFICIENT != controlFlag) {
            throw new IllegalArgumentException("invalid controlFlag");
        }
        if (options == null) {
            throw new IllegalArgumentException("options cannot be null");
        }
        this.loginModuleName = loginModuleName;
        this.controlFlag = controlFlag;
        this.options = Collections.unmodifiableMap(new HashMap(options));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class LoginModuleControlFlag {
        public static final LoginModuleControlFlag OPTIONAL = new LoginModuleControlFlag();
        public static final LoginModuleControlFlag REQUIRED = new LoginModuleControlFlag();
        public static final LoginModuleControlFlag REQUISITE = new LoginModuleControlFlag();
        public static final LoginModuleControlFlag SUFFICIENT = new LoginModuleControlFlag();
        static /* synthetic */ Class class$javax$security$auth$login$AppConfigurationEntry$LoginModuleControlFlag;

        public String toString() {
            Class clazz = class$javax$security$auth$login$AppConfigurationEntry$LoginModuleControlFlag;
            if (clazz == null) {
                clazz = class$javax$security$auth$login$AppConfigurationEntry$LoginModuleControlFlag = LoginModuleControlFlag.class("[Ljavax.security.auth.login.AppConfigurationEntry$LoginModuleControlFlag;", false);
            }
            StringBuffer buf = new StringBuffer(clazz.getName());
            buf.append('.');
            if (this == OPTIONAL) {
                buf.append("OPTIONAL");
            } else if (this == REQUIRED) {
                buf.append("REQUIRED");
            } else if (this == REQUISITE) {
                buf.append("REQUISITE");
            } else if (this == SUFFICIENT) {
                buf.append("SUFFICIENT");
            } else {
                buf.append("HARVEY_THE_RABBIT");
            }
            return buf.toString();
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError().initCause(classNotFoundException);
            }
        }

        private LoginModuleControlFlag() {
        }
    }
}

