/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.JTextComponent;
import javax.swing.text.LabelView;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class StyledEditorKit
extends DefaultEditorKit {
    private static final long serialVersionUID = 7002391892985555948L;
    Element currentRun;
    MutableAttributeSet inputAttributes = new SimpleAttributeSet();
    CaretTracker caretTracker;
    StyledViewFactory viewFactory;

    public Object clone() {
        StyledEditorKit clone = (StyledEditorKit)super.clone();
        return clone;
    }

    public Action[] getActions() {
        Action[] actions1 = super.getActions();
        Action[] myActions = new Action[]{new BoldAction(), new ItalicAction(), new UnderlineAction()};
        return TextAction.augmentList(actions1, myActions);
    }

    public MutableAttributeSet getInputAttributes() {
        return this.inputAttributes;
    }

    public Element getCharacterAttributeRun() {
        return this.currentRun;
    }

    public Document createDefaultDocument() {
        return new DefaultStyledDocument();
    }

    public void install(JEditorPane component) {
        CaretTracker tracker = new CaretTracker();
        component.addCaretListener(tracker);
    }

    public void deinstall(JEditorPane component) {
        CaretTracker t = this.caretTracker;
        if (t != null) {
            component.removeCaretListener(t);
        }
        this.caretTracker = null;
    }

    public ViewFactory getViewFactory() {
        if (this.viewFactory == null) {
            this.viewFactory = new StyledViewFactory();
        }
        return this.viewFactory;
    }

    protected void createInputAttributes(Element element, MutableAttributeSet set) {
        AttributeSet atts = element.getAttributes();
        set.removeAttributes(set);
        set.addAttributes(atts);
    }

    public static class BoldAction
    extends StyledTextAction {
        public void actionPerformed(ActionEvent event) {
            JEditorPane editor = this.getEditor(event);
            StyledDocument doc = this.getStyledDocument(editor);
            Element el = doc.getCharacterElement(editor.getSelectionStart());
            boolean isBold = StyleConstants.isBold(el.getAttributes());
            SimpleAttributeSet atts = new SimpleAttributeSet();
            StyleConstants.setItalic(atts, isBold ^ true);
            this.setCharacterAttributes(editor, atts, false);
        }

        public BoldAction() {
            super("TODO");
        }
    }

    public static class ItalicAction
    extends StyledTextAction {
        public void actionPerformed(ActionEvent event) {
            JEditorPane editor = this.getEditor(event);
            StyledDocument doc = this.getStyledDocument(editor);
            Element el = doc.getCharacterElement(editor.getSelectionStart());
            boolean isItalic = StyleConstants.isItalic(el.getAttributes());
            SimpleAttributeSet atts = new SimpleAttributeSet();
            StyleConstants.setItalic(atts, isItalic ^ true);
            this.setCharacterAttributes(editor, atts, false);
        }

        public ItalicAction() {
            super("TODO");
        }
    }

    public static class UnderlineAction
    extends StyledTextAction {
        public void actionPerformed(ActionEvent event) {
            JEditorPane editor = this.getEditor(event);
            StyledDocument doc = this.getStyledDocument(editor);
            Element el = doc.getCharacterElement(editor.getSelectionStart());
            boolean isUnderline = StyleConstants.isUnderline(el.getAttributes());
            SimpleAttributeSet atts = new SimpleAttributeSet();
            StyleConstants.setUnderline(atts, isUnderline ^ true);
            this.setCharacterAttributes(editor, atts, false);
        }

        public UnderlineAction() {
            super("TODO");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CaretTracker
    implements CaretListener {
        public void caretUpdate(CaretEvent ev) {
            Object source = ev.getSource();
            if (!(source instanceof JTextComponent)) {
                throw new AssertionError((Object)"CaretEvents are expected to come from aJTextComponent.");
            }
            JTextComponent text = (JTextComponent)source;
            Document doc = text.getDocument();
            if (!(doc instanceof StyledDocument)) {
                throw new AssertionError((Object)"The Document used by StyledEditorKits isexpected to be a StyledDocument");
            }
            StyledDocument styleDoc = (StyledDocument)doc;
            StyledEditorKit.this.currentRun = styleDoc.getCharacterElement(ev.getDot());
            StyledEditorKit.this.createInputAttributes(StyledEditorKit.this.currentRun, StyledEditorKit.this.inputAttributes);
        }

        CaretTracker() {
        }
    }

    static class StyledViewFactory
    implements ViewFactory {
        public View create(Element element) {
            String name = element.getName();
            View view = null;
            if (name.equals("content")) {
                view = new LabelView(element);
            } else if (name.equals("paragraph")) {
                view = new ParagraphView(element);
            } else if (name.equals("section")) {
                view = new BoxView(element, 1);
            } else if (name.equals("component")) {
                view = new ComponentView(element);
            } else if (name.equals("icon")) {
                view = new IconView(element);
            } else {
                throw new AssertionError((Object)("Unknown Element type: " + element.getClass().getName() + " : " + name));
            }
            return view;
        }

        StyledViewFactory() {
        }
    }

    public static abstract class StyledTextAction
    extends TextAction {
        protected final JEditorPane getEditor(ActionEvent event) {
            return (JEditorPane)this.getTextComponent(event);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final void setCharacterAttributes(JEditorPane editor, AttributeSet atts, boolean replace) {
            Document doc = editor.getDocument();
            if (!(doc instanceof StyledDocument)) throw new AssertionError((Object)"The Document for StyledTextActions is expected to be a StyledDocument.");
            StyledDocument styleDoc = (StyledDocument)editor.getDocument();
            EditorKit kit = editor.getEditorKit();
            if (kit instanceof StyledEditorKit) throw new AssertionError((Object)"The EditorKit for StyledTextActions is expected to be a StyledEditorKit");
            StyledEditorKit styleKit = (StyledEditorKit)kit;
            int start = editor.getSelectionStart();
            int end = editor.getSelectionEnd();
            int dot = editor.getCaret().getDot();
            if (start == dot && end == dot) {
                MutableAttributeSet inputAttributes = styleKit.getInputAttributes();
                inputAttributes.addAttributes(atts);
                return;
            } else {
                styleDoc.setCharacterAttributes(start, end, atts, replace);
            }
        }

        protected final StyledDocument getStyledDocument(JEditorPane editor) {
            Document doc = editor.getDocument();
            if (!(doc instanceof StyledDocument)) {
                throw new AssertionError((Object)"The Document for StyledEditorKits is expected to be a StyledDocument.");
            }
            return (StyledDocument)doc;
        }

        protected final StyledEditorKit getStyledEditorKit(JEditorPane editor) {
            EditorKit kit = editor.getEditorKit();
            if (!(kit instanceof StyledEditorKit)) {
                throw new AssertionError((Object)"The EditorKit for StyledDocuments is expected to be a StyledEditorKit.");
            }
            return (StyledEditorKit)kit;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final void setParagraphAttributes(JEditorPane editor, AttributeSet atts, boolean replace) {
            Document doc = editor.getDocument();
            if (!(doc instanceof StyledDocument)) throw new AssertionError((Object)"The Document for StyledTextActions is expected to be a StyledDocument.");
            StyledDocument styleDoc = (StyledDocument)editor.getDocument();
            EditorKit kit = editor.getEditorKit();
            if (kit instanceof StyledEditorKit) throw new AssertionError((Object)"The EditorKit for StyledTextActions is expected to be a StyledEditorKit");
            StyledEditorKit styleKit = (StyledEditorKit)kit;
            int start = editor.getSelectionStart();
            int end = editor.getSelectionEnd();
            int dot = editor.getCaret().getDot();
            if (start == dot && end == dot) {
                MutableAttributeSet inputAttributes = styleKit.getInputAttributes();
                inputAttributes.addAttributes(atts);
                return;
            } else {
                styleDoc.setParagraphAttributes(start, end, atts, replace);
            }
        }

        public StyledTextAction(String nm) {
            super(nm);
        }
    }

    public static class FontFamilyAction
    extends StyledTextAction {
        private String family;

        public void actionPerformed(ActionEvent event) {
            SimpleAttributeSet atts = new SimpleAttributeSet();
            StyleConstants.setFontFamily(atts, this.family);
            this.setCharacterAttributes(this.getEditor(event), atts, false);
        }

        public FontFamilyAction(String nm, String family) {
            super(nm);
            this.family = family;
        }
    }

    public static class FontSizeAction
    extends StyledTextAction {
        private int size;

        public void actionPerformed(ActionEvent event) {
            SimpleAttributeSet atts = new SimpleAttributeSet();
            StyleConstants.setFontSize(atts, this.size);
            this.setCharacterAttributes(this.getEditor(event), atts, false);
        }

        public FontSizeAction(String nm, int size) {
            super(nm);
            this.size = size;
        }
    }

    public static class ForegroundAction
    extends StyledTextAction {
        private Color fg;

        public void actionPerformed(ActionEvent event) {
            SimpleAttributeSet atts = new SimpleAttributeSet();
            StyleConstants.setForeground(atts, this.fg);
            this.setCharacterAttributes(this.getEditor(event), atts, false);
        }

        public ForegroundAction(String nm, Color fg) {
            super(nm);
            this.fg = fg;
        }
    }

    public static class AlignmentAction
    extends StyledTextAction {
        private int a;

        public void actionPerformed(ActionEvent event) {
            SimpleAttributeSet atts = new SimpleAttributeSet();
            StyleConstants.setAlignment(atts, this.a);
            this.setParagraphAttributes(this.getEditor(event), atts, false);
        }

        public AlignmentAction(String nm, int a) {
            super(nm);
            this.a = a;
        }
    }
}

