/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.evpull.BlockEventIterator;
import net.sf.saxon.evpull.EmptyEventIterator;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.SubExpressionInfo;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.BlockIterator;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TailCallReturner;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.SequenceExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Block
extends Instruction {
    private Expression[] children;
    private boolean allNodesUntyped;

    public static Expression makeBlock(Expression e1, Expression e2) {
        if (e1 == null || Literal.isEmptySequence(e1)) {
            return e2;
        }
        if (e2 == null || Literal.isEmptySequence(e2)) {
            return e1;
        }
        if (e1 instanceof Block || e2 instanceof Block) {
            MonoIterator<Expression> it1 = e1 instanceof Block ? e1.iterateSubExpressions() : new MonoIterator<Expression>(e1);
            MonoIterator<Expression> it2 = e2 instanceof Block ? e2.iterateSubExpressions() : new MonoIterator<Expression>(e2);
            ArrayList list = new ArrayList(10);
            while (it1.hasNext()) {
                list.add(it1.next());
            }
            while (it2.hasNext()) {
                list.add(it2.next());
            }
            Expression[] exps = new Expression[list.size()];
            exps = list.toArray(exps);
            Block b = new Block();
            b.setChildren(exps);
            return b;
        }
        Expression[] exps = new Expression[]{e1, e2};
        Block b = new Block();
        b.setChildren(exps);
        return b;
    }

    public static Expression makeBlock(List<Expression> list) {
        if (list.size() == 0) {
            return Literal.makeEmptySequence();
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        Expression[] exps = new Expression[list.size()];
        exps = list.toArray(exps);
        Block b = new Block();
        b.setChildren(exps);
        return b;
    }

    public void setChildren(Expression[] children) {
        this.children = children;
        for (Expression aChildren : children) {
            this.adoptChildExpression(aChildren);
        }
    }

    @Override
    public String getExpressionName() {
        return "sequence";
    }

    public Expression[] getChildren() {
        return this.children;
    }

    @Override
    public int computeSpecialProperties() {
        if (this.children.length == 0) {
            return 0xEFF0000;
        }
        int p = super.computeSpecialProperties();
        if (this.allNodesUntyped) {
            p |= 0x4000000;
        }
        boolean allAxisExpressions = true;
        boolean allChildAxis = true;
        boolean allSubtreeAxis = true;
        for (Expression child : this.children) {
            if (!(child instanceof AxisExpression)) {
                allAxisExpressions = false;
                allChildAxis = false;
                allSubtreeAxis = false;
                break;
            }
            byte axis = ((AxisExpression)child).getAxis();
            if (axis != 3) {
                allChildAxis = false;
            }
            if (AxisInfo.isSubtreeAxis[axis]) continue;
            allSubtreeAxis = false;
        }
        if (allAxisExpressions) {
            p |= 0xC10000;
            if (allChildAxis) {
                p |= 0x80000;
            }
            if (allSubtreeAxis) {
                p |= 0x100000;
            }
            if (this.children.length == 2 && ((AxisExpression)this.children[0]).getAxis() == 2 && ((AxisExpression)this.children[1]).getAxis() == 3) {
                p |= 0x20000;
            }
        }
        return p;
    }

    private boolean mayReturnTypedNodes(TypeHierarchy th) {
        for (Expression exp : this.children) {
            ItemType it;
            if ((exp.getSpecialProperties() & 0x4000000) != 0 || th.relationship(it = exp.getItemType(th), NodeKindTest.ELEMENT) == 4 && th.relationship(it, NodeKindTest.ATTRIBUTE) == 4 && th.relationship(it, NodeKindTest.ATTRIBUTE) == 4) continue;
            return true;
        }
        return false;
    }

    public Expression mergeAdjacentTextInstructions() {
        boolean[] isLiteralText = new boolean[this.children.length];
        boolean hasAdjacentTextNodes = false;
        for (int i = 0; i < this.children.length; ++i) {
            boolean bl = isLiteralText[i] = this.children[i] instanceof ValueOf && ((ValueOf)this.children[i]).getContentExpression() instanceof StringLiteral && !((ValueOf)this.children[i]).isDisableOutputEscaping();
            if (i <= 0 || !isLiteralText[i] || !isLiteralText[i - 1]) continue;
            hasAdjacentTextNodes = true;
        }
        if (hasAdjacentTextNodes) {
            ArrayList<Expression> content = new ArrayList<Expression>(this.children.length);
            String pendingText = null;
            for (int i = 0; i < this.children.length; ++i) {
                if (isLiteralText[i]) {
                    pendingText = (pendingText == null ? "" : pendingText) + ((StringLiteral)((ValueOf)this.children[i]).getContentExpression()).getStringValue();
                    continue;
                }
                if (pendingText != null) {
                    ValueOf inst = new ValueOf(new StringLiteral(pendingText), false, false);
                    content.add(inst);
                    pendingText = null;
                }
                content.add(this.children[i]);
            }
            if (pendingText != null) {
                ValueOf inst = new ValueOf(new StringLiteral(pendingText), false, false);
                content.add(inst);
            }
            return Block.makeBlock(content);
        }
        return this;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return Arrays.asList(this.children).iterator();
    }

    @Override
    public Iterator<SubExpressionInfo> iterateSubExpressionInfo() {
        ArrayList<SubExpressionInfo> info = new ArrayList<SubExpressionInfo>(this.children.length);
        for (Expression child : this.children) {
            info.add(new SubExpressionInfo(child, true, false, 2));
        }
        return info.iterator();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        for (int c = 0; c < this.children.length; ++c) {
            if (this.children[c] != original) continue;
            this.children[c] = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public Expression copy() {
        int c;
        Block b2 = new Block();
        Expression[] c2 = new Expression[this.children.length];
        b2.children = c2;
        for (c = 0; c < this.children.length; ++c) {
            c2[c] = this.children[c].copy();
        }
        b2.children = c2;
        for (c = 0; c < this.children.length; ++c) {
            b2.adoptChildExpression(c2[c]);
        }
        b2.allNodesUntyped = this.allNodesUntyped;
        ExpressionTool.copyLocationInfo(this, b2);
        return b2;
    }

    @Override
    public final ItemType getItemType(TypeHierarchy th) {
        if (this.children.length == 0) {
            return EmptySequenceTest.getInstance();
        }
        ItemType t1 = this.children[0].getItemType(th);
        for (int i = 1; i < this.children.length; ++i) {
            if (!((t1 = Type.getCommonSuperType(t1, this.children[i].getItemType(th), th)) instanceof AnyItemType)) continue;
            return t1;
        }
        return t1;
    }

    @Override
    public final int getCardinality() {
        if (this.children.length == 0) {
            return 8192;
        }
        int c1 = this.children[0].getCardinality();
        for (int i = 1; i < this.children.length && (c1 = Cardinality.sum(c1, this.children[i].getCardinality())) != 57344; ++i) {
        }
        return c1;
    }

    @Override
    public final boolean createsNewNodes() {
        for (Expression aChildren : this.children) {
            int props = aChildren.getSpecialProperties();
            if ((props & 0x400000) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkForUpdatingSubexpressions() throws XPathException {
        if (this.children.length < 2) {
            return;
        }
        boolean updating = false;
        boolean nonUpdating = false;
        for (Expression child : this.children) {
            if (!ExpressionTool.isAllowedInUpdatingContext(child)) {
                if (updating) {
                    XPathException err = new XPathException("If any subexpression is updating, then all must be updating", "XUST0001");
                    err.setLocator(child);
                    throw err;
                }
                nonUpdating = true;
            }
            if (!child.isUpdatingExpression()) continue;
            if (nonUpdating) {
                XPathException err = new XPathException("If any subexpression is updating, then all must be updating", "XUST0001");
                err.setLocator(child);
                throw err;
            }
            updating = true;
        }
    }

    @Override
    public boolean isVacuousExpression() {
        for (Expression child : this.children) {
            if (child.isVacuousExpression()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        boolean allAtomic = true;
        boolean nested = false;
        for (int c = 0; c < this.children.length; ++c) {
            this.children[c] = visitor.simplify(this.children[c]);
            if (!Literal.isAtomic(this.children[c])) {
                allAtomic = false;
            }
            if (this.children[c] instanceof Block) {
                nested = true;
                continue;
            }
            if (!Literal.isEmptySequence(this.children[c])) continue;
            nested = true;
        }
        if (this.children.length == 1) {
            return this.getChildren()[0];
        }
        if (this.children.length == 0) {
            Literal result = Literal.makeEmptySequence();
            ExpressionTool.copyLocationInfo(this, result);
            return result;
        }
        if (nested) {
            ArrayList<Expression> list = new ArrayList<Expression>(this.children.length * 2);
            this.flatten(list);
            this.children = new Expression[list.size()];
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i] = (Expression)list.get(i);
                this.adoptChildExpression(this.children[i]);
            }
        }
        if (allAtomic) {
            Item[] values = new AtomicValue[this.children.length];
            for (int c = 0; c < this.children.length; ++c) {
                values[c] = (AtomicValue)((Literal)this.children[c]).getValue();
            }
            Literal result = Literal.makeLiteral(new SequenceExtent(values));
            ExpressionTool.copyLocationInfo(this, result);
            return result;
        }
        return this;
    }

    private void flatten(List<Expression> targetList) throws XPathException {
        ArrayList<Item> currentLiteralList = null;
        for (Expression child : this.children) {
            if (Literal.isEmptySequence(child)) continue;
            if (child instanceof Block) {
                this.flushCurrentLiteralList(currentLiteralList, targetList);
                currentLiteralList = null;
                ((Block)child).flatten(targetList);
                continue;
            }
            if (child instanceof Literal && !(((Literal)child).getValue() instanceof IntegerRange)) {
                Item item;
                SequenceIterator<? extends Item> iterator = ((Literal)child).getValue().iterate();
                if (currentLiteralList == null) {
                    currentLiteralList = new ArrayList<Item>(10);
                }
                while ((item = iterator.next()) != null) {
                    currentLiteralList.add(item);
                }
                continue;
            }
            this.flushCurrentLiteralList(currentLiteralList, targetList);
            currentLiteralList = null;
            targetList.add(child);
        }
        this.flushCurrentLiteralList(currentLiteralList, targetList);
    }

    public boolean isCandidateForSharedAppend() {
        for (Expression exp : this.children) {
            if (!(exp instanceof VariableReference) && !(exp instanceof Literal)) continue;
            return true;
        }
        return false;
    }

    private void flushCurrentLiteralList(List<Item> currentLiteralList, List<Expression> list) throws XPathException {
        if (currentLiteralList != null) {
            ListIterator<Item> iter = new ListIterator<Item>(currentLiteralList);
            list.add(Literal.makeLiteral(SequenceExtent.makeSequenceExtent(iter)));
        }
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        for (int c = 0; c < this.children.length; ++c) {
            this.children[c] = visitor.typeCheck(this.children[c], contextItemType);
            this.adoptChildExpression(this.children[c]);
        }
        if (!this.mayReturnTypedNodes(visitor.getConfiguration().getTypeHierarchy())) {
            this.resetLocalStaticProperties();
            this.allNodesUntyped = true;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        for (int c = 0; c < this.children.length; ++c) {
            this.children[c] = visitor.optimize(this.children[c], contextItemType);
            this.adoptChildExpression(this.children[c]);
        }
        boolean canSimplify = false;
        boolean prevLiteral = false;
        for (Expression child : this.children) {
            if (child instanceof Block) {
                canSimplify = true;
                break;
            }
            if (child instanceof Literal) {
                if (prevLiteral || Literal.isEmptySequence(child)) {
                    canSimplify = true;
                    break;
                }
                prevLiteral = true;
                continue;
            }
            prevLiteral = false;
        }
        if (canSimplify) {
            ArrayList<Expression> list = new ArrayList<Expression>(this.children.length * 2);
            this.flatten(list);
            this.children = new Expression[list.size()];
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i] = (Expression)list.get(i);
                this.adoptChildExpression(this.children[i]);
            }
        }
        if (this.children.length == 0) {
            return Literal.makeEmptySequence();
        }
        if (this.children.length == 1) {
            return this.children[0];
        }
        return this;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        for (int c = 0; c < this.children.length; ++c) {
            this.children[c] = this.doPromotion(this.children[c], offer);
        }
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        for (Expression child : this.children) {
            child.checkPermittedContents(parentType, env, false);
        }
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("sequence");
        for (Expression child : this.children) {
            child.explain(out);
        }
        out.endElement();
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        TailCall tc = null;
        for (Expression child : this.children) {
            try {
                if (child instanceof TailCallReturner) {
                    tc = ((TailCallReturner)((Object)child)).processLeavingTail(context);
                    continue;
                }
                child.process(context);
                tc = null;
            }
            catch (XPathException e) {
                e.maybeSetLocation(child);
                e.maybeSetContext(context);
                throw e;
            }
        }
        return tc;
    }

    @Override
    public int getImplementationMethod() {
        return 6;
    }

    @Override
    public SequenceIterator<? extends Item> iterate(XPathContext context) throws XPathException {
        if (this.children.length == 0) {
            return EmptyIterator.emptyIterator();
        }
        if (this.children.length == 1) {
            return this.children[0].iterate(context);
        }
        return new BlockIterator(this.children, context);
    }

    @Override
    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        if (this.children.length == 0) {
            return EmptyEventIterator.getInstance();
        }
        if (this.children.length == 1) {
            return this.children[0].iterateEvents(context);
        }
        return new BlockEventIterator(this.children, context);
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        for (Expression child : this.children) {
            child.evaluatePendingUpdates(context, pul);
        }
    }
}

